/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.ScopedMock;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.IndependentAnnotationEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;
import org.mockito.plugins.AnnotationEngine;

public class InjectingAnnotationEngine
implements AnnotationEngine {
    private final AnnotationEngine delegate = new IndependentAnnotationEngine();
    private final AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    public AutoCloseable process(Class<?> clazz, Object testInstance) {
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        closeables.addAll(this.processIndependentAnnotations(testInstance.getClass(), testInstance));
        closeables.addAll(this.processInjectMocks(testInstance.getClass(), testInstance));
        return () -> {
            for (AutoCloseable closeable : closeables) {
                closeable.close();
            }
        };
    }

    private List<AutoCloseable> processInjectMocks(Class<?> clazz, Object testInstance) {
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            closeables.add(this.injectCloseableMocks(testInstance));
        }
        return closeables;
    }

    private List<AutoCloseable> processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            closeables.add(this.delegate.process(classContext, testInstance));
            closeables.add(this.spyAnnotationEngine.process(classContext, testInstance));
        }
        return closeables;
    }

    @Deprecated
    public void injectMocks(Object testClassInstance) {
        try {
            this.injectCloseableMocks(testClassInstance).close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private AutoCloseable injectCloseableMocks(Object testClassInstance) {
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
            this.onInjection(testClassInstance, clazz, mockDependentFields, mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
        return () -> {
            for (Object mock : mocks) {
                if (!(mock instanceof ScopedMock)) continue;
                ((ScopedMock)mock).closeOnDemand();
            }
        };
    }

    protected void onInjection(Object testClassInstance, Class<?> clazz, Set<Field> mockDependentFields, Set<Object> mocks) {
    }
}

