/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestUnloadAccessController
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUnloadAccessController.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TEST_TABLE = TableName.valueOf((String)"TestUnloadAccessController");
    private static Permission permission = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
    private static Admin admin;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllSystemRegionsAssigned();
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGrant() {
        try {
            admin.grant(new UserPermission("user", permission), false);
            Assert.fail((String)"Expected UnsupportedOperationException but not found");
        }
        catch (Throwable e) {
            this.checkException(e);
        }
    }

    @Test
    public void testRevoke() {
        try {
            admin.revoke(new UserPermission("user", permission));
            Assert.fail((String)"Expected UnsupportedOperationException but not found");
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.checkException(e);
        }
    }

    @Test
    public void testGetUserPermissions() {
        try {
            admin.getUserPermissions(GetUserPermissionsRequest.newBuilder().build());
            Assert.fail((String)"Expected UnsupportedOperationException but not found");
        }
        catch (Throwable e) {
            this.checkException(e);
        }
    }

    @Test
    public void testHasUserPermission() {
        try {
            ArrayList<Permission> permissionList = new ArrayList<Permission>();
            permissionList.add(permission);
            admin.hasUserPermissions(permissionList);
            Assert.fail((String)"Expected UnsupportedOperationException but not found");
        }
        catch (Throwable e) {
            this.checkException(e);
        }
    }

    private void checkException(Throwable e) {
        if (e instanceof DoNotRetryIOException && e.getMessage().contains(UnsupportedOperationException.class.getName())) {
            return;
        }
        Assert.fail((String)("Expected UnsupportedOperationException but found " + e.getMessage()));
    }
}

