/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationThrottler;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationThrottler {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationThrottler.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationThrottler.class);

    @Test
    public void testThrottling() {
        LOG.info("testThrottling");
        ReplicationThrottler throttler1 = new ReplicationThrottler(100.0);
        ReplicationThrottler throttler2 = new ReplicationThrottler(10.0);
        long ticks1 = throttler1.getNextSleepInterval(1000);
        long ticks2 = throttler2.getNextSleepInterval(1000);
        Assert.assertEquals((long)0L, (long)ticks1);
        Assert.assertEquals((long)0L, (long)ticks2);
        throttler1.addPushSize(1000L);
        throttler2.addPushSize(1000L);
        ticks1 = throttler1.getNextSleepInterval(5);
        ticks2 = throttler2.getNextSleepInterval(5);
        if (ticks1 != 1000L && ticks1 != 999L) {
            Assert.assertTrue((ticks1 >= 750L && ticks1 <= 1000L ? 1 : 0) != 0);
        }
        if (ticks2 != 10000L && ticks2 != 9999L) {
            Assert.assertTrue((ticks2 >= 7500L && ticks2 <= 10000L ? 1 : 0) != 0);
        }
        throttler1.resetStartTick();
        throttler2.resetStartTick();
        throttler1.addPushSize(5L);
        throttler2.addPushSize(5L);
        ticks1 = throttler1.getNextSleepInterval(45);
        ticks2 = throttler2.getNextSleepInterval(45);
        Assert.assertTrue((ticks1 == 0L ? 1 : 0) != 0);
        if (ticks2 != 100L && ticks2 != 99L) {
            Assert.assertTrue((ticks1 >= 75L && ticks1 <= 100L ? 1 : 0) != 0);
        }
        throttler2.resetStartTick();
        throttler1.addPushSize(45L);
        throttler2.addPushSize(45L);
        ticks1 = throttler1.getNextSleepInterval(60);
        ticks2 = throttler2.getNextSleepInterval(60);
        if (ticks1 != 100L && ticks1 != 99L) {
            Assert.assertTrue((ticks1 >= 75L && ticks1 <= 100L ? 1 : 0) != 0);
        }
        if (ticks2 != 500L && ticks2 != 499L) {
            Assert.assertTrue((ticks1 >= 375L && ticks1 <= 500L ? 1 : 0) != 0);
        }
    }
}

