/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.TestSourceFSConfigurationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSink {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSink.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSink.class);
    private static final int BATCH_SIZE = 10;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static ReplicationSink SINK;
    protected static final TableName TABLE_NAME1;
    protected static final TableName TABLE_NAME2;
    protected static final byte[] FAM_NAME1;
    protected static final byte[] FAM_NAME2;
    protected static Table table1;
    protected static Stoppable STOPPABLE;
    protected static Table table2;
    protected static String baseNamespaceDir;
    protected static String hfileArchiveDir;
    protected static String replicationClusterId;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.replication.source.fs.conf.provider", TestSourceFSConfigurationProvider.class.getCanonicalName());
        TEST_UTIL.startMiniCluster(3);
        RegionServerCoprocessorHost rsCpHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        SINK = new ReplicationSink(new Configuration(TEST_UTIL.getConfiguration()), rsCpHost);
        table1 = TEST_UTIL.createTable(TABLE_NAME1, FAM_NAME1);
        table2 = TEST_UTIL.createTable(TABLE_NAME2, FAM_NAME2);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration());
        baseNamespaceDir = new Path(rootDir, new Path("data")).toString();
        hfileArchiveDir = new Path(rootDir, new Path("archive")).toString();
        replicationClusterId = "12345";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        STOPPABLE.stop("Shutting down");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        table1 = TEST_UTIL.deleteTableData(TABLE_NAME1);
        table2 = TEST_UTIL.deleteTableData(TABLE_NAME2);
    }

    @Test
    public void testBatchSink() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(10);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)10L, (long)scanRes.next(10).length);
    }

    @Test
    public void testMixedPutDelete() throws Exception {
        int i;
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Object> cells = new ArrayList<Cell>();
        for (i = 0; i < 5; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        entries = new ArrayList(10);
        cells = new ArrayList();
        for (i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, i % 2 != 0 ? KeyValue.Type.Put : KeyValue.Type.DeleteColumn, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)5L, (long)scanRes.next(10).length);
    }

    @Test
    public void testLargeEditsPutDelete() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>();
        ArrayList<Object> cells = new ArrayList<Cell>();
        for (int i = 0; i < 5510; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        ResultScanner resultScanner = table1.getScanner(new Scan());
        int totalRows = 0;
        while (resultScanner.next() != null) {
            ++totalRows;
        }
        Assert.assertEquals((long)5510L, (long)totalRows);
        entries = new ArrayList();
        cells = new ArrayList();
        for (int i = 0; i < 11000; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, i % 2 != 0 ? KeyValue.Type.Put : KeyValue.Type.DeleteColumn, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        resultScanner = table1.getScanner(new Scan());
        totalRows = 0;
        while (resultScanner.next() != null) {
            ++totalRows;
        }
        Assert.assertEquals((long)5500L, (long)totalRows);
    }

    @Test
    public void testMixedPutTables() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(i % 2 == 0 ? TABLE_NAME2 : TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        Scan scan = new Scan();
        ResultScanner scanRes = table2.getScanner(scan);
        for (Result res : scanRes) {
            Assert.assertEquals((long)0L, (long)(Bytes.toInt((byte[])res.getRow()) % 2));
        }
        scanRes = table1.getScanner(scan);
        for (Result res : scanRes) {
            Assert.assertEquals((long)1L, (long)(Bytes.toInt((byte[])res.getRow()) % 2));
        }
    }

    @Test
    public void testMixedDeletes() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(3);
        ArrayList<Object> cells = new ArrayList<Cell>();
        for (int i = 0; i < 3; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        entries = new ArrayList(3);
        cells = new ArrayList();
        entries.add(this.createEntry(TABLE_NAME1, 0, KeyValue.Type.DeleteColumn, cells));
        entries.add(this.createEntry(TABLE_NAME1, 1, KeyValue.Type.DeleteFamily, cells));
        entries.add(this.createEntry(TABLE_NAME1, 2, KeyValue.Type.DeleteColumn, cells));
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)0L, (long)scanRes.next(3).length);
    }

    @Test
    public void testApplyDeleteBeforePut() throws Exception {
        int i;
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (i = 0; i < 2; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        entries.add(this.createEntry(TABLE_NAME1, 1, KeyValue.Type.DeleteFamily, cells));
        for (i = 3; i < 5; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        Get get = new Get(Bytes.toBytes((int)1));
        Result res = table1.get(get);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testRethrowRetriesExhaustedWithDetailsException() throws Exception {
        TableName notExistTable = TableName.valueOf((String)"notExistTable");
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>();
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(notExistTable, i, KeyValue.Type.Put, cells));
        }
        try {
            SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
            Assert.fail((String)"Should re-throw TableNotFoundException.");
        }
        catch (TableNotFoundException i) {
            // empty catch block
        }
        entries.clear();
        cells.clear();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Admin admin = conn.getAdmin();){
            admin.disableTable(TABLE_NAME1);
            try {
                SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
                Assert.fail((String)"Should re-throw RetriesExhaustedException.");
                return;
            }
            catch (RetriesExhaustedException retriesExhaustedException) {
                return;
            }
            finally {
                admin.enableTable(TABLE_NAME1);
            }
        }
    }

    @Test
    public void testReplicateEntriesForHFiles() throws Exception {
        Throwable throwable;
        Path dir = TEST_UTIL.getDataTestDirOnTestFS("testReplicateEntries");
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAM_NAME1));
        int numRows = 10;
        ArrayList<Path> p = new ArrayList<Path>(1);
        String hfilePrefix = "hfile-";
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        HashSet<Integer> numbers = new HashSet<Integer>();
        while (numbers.size() < 50) {
            numbers.add(((Random)rand).nextInt(1000));
        }
        ArrayList numberList = new ArrayList(numbers);
        Collections.sort(numberList);
        HashMap<String, Long> storeFilesSize = new HashMap<String, Long>(1);
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = dir.getFileSystem(conf);
        Iterator numbersItr = numberList.iterator();
        for (int i = 0; i < 25; ++i) {
            Path hfilePath = new Path(familyDir, "hfile-" + i);
            HFileTestUtil.createHFile(conf, fs, hfilePath, FAM_NAME1, FAM_NAME1, Bytes.toBytes((int)((Integer)numbersItr.next())), Bytes.toBytes((int)((Integer)numbersItr.next())), numRows);
            p.add(hfilePath);
            storeFilesSize.put(hfilePath.getName(), fs.getFileStatus(hfilePath).getLen());
        }
        HashMap<byte[], ArrayList<Path>> storeFiles = new HashMap<byte[], ArrayList<Path>>(1);
        storeFiles.put(FAM_NAME1, p);
        WALEdit edit = null;
        WALProtos.BulkLoadDescriptor loadDescriptor = null;
        try (Connection c = ConnectionFactory.createConnection((Configuration)conf);){
            throwable = null;
            try (RegionLocator l = c.getRegionLocator(TABLE_NAME1);){
                HRegionInfo regionInfo = ((HRegionLocation)l.getAllRegionLocations().get(0)).getRegionInfo();
                loadDescriptor = ProtobufUtil.toBulkLoadDescriptor((TableName)TABLE_NAME1, (ByteString)UnsafeByteOperations.unsafeWrap((byte[])regionInfo.getEncodedNameAsBytes()), storeFiles, storeFilesSize, (long)1L);
                edit = WALEdit.createBulkLoadEvent((RegionInfo)regionInfo, (WALProtos.BulkLoadDescriptor)loadDescriptor);
            }
            catch (Throwable regionInfo) {
                throwable = regionInfo;
                throw regionInfo;
            }
        }
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(1);
        AdminProtos.WALEntry.Builder builder = this.createWALEntryBuilder(TABLE_NAME1);
        for (int i = 0; i < 25; ++i) {
            String pathToHfileFromNS = new StringBuilder(100).append(TABLE_NAME1.getNamespaceAsString()).append("/").append(Bytes.toString((byte[])TABLE_NAME1.getName())).append("/").append(Bytes.toString((byte[])loadDescriptor.getEncodedRegionName().toByteArray())).append("/").append(Bytes.toString((byte[])FAM_NAME1)).append("/").append("hfile-" + i).toString();
            String dst = baseNamespaceDir + "/" + pathToHfileFromNS;
            Path dstPath = new Path(dst);
            FileUtil.copy((FileSystem)fs, (Path)((Path)p.get(0)), (FileSystem)fs, (Path)dstPath, (boolean)false, (Configuration)conf);
        }
        entries.add(builder.build());
        throwable = null;
        try (ResultScanner scanner = table1.getScanner(new Scan());){
            Assert.assertEquals((long)0L, (long)scanner.next(numRows).length);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(edit.getCells().iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
        scanner = table1.getScanner(new Scan());
        throwable = null;
        try {
            Assert.assertEquals((long)numRows, (long)scanner.next(numRows).length);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (scanner != null) {
                if (throwable != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedReplicationSinkMetrics() throws IOException {
        long initialFailedBatches = SINK.getSinkMetrics().getFailedBatches();
        long errorCount = 0L;
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(10);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        cells.clear();
        try {
            SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
            Assert.fail((String)"Should re-throw ArrayIndexOutOfBoundsException.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Assert.assertEquals((long)(initialFailedBatches + ++errorCount), (long)SINK.getSinkMetrics().getFailedBatches());
        }
        entries.clear();
        cells.clear();
        TableName notExistTable = TableName.valueOf((String)"notExistTable");
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(notExistTable, i, KeyValue.Type.Put, cells));
        }
        try {
            SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
            Assert.fail((String)"Should re-throw TableNotFoundException.");
        }
        catch (TableNotFoundException e) {
            Assert.assertEquals((long)(initialFailedBatches + ++errorCount), (long)SINK.getSinkMetrics().getFailedBatches());
        }
        entries.clear();
        cells.clear();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Admin admin = conn.getAdmin();){
            admin.disableTable(TABLE_NAME1);
            try {
                SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()), replicationClusterId, baseNamespaceDir, hfileArchiveDir);
                Assert.fail((String)"Should re-throw IOException.");
            }
            catch (IOException e) {
                Assert.assertEquals((long)(initialFailedBatches + ++errorCount), (long)SINK.getSinkMetrics().getFailedBatches());
            }
            finally {
                admin.enableTable(TABLE_NAME1);
            }
        }
    }

    private AdminProtos.WALEntry createEntry(TableName table, int row, KeyValue.Type type, List<Cell> cells) {
        byte[] fam = table.equals((Object)TABLE_NAME1) ? FAM_NAME1 : FAM_NAME2;
        byte[] rowBytes = Bytes.toBytes((int)row);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            LOG.info("Was interrupted while sleep, meh", (Throwable)e);
        }
        long now = EnvironmentEdgeManager.currentTime();
        KeyValue kv = null;
        if (type.getCode() == KeyValue.Type.Put.getCode()) {
            kv = new KeyValue(rowBytes, fam, fam, now, KeyValue.Type.Put, Bytes.toBytes((int)row));
        } else if (type.getCode() == KeyValue.Type.DeleteColumn.getCode()) {
            kv = new KeyValue(rowBytes, fam, fam, now, KeyValue.Type.DeleteColumn);
        } else if (type.getCode() == KeyValue.Type.DeleteFamily.getCode()) {
            kv = new KeyValue(rowBytes, fam, null, now, KeyValue.Type.DeleteFamily);
        }
        AdminProtos.WALEntry.Builder builder = this.createWALEntryBuilder(table);
        cells.add((Cell)kv);
        return builder.build();
    }

    private AdminProtos.WALEntry.Builder createWALEntryBuilder(TableName table) {
        AdminProtos.WALEntry.Builder builder = AdminProtos.WALEntry.newBuilder();
        builder.setAssociatedCellCount(1);
        WALProtos.WALKey.Builder keyBuilder = WALProtos.WALKey.newBuilder();
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        uuidBuilder.setLeastSigBits(HConstants.DEFAULT_CLUSTER_ID.getLeastSignificantBits());
        uuidBuilder.setMostSigBits(HConstants.DEFAULT_CLUSTER_ID.getMostSignificantBits());
        keyBuilder.setClusterId(uuidBuilder.build());
        keyBuilder.setTableName(UnsafeByteOperations.unsafeWrap((byte[])table.getName()));
        keyBuilder.setWriteTime(EnvironmentEdgeManager.currentTime());
        keyBuilder.setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])HConstants.EMPTY_BYTE_ARRAY));
        keyBuilder.setLogSequenceNumber(-1L);
        builder.setKey(keyBuilder.build());
        return builder;
    }

    static {
        TABLE_NAME1 = TableName.valueOf((String)"table1");
        TABLE_NAME2 = TableName.valueOf((String)"table2");
        FAM_NAME1 = Bytes.toBytes((String)"info1");
        FAM_NAME2 = Bytes.toBytes((String)"info2");
        STOPPABLE = new Stoppable(){
            final AtomicBoolean stop = new AtomicBoolean(false);

            public boolean isStopped() {
                return this.stop.get();
            }

            public void stop(String why) {
                LOG.info("STOPPING BECAUSE: " + why);
                this.stop.set(true);
            }
        };
    }
}

