/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.StoreFileListGenerator;

class SpikyFileListGenerator
extends StoreFileListGenerator {
    SpikyFileListGenerator() {
    }

    @Override
    public Iterator<List<HStoreFile>> iterator() {
        return new Iterator<List<HStoreFile>>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < 10;
            }

            @Override
            public List<HStoreFile> next() {
                ++this.count;
                ArrayList<HStoreFile> files = new ArrayList<HStoreFile>(1000);
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                for (int x = 0; x < 1000; ++x) {
                    int fileSize = ((Random)rand).nextInt(5) + 1;
                    if (x % 10 == 0) {
                        fileSize = ((Random)rand).nextInt(5) + 50;
                    }
                    files.add(SpikyFileListGenerator.this.createMockStoreFile(fileSize));
                }
                return files;
            }

            @Override
            public void remove() {
            }
        };
    }
}

