/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.CustomTieringMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MockHStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CustomDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerForTest;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCustomCellTieredCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCustomCellTieredCompactionPolicy.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    public static final byte[] FAMILY = Bytes.toBytes((String)"cf");

    private HStoreFile createFile(Path file, long minValue, long maxValue, long size, int seqId) throws IOException {
        return this.createFile(this.mockRegionInfo(), file, minValue, maxValue, size, seqId, 0L);
    }

    private HStoreFile createFile(RegionInfo regionInfo, Path file, long minValue, long maxValue, long size, int seqId, long ageInDisk) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        HRegionFileSystem regionFileSystem = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, file, regionInfo);
        StoreContext ctx = new StoreContext.Builder().withColumnFamilyDescriptor(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build()).withRegionFileSystem(regionFileSystem).build();
        StoreFileTrackerForTest sftForTest = new StoreFileTrackerForTest(TEST_UTIL.getConfiguration(), true, ctx);
        MockHStoreFile msf = new MockHStoreFile(TEST_UTIL, file, size, ageInDisk, false, (long)seqId, (StoreFileTracker)sftForTest);
        TimeRangeTracker timeRangeTracker = TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.NON_SYNC);
        timeRangeTracker.setMin(minValue);
        timeRangeTracker.setMax(maxValue);
        msf.setMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE, TimeRangeTracker.toByteArray((TimeRangeTracker)timeRangeTracker));
        return msf;
    }

    private CustomDateTieredCompactionPolicy mockAndCreatePolicy() throws Exception {
        RegionInfo mockedRegionInfo = this.mockRegionInfo();
        return this.mockAndCreatePolicy(mockedRegionInfo);
    }

    private CustomDateTieredCompactionPolicy mockAndCreatePolicy(RegionInfo regionInfo) throws Exception {
        StoreConfigInformation mockedStoreConfig = (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class);
        Mockito.when((Object)mockedStoreConfig.getRegionInfo()).thenReturn((Object)regionInfo);
        CustomDateTieredCompactionPolicy policy = new CustomDateTieredCompactionPolicy(TEST_UTIL.getConfiguration(), mockedStoreConfig);
        return policy;
    }

    private RegionInfo mockRegionInfo() {
        RegionInfo mockedRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockedRegionInfo.getEncodedName()).thenReturn((Object)"1234567890987654321");
        return mockedRegionInfo;
    }

    private Path preparePath() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path file = new Path(TEST_UTIL.getDataTestDir(), UUID.randomUUID().toString().replaceAll("-", ""));
        fs.create(file);
        return file;
    }

    @Test
    public void testGetCompactBoundariesForMajorNoOld() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        Assert.assertEquals((long)1L, (long)((DateTieredCompactionRequest)policy.selectMajorCompaction(files)).getBoundaries().size());
    }

    @Test
    public void testGetCompactBoundariesForMajorAllOld() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, 1L, 1024L, 0));
        files.add(this.createFile(file, 2L, 3L, 1024L, 1));
        Assert.assertEquals((long)2L, (long)((DateTieredCompactionRequest)policy.selectMajorCompaction(files)).getBoundaries().size());
    }

    @Test
    public void testGetCompactBoundariesForMajorOneOnEachSide() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, 1L, 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        Assert.assertEquals((long)3L, (long)((DateTieredCompactionRequest)policy.selectMajorCompaction(files)).getBoundaries().size());
    }

    @Test
    public void testGetCompactBoundariesForMajorOneCrossing() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, EnvironmentEdgeManager.currentTime(), 1024L, 0));
        Assert.assertEquals((long)3L, (long)((DateTieredCompactionRequest)policy.selectMajorCompaction(files)).getBoundaries().size());
    }

    private void testShouldPerformMajorCompaction(long min, long max, int numFiles, PolicyValidator<CustomDateTieredCompactionPolicy, ArrayList<HStoreFile>> validation) throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        RegionInfo mockedRegionInfo = this.mockRegionInfo();
        Path file = this.preparePath();
        ArrayList<MockHStoreFile> files = new ArrayList<MockHStoreFile>();
        ManualEnvironmentEdge timeMachine = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)timeMachine);
        for (int i = 0; i < numFiles; ++i) {
            MockHStoreFile mockedSFile = (MockHStoreFile)this.createFile(mockedRegionInfo, file, min, max, 1024L, 0, 604800000L);
            mockedSFile.setIsMajor(true);
            files.add(mockedSFile);
        }
        EnvironmentEdgeManager.reset();
        validation.accept(policy, files);
    }

    @Test
    public void testShouldPerformMajorCompactionOneFileCrossing() throws Exception {
        long max = EnvironmentEdgeManager.currentTime();
        this.testShouldPerformMajorCompaction(0L, max, 1, (p, f) -> Assert.assertTrue((boolean)p.shouldPerformMajorCompaction((Collection)f)));
    }

    @Test
    public void testShouldPerformMajorCompactionOneFileMinMaxLow() throws Exception {
        this.testShouldPerformMajorCompaction(0L, 1L, 1, (p, f) -> Assert.assertFalse((boolean)p.shouldPerformMajorCompaction((Collection)f)));
    }

    @Test
    public void testShouldPerformMajorCompactionOneFileMinMaxHigh() throws Exception {
        long currentTime = EnvironmentEdgeManager.currentTime();
        this.testShouldPerformMajorCompaction(currentTime, currentTime, 1, (p, f) -> Assert.assertFalse((boolean)p.shouldPerformMajorCompaction((Collection)f)));
    }

    @Test
    public void testShouldPerformMajorCompactionTwoFilesMinMaxHigh() throws Exception {
        long currentTime = EnvironmentEdgeManager.currentTime();
        this.testShouldPerformMajorCompaction(currentTime, currentTime, 2, (p, f) -> Assert.assertTrue((boolean)p.shouldPerformMajorCompaction((Collection)f)));
    }

    @Test
    public void testSelectMinorCompactionTwoFilesNoOld() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        Assert.assertEquals((long)0L, (long)policy.selectMinorCompaction(files, true, true).getFiles().size());
    }

    @Test
    public void testSelectMinorCompactionThreeFilesNoOld() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 2));
        Assert.assertEquals((long)3L, (long)policy.selectMinorCompaction(files, true, true).getFiles().size());
    }

    @Test
    public void testSelectMinorCompactionThreeFilesAllOld() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, 1L, 1024L, 0));
        files.add(this.createFile(file, 1L, 2L, 1024L, 1));
        files.add(this.createFile(file, 3L, 4L, 1024L, 2));
        Assert.assertEquals((long)3L, (long)policy.selectMinorCompaction(files, true, true).getFiles().size());
    }

    @Test
    public void testSelectMinorCompactionThreeFilesOneOldTwoNew() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, 1L, 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 2));
        Assert.assertEquals((long)3L, (long)policy.selectMinorCompaction(files, true, true).getFiles().size());
    }

    @Test
    public void testSelectMinorCompactionThreeFilesTwoOldOneNew() throws Exception {
        CustomDateTieredCompactionPolicy policy = this.mockAndCreatePolicy();
        Path file = this.preparePath();
        ArrayList<HStoreFile> files = new ArrayList<HStoreFile>();
        files.add(this.createFile(file, 0L, 1L, 1024L, 0));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 1));
        files.add(this.createFile(file, EnvironmentEdgeManager.currentTime(), EnvironmentEdgeManager.currentTime(), 1024L, 2));
        Assert.assertEquals((long)3L, (long)policy.selectMinorCompaction(files, true, true).getFiles().size());
    }

    @FunctionalInterface
    static interface PolicyValidator<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }
}

