/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.TestBulkloadBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestBulkLoad
extends TestBulkloadBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoad.class);

    public TestBulkLoad(boolean useFileBasedSFT) {
        super(useFileBasedSFT);
    }

    @Test
    public void verifyBulkLoadEvent() throws IOException {
        TableName tableName = TableName.valueOf((String)"test", (String)"test");
        List<Pair<byte[], String>> familyPaths = this.withFamilyPathsFor(new byte[][]{this.family1});
        byte[] familyName = (byte[])familyPaths.get(0).getFirst();
        String storeFileName = (String)familyPaths.get(0).getSecond();
        storeFileName = new Path(storeFileName).getName();
        ArrayList<String> storeFileNames = new ArrayList<String>();
        storeFileNames.add(storeFileName);
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEdit(WALEdit.BULK_LOAD, tableName.toBytes(), familyName, storeFileNames)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, new byte[][]{this.family1}).bulkLoadHFiles(familyPaths, false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void bulkHLogShouldThrowNoErrorAndWriteMarkerWithBlankInput() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(new ArrayList(), false, null);
    }

    @Test
    public void shouldBulkLoadSingleFamilyHLog() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldBulkLoadManyFamilyHLog() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamilies(this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldBulkLoadManyFamilyHLogEvenWhenTableNameNamespaceSpecified() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        TableName tableName = TableName.valueOf((String)"test", (String)"test");
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldCrashIfBulkLoadFamiliesNotInTable() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldCrashIfBulkLoadMultiFamiliesNotInTable() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2, this.family3), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void bulkHLogShouldThrowErrorWhenFamilySpecifiedAndHFileExistsButNotInTableDescriptor() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldThrowErrorIfBadFamilySpecifiedAsFamilyPath() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(Arrays.asList(this.withInvalidColumnFamilyButProperHFileLocation(this.family1)), false, null);
    }

    @Test(expected=FileNotFoundException.class)
    public void shouldThrowErrorIfHFileDoesNotExist() throws IOException {
        List<Pair> list = Arrays.asList(this.withMissingHFileForFamily(this.family1));
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(list, false, null);
    }

    @Test(expected=FileNotFoundException.class)
    public void shouldThrowErrorIfMultiHFileDoesNotExist() throws IOException {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.addAll(Arrays.asList(this.withMissingHFileForFamily(this.family1)));
        list.addAll(Arrays.asList(this.withMissingHFileForFamily(this.family2)));
        this.testRegionWithFamilies(this.family1, this.family2).bulkLoadHFiles(list, false, null);
    }
}

