/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncAdminWithRegionReplicas
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAdminWithRegionReplicas.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestAsyncAdminBase.setUpBeforeClass();
        HBaseTestingUtility.setReplicas(TEST_UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
        try (ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());){
            RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, registry);
        }
    }

    private void testMoveNonDefaultReplica(TableName tableName) throws InterruptedException, ExecutionException {
        AsyncTableRegionLocator locator = ASYNC_CONN.getRegionLocator(tableName);
        List locs = (List)locator.getAllRegionLocations().get();
        this.admin.move(((HRegionLocation)locs.get(1)).getRegion().getRegionName()).get();
        Assert.assertNotEquals((Object)((HRegionLocation)locs.get(1)).getServerName(), locator.getRegionLocation(HConstants.EMPTY_START_ROW, 1, true).get());
        this.admin.move(((HRegionLocation)locs.get(2)).getRegion().getEncodedNameAsBytes()).get();
        Assert.assertNotEquals((Object)((HRegionLocation)locs.get(2)).getServerName(), locator.getRegionLocation(HConstants.EMPTY_START_ROW, 2, true).get());
    }

    @Test
    public void testMoveNonDefaultReplica() throws InterruptedException, ExecutionException, IOException {
        this.createTableWithDefaultConf(this.tableName, 3);
        this.testMoveNonDefaultReplica(this.tableName);
        this.testMoveNonDefaultReplica(TableName.META_TABLE_NAME);
    }

    @Test
    public void testSplitNonDefaultReplica() throws InterruptedException, ExecutionException, IOException {
        this.createTableWithDefaultConf(this.tableName, 3);
        List locs = (List)ASYNC_CONN.getRegionLocator(this.tableName).getAllRegionLocations().get();
        try {
            this.admin.splitRegion(((HRegionLocation)locs.get(1)).getRegion().getRegionName()).get();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
        try {
            this.admin.splitRegion(((HRegionLocation)locs.get(2)).getRegion().getEncodedNameAsBytes()).get();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
    }

    @Test
    public void testMergeNonDefaultReplicas() throws InterruptedException, ExecutionException, IOException {
        byte[][] splitRows = new byte[][]{Bytes.toBytes((int)0)};
        this.createTableWithDefaultConf(this.tableName, 3, (byte[][])splitRows);
        List locs = (List)ASYNC_CONN.getRegionLocator(this.tableName).getAllRegionLocations().get();
        Assert.assertEquals((long)6L, (long)locs.size());
        Map<Integer, List<RegionInfo>> replicaId2RegionInfo = locs.stream().map(HRegionLocation::getRegion).collect(Collectors.groupingBy(RegionInfo::getReplicaId));
        List<RegionInfo> replicaOnes = replicaId2RegionInfo.get(1);
        try {
            this.admin.mergeRegions(replicaOnes.get(0).getRegionName(), replicaOnes.get(1).getRegionName(), false).get();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
        List<RegionInfo> replicaTwos = replicaId2RegionInfo.get(2);
        try {
            this.admin.mergeRegions(replicaTwos.get(0).getRegionName(), replicaTwos.get(1).getRegionName(), false).get();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
    }

    @Test
    public void testCloneTableSchema() throws IOException, InterruptedException, ExecutionException {
        this.createTableWithDefaultConf(this.tableName, 3);
        this.admin.cloneTableSchema(this.tableName, TableName.valueOf((String)(this.tableName.getNameAsString() + "_new")), true).get();
    }

    @Test
    public void testGetTableRegions() throws InterruptedException, ExecutionException, IOException {
        List metaRegions = (List)this.admin.getRegions(TableName.META_TABLE_NAME).get();
        Assert.assertEquals((long)3L, (long)metaRegions.size());
        for (int i = 0; i < 3; ++i) {
            RegionInfo metaRegion = (RegionInfo)metaRegions.get(i);
            Assert.assertEquals((Object)TableName.META_TABLE_NAME, (Object)metaRegion.getTable());
            Assert.assertEquals((long)i, (long)metaRegion.getReplicaId());
        }
        this.createTableWithDefaultConf(this.tableName, 3);
        List regions = (List)this.admin.getRegions(this.tableName).get();
        Assert.assertEquals((long)3L, (long)metaRegions.size());
        for (int i = 0; i < 3; ++i) {
            RegionInfo region = (RegionInfo)regions.get(i);
            Assert.assertEquals((Object)this.tableName, (Object)region.getTable());
            Assert.assertEquals((long)i, (long)region.getReplicaId());
        }
    }
}

