/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ExponentialMovingAverage;
import org.apache.hadoop.hbase.util.SimpleMovingAverage;
import org.apache.hadoop.hbase.util.WeightedMovingAverage;
import org.apache.hadoop.hbase.util.WindowMovingAverage;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestMovingAverage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMovingAverage.class);
    @Rule
    public TestName name = new TestName();
    private long[] data = new long[]{1L, 12L, 13L, 24L, 25L, 26L, 37L, 38L, 39L, 40L};
    private double delta = 0.1;

    @Test
    public void testSimpleMovingAverage() throws Exception {
        int index;
        SimpleMovingAverage algorithm = new SimpleMovingAverage(this.name.getMethodName());
        int bound = 4;
        for (index = 0; index < bound; ++index) {
            algorithm.updateMostRecentTime(this.data[index]);
        }
        Assert.assertEquals((double)12.5, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 5;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)15.0, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 8;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)22.0, (double)algorithm.getAverageTime(), (double)this.delta);
        while (index < this.data.length) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)25.5, (double)algorithm.getAverageTime(), (double)this.delta);
    }

    @Test
    public void testWindowMovingAverage() throws Exception {
        int index;
        WindowMovingAverage algorithm = new WindowMovingAverage(this.name.getMethodName());
        int bound = 4;
        for (index = 0; index < bound; ++index) {
            algorithm.updateMostRecentTime(this.data[index]);
        }
        Assert.assertEquals((double)12.5, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 5;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)15.0, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 8;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)30.0, (double)algorithm.getAverageTime(), (double)this.delta);
        while (index < this.data.length) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)36.0, (double)algorithm.getAverageTime(), (double)this.delta);
    }

    @Test
    public void testWeightedMovingAverage() throws Exception {
        int index;
        WeightedMovingAverage algorithm = new WeightedMovingAverage(this.name.getMethodName());
        int bound = 4;
        for (index = 0; index < bound; ++index) {
            algorithm.updateMostRecentTime(this.data[index]);
        }
        Assert.assertEquals((double)12.5, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 5;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)15.0, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 8;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)32.67, (double)algorithm.getAverageTime(), (double)this.delta);
        while (index < this.data.length) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)38.0, (double)algorithm.getAverageTime(), (double)this.delta);
    }

    @Test
    public void testExponentialMovingAverage() throws Exception {
        int index;
        ExponentialMovingAverage algorithm = new ExponentialMovingAverage(this.name.getMethodName());
        int bound = 5;
        for (index = 0; index < bound; ++index) {
            algorithm.updateMostRecentTime(this.data[index]);
        }
        Assert.assertEquals((double)15.0, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 6;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)18.67, (double)algorithm.getAverageTime(), (double)this.delta);
        bound = 8;
        while (index < bound) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)29.16, (double)algorithm.getAverageTime(), (double)this.delta);
        while (index < this.data.length) {
            algorithm.updateMostRecentTime(this.data[index]);
            ++index;
        }
        Assert.assertEquals((double)34.97, (double)algorithm.getAverageTime(), (double)this.delta);
    }
}

