/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.membership;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.geode.management.membership.MembershipEvent;
import org.apache.geode.management.membership.MembershipListener;

public abstract class UniversalMembershipListenerAdapter
implements MembershipListener {
    public static final int DEFAULT_HISTORY_SIZE = 100;
    private final int historySize;
    private final LinkedList<String> eventHistory;
    private final Map<String, Boolean> eventJoined;
    private final ClientMembershipListener clientMembershipListener = new ClientMembershipListener(){

        @Override
        public void memberJoined(ClientMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.membershipListener.memberJoined(new AdaptedMembershipEvent(event));
        }

        @Override
        public void memberLeft(ClientMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.membershipListener.memberLeft(new AdaptedMembershipEvent(event));
        }

        @Override
        public void memberCrashed(ClientMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.membershipListener.memberCrashed(new AdaptedMembershipEvent(event));
        }
    };
    protected final MembershipListener membershipListener = new MembershipListener(){

        @Override
        public void memberJoined(MembershipEvent event) {
            if (!this.isDuplicate(event, true)) {
                UniversalMembershipListenerAdapter.this.memberJoined(event);
            }
        }

        @Override
        public void memberLeft(MembershipEvent event) {
            if (!this.isDuplicate(event, false)) {
                UniversalMembershipListenerAdapter.this.memberLeft(event);
            }
        }

        @Override
        public void memberCrashed(MembershipEvent event) {
            if (!this.isDuplicate(event, false)) {
                UniversalMembershipListenerAdapter.this.memberCrashed(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isDuplicate(MembershipEvent event, boolean joined) {
            LinkedList linkedList = UniversalMembershipListenerAdapter.this.eventHistory;
            synchronized (linkedList) {
                boolean duplicate = false;
                String memberId = event.getMemberId();
                int indexOf = UniversalMembershipListenerAdapter.this.eventHistory.indexOf(memberId);
                if (indexOf > -1) {
                    if ((Boolean)UniversalMembershipListenerAdapter.this.eventJoined.get(memberId) == joined) {
                        duplicate = true;
                    } else {
                        Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventHistory.remove(memberId), "Failed to replace entry in eventHistory for " + memberId);
                        Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventJoined.remove(memberId) != null, "Failed to replace entry in eventJoined for " + memberId);
                    }
                }
                if (!duplicate) {
                    if (UniversalMembershipListenerAdapter.this.eventHistory.size() == UniversalMembershipListenerAdapter.this.historySize) {
                        UniversalMembershipListenerAdapter.this.eventHistory.removeFirst();
                    }
                    UniversalMembershipListenerAdapter.this.eventHistory.addLast(memberId);
                    UniversalMembershipListenerAdapter.this.eventJoined.put(memberId, joined);
                    Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventHistory.size() <= UniversalMembershipListenerAdapter.this.historySize, "Attempted to grow eventHistory beyond maximum of " + UniversalMembershipListenerAdapter.this.historySize);
                }
                return duplicate;
            }
        }
    };

    public UniversalMembershipListenerAdapter() {
        this(100);
    }

    public UniversalMembershipListenerAdapter(int historySize) {
        if (historySize < 10) {
            throw new IllegalArgumentException(String.format("Argument historySize must be between 10 and Integer.MAX_INT: %s .", historySize));
        }
        this.historySize = historySize;
        this.eventHistory = new LinkedList();
        this.eventJoined = new HashMap<String, Boolean>();
        ClientMembership.registerClientMembershipListener(this.clientMembershipListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMembershipListener(ManagementService service) {
        LinkedList<String> linkedList = this.eventHistory;
        synchronized (linkedList) {
            service.addMembershipListener(this.membershipListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMembershipListener(ManagementService service) {
        LinkedList<String> linkedList = this.eventHistory;
        synchronized (linkedList) {
            service.removeMembershipListener(this.membershipListener);
        }
        this.unregisterClientMembershipListener();
    }

    public void registerClientMembershipListener() {
        ClientMembership.registerClientMembershipListener(this.clientMembershipListener);
    }

    public void unregisterClientMembershipListener() {
        ClientMembership.unregisterClientMembershipListener(this.clientMembershipListener);
    }

    @Override
    public void memberJoined(MembershipEvent event) {
    }

    @Override
    public void memberLeft(MembershipEvent event) {
    }

    @Override
    public void memberCrashed(MembershipEvent event) {
    }

    public static class AdaptedMembershipEvent
    implements MembershipEvent {
        private final ClientMembershipEvent event;

        protected AdaptedMembershipEvent(ClientMembershipEvent event) {
            this.event = event;
        }

        public boolean isClient() {
            return this.event.isClient();
        }

        @Override
        public String getMemberId() {
            return this.event.getMemberId();
        }

        @Override
        public DistributedMember getDistributedMember() {
            return this.event.getMember();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof AdaptedMembershipEvent)) {
                return false;
            }
            AdaptedMembershipEvent that = (AdaptedMembershipEvent)other;
            return this.event == that.event || this.event != null && this.event.equals(that.event);
        }

        public int hashCode() {
            return this.event.hashCode();
        }

        public String toString() {
            return "[AdaptedMembershipEvent: " + this.event + "]";
        }
    }
}

