/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.logging.log4j.Logger;

public class DataQueryEngine {
    private static final Logger logger = LogService.getLogger();
    private static final int DISPLAY_MEMBERWISE = 0;
    private static final int QUERY = 1;
    private static final int REGION = 2;
    private static final int LIMIT = 3;
    private static final int QUERY_RESULTSET_LIMIT = 4;
    private static final int QUERY_COLLECTIONS_DEPTH = 5;
    private final SystemManagementService service;
    private final InternalCache cache;

    public DataQueryEngine(SystemManagementService service, InternalCache cache) {
        this.service = service;
        this.cache = cache;
    }

    public String queryForJsonResult(String query, int limit, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        return (String)this.queryData(query, null, limit, false, queryResultSetLimit, queryCollectionsDepth);
    }

    public String queryForJsonResult(String query, String members, int limit, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        return (String)this.queryData(query, members, limit, false, queryResultSetLimit, queryCollectionsDepth);
    }

    public byte[] queryForCompressedResult(String query, int limit, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        return (byte[])this.queryData(query, null, limit, true, queryResultSetLimit, queryCollectionsDepth);
    }

    public Object queryData(String query, String members, int limit, boolean zipResult, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        if (query == null || query.isEmpty()) {
            return new JsonisedErrorMessage("Query is either empty or Null").toString();
        }
        Set<DistributedMember> inputMembers = null;
        if (StringUtils.isNotBlank((CharSequence)members) && (inputMembers = ManagementUtils.findMembers(null, members.split(","), this.cache)).size() == 0) {
            return new JsonisedErrorMessage(String.format("Query is invalid due to invalid member : %s", members)).toString();
        }
        try {
            DistributedRegionMXBean regionMBean;
            Set<String> regionsInQuery = this.compileQuery(query);
            if (regionsInQuery.size() > 0) {
                for (String regionPath : regionsInQuery) {
                    regionMBean = this.service.getDistributedRegionMXBean(regionPath);
                    if (regionMBean == null) {
                        return new JsonisedErrorMessage(String.format("Cannot find regions %s in any of the members", regionPath)).toString();
                    }
                    Set<DistributedMember> associatedMembers = ManagementUtils.getRegionAssociatedMembers(regionPath, this.cache, true);
                    if (inputMembers == null || inputMembers.size() <= 0 || associatedMembers.containsAll(inputMembers)) continue;
                    return new JsonisedErrorMessage(String.format("Cannot find regions %s in specified members", regionPath)).toString();
                }
            } else {
                return new JsonisedErrorMessage(String.format("Query is invalid due to error : %s", "Region mentioned in query probably missing /")).toString();
            }
            if (regionsInQuery.size() > 1 && inputMembers == null) {
                for (String regionPath : regionsInQuery) {
                    regionMBean = this.service.getDistributedRegionMXBean(regionPath);
                    if (!regionMBean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !regionMBean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
                    return new JsonisedErrorMessage("Join operation can only be executed on targeted members, please give member input").toString();
                }
            }
            String randomRegion = regionsInQuery.iterator().next();
            Set<DistributedMember> associatedMembers = ManagementUtils.getQueryRegionsAssociatedMembers(regionsInQuery, this.cache, false);
            if (associatedMembers != null && associatedMembers.size() > 0) {
                Object[] functionArgs = new Object[6];
                if (inputMembers != null && inputMembers.size() > 0) {
                    functionArgs[0] = true;
                    functionArgs[1] = query;
                    functionArgs[2] = randomRegion;
                    functionArgs[3] = limit;
                    functionArgs[4] = queryResultSetLimit;
                    functionArgs[5] = queryCollectionsDepth;
                    return DataQueryEngine.callFunction(functionArgs, inputMembers, zipResult);
                }
                functionArgs[0] = false;
                functionArgs[1] = query;
                functionArgs[2] = randomRegion;
                functionArgs[3] = limit;
                functionArgs[4] = queryResultSetLimit;
                functionArgs[5] = queryCollectionsDepth;
                return DataQueryEngine.callFunction(functionArgs, associatedMembers, zipResult);
            }
            return new JsonisedErrorMessage(String.format("Cannot find regions %s in any of the members", regionsInQuery)).toString();
        }
        catch (QueryInvalidException qe) {
            return new JsonisedErrorMessage(String.format("Query is invalid due to error : %s", qe.getMessage())).toString();
        }
    }

    private static Object callFunction(Object functionArgs, Set<DistributedMember> members, boolean zipResult) throws Exception {
        try {
            if (members.size() == 1) {
                DistributedMember member = members.iterator().next();
                ResultCollector collector = FunctionService.onMember(member).setArguments(functionArgs).execute(ManagementConstants.QUERY_DATA_FUNCTION);
                List list = (List)collector.getResult();
                Object object = null;
                if (list.size() > 0) {
                    object = list.get(0);
                }
                if (object instanceof Throwable) {
                    throw (Throwable)object;
                }
                byte[] result = object;
                if (zipResult) {
                    return result;
                }
                Object[] functionArgsList = (Object[])functionArgs;
                boolean showMember = (Boolean)functionArgsList[0];
                if (showMember) {
                    ArrayList<String> decompressedList = new ArrayList<String>();
                    decompressedList.add(BeanUtilFuncs.decompress(result));
                    return DataQueryEngine.wrapResult(((Object)decompressedList).toString());
                }
                return BeanUtilFuncs.decompress(result);
            }
            ResultCollector coll = FunctionService.onMembers(members).setArguments(functionArgs).execute(ManagementConstants.QUERY_DATA_FUNCTION);
            List list = (List)coll.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            Iterator it = list.iterator();
            ArrayList<String> decompressedList = new ArrayList<String>();
            while (it.hasNext()) {
                String decompressedStr = BeanUtilFuncs.decompress((byte[])it.next());
                decompressedList.add(decompressedStr);
            }
            if (zipResult) {
                return BeanUtilFuncs.compress(DataQueryEngine.wrapResult(((Object)decompressedList).toString()));
            }
            return DataQueryEngine.wrapResult(((Object)decompressedList).toString());
        }
        catch (FunctionException fe) {
            throw new Exception(String.format("Query could not be executed due to : %s", fe.getMessage()));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw new Exception(String.format("Query could not be executed due to : %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String wrapResult(String str) {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            w.write("{\"result\":");
            w.write(str);
            w.write("}");
            return w.toString();
        }
    }

    private Set<String> compileQuery(String query) throws QueryInvalidException {
        QCompiler compiler = new QCompiler();
        try {
            CompiledValue compiledQuery = compiler.compileQuery(query);
            HashSet regions = new HashSet();
            compiledQuery.getRegionsInQuery(regions, null);
            Set<String> regionsInQuery = Collections.unmodifiableSet(regions);
            return regionsInQuery;
        }
        catch (QueryInvalidException qe) {
            logger.error("{} Failed, Error {}", (Object)query, (Object)qe.getMessage(), (Object)qe);
            throw qe;
        }
    }

    static class JsonisedErrorMessage {
        private final String message;

        public JsonisedErrorMessage(String errorMessage) {
            this.message = errorMessage;
        }

        public String toString() {
            return String.format("{\"message\":\"%s\"}", this.message);
        }
    }
}

