/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.statistics.StatisticsClock;

public class OffHeapEvictor
extends HeapEvictor {
    private static final String EVICTOR_THREAD_NAME = "OffHeapEvictorThread";
    private long bytesToEvictWithEachBurst;

    public OffHeapEvictor(InternalCache cache, StatisticsClock statisticsClock) {
        super(cache, EVICTOR_THREAD_NAME, statisticsClock);
        this.calculateEvictionBurst();
    }

    private void calculateEvictionBurst() {
        MemoryAllocator allocator = this.cache().getOffHeapStore();
        if (null == allocator) {
            throw new IllegalStateException("Cannot initialize the off-heap evictor.  There is no off-heap memory available for eviction.");
        }
        float evictionBurstPercentage = Float.parseFloat(System.getProperty("gemfire.HeapLRUCapacityController.evictionBurstPercentage", "0.4"));
        this.bytesToEvictWithEachBurst = (long)((double)allocator.getTotalMemory() * 0.01 * (double)evictionBurstPercentage);
    }

    @Override
    protected int getEvictionLoopDelayTime() {
        if (this.numEvictionLoopsCompleted() < Math.max(3, this.numFastLoops())) {
            return 250;
        }
        return 1000;
    }

    @Override
    protected boolean includePartitionedRegion(PartitionedRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getDataStore() != null && region.getAttributes().getOffHeap();
    }

    @Override
    protected boolean includeLocalRegion(LocalRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getAttributes().getOffHeap();
    }

    @Override
    public long getTotalBytesToEvict() {
        return this.bytesToEvictWithEachBurst;
    }

    @Override
    protected InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.OFFHEAP_MEMORY;
    }
}

