/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.FailedSynchronizationException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.TransactionWriterException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.TXManagerCancelledException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.SingleThreadJTAExecutor;
import org.apache.geode.internal.cache.TXBucketRegionState;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntry;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEvent;
import org.apache.geode.internal.cache.TXLastEventInTransactionUtils;
import org.apache.geode.internal.cache.TXLockRequest;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TXState
implements TXStateInterface {
    protected static final Logger logger = LogService.getLogger();
    private final long beginTime;
    final IdentityHashMap<InternalRegion, TXRegionState> regions;
    protected boolean completionStarted;
    protected boolean closed = false;
    protected final Object completionGuard = new Object();
    protected TXLockRequest locks = null;
    private long jtaLifeTime;
    private int modSerialNum;
    private final List<EntryEventImpl> pendingCallbacks = new ArrayList<EntryEventImpl>();
    private boolean beforeCompletionCalled;
    private final SingleThreadJTAExecutor singleThreadJTAExecutor;
    private Runnable internalAfterReservation;
    protected Runnable internalAfterConflictCheck;
    protected Runnable internalDuringApplyChanges;
    protected Runnable internalAfterApplyChanges;
    protected Runnable internalAfterReleaseLocalLocks;
    Runnable internalDuringIndividualSend;
    Runnable internalAfterIndividualSend;
    Runnable internalDuringIndividualCommitProcess;
    Runnable internalAfterIndividualCommitProcess;
    protected Runnable internalAfterSend;
    protected Runnable internalBeforeSend;
    private byte[] baseMembershipId;
    private long baseThreadId;
    private long baseSequenceId;
    protected final TXStateProxy proxy;
    protected boolean firedWriter = false;
    protected final boolean onBehalfOfRemoteStub;
    protected boolean gotBucketLocks = false;
    protected TXCommitMessage commitMessage = null;
    ClientProxyMembershipID bridgeContext = null;
    protected Set<EventID> seenEvents = new HashSet<EventID>();
    private final Map<EventID, Boolean> seenResults = new HashMap<EventID, Boolean>();
    private final Map<EventID, TransactionDataRebalancedException> eventExceptions = new HashMap<EventID, TransactionDataRebalancedException>();
    @Immutable
    static final TXEntryState ENTRY_EXISTS = new TXEntryState();
    private volatile DistributedMember proxyServer;
    private final StatisticsClock statisticsClock;

    public TXState(TXStateProxy proxy, boolean onBehalfOfRemoteStub, StatisticsClock statisticsClock) {
        this(proxy, onBehalfOfRemoteStub, new SingleThreadJTAExecutor(), statisticsClock);
    }

    public TXState(TXStateProxy proxy, boolean onBehalfOfRemoteStub, SingleThreadJTAExecutor singleThreadJTAExecutor, StatisticsClock statisticsClock) {
        this.beginTime = statisticsClock.getTime();
        this.regions = new IdentityHashMap();
        this.internalAfterConflictCheck = null;
        this.internalAfterApplyChanges = null;
        this.internalAfterReleaseLocalLocks = null;
        this.internalDuringIndividualSend = null;
        this.internalAfterIndividualSend = null;
        this.internalBeforeSend = null;
        this.internalAfterSend = null;
        this.proxy = proxy;
        this.onBehalfOfRemoteStub = onBehalfOfRemoteStub;
        this.singleThreadJTAExecutor = singleThreadJTAExecutor;
        this.statisticsClock = statisticsClock;
    }

    private boolean hasSeenEvent(EntryEventImpl event) {
        assert (event != null);
        if (event.getEventId() == null) {
            return false;
        }
        return this.seenEvents.contains(event.getEventId());
    }

    private void recordEvent(EntryEventImpl event) {
        assert (event != null);
        if (event.getEventId() != null) {
            this.seenEvents.add(event.getEventId());
        }
    }

    void recordEventAndResult(EntryEventImpl event, boolean result) {
        this.recordEvent(event);
        if (event.getEventId() != null) {
            this.seenResults.put(event.getEventId(), result);
        }
    }

    boolean getRecordedResult(EntryEventImpl event) {
        assert (event != null);
        assert (this.seenResults.containsKey(event.getEventId()));
        return this.seenResults.get(event.getEventId());
    }

    void recordEventException(EntryEventImpl event, TransactionDataRebalancedException exception) {
        if (event.getEventId() != null) {
            this.eventExceptions.put(event.getEventId(), exception);
        }
    }

    boolean getRecordedResultOrException(EntryEventImpl event) {
        boolean result = this.getRecordedResult(event);
        if (!result && this.eventExceptions.containsKey(event.getEventId())) {
            throw this.eventExceptions.get(event.getEventId());
        }
        return result;
    }

    public String toString() {
        return this.getClass() + "@" + System.identityHashCode(this) + " onBehalfOfRemoteStub:" + this.onBehalfOfRemoteStub;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.proxy.getTxId();
    }

    public void firePendingCallbacks() {
        boolean isConfigError = false;
        EntryEventImpl lastTransactionEvent = null;
        try {
            lastTransactionEvent = TXLastEventInTransactionUtils.getLastTransactionEventInGroupedTxForWANSender(this.getPendingCallbacks(), this.getCache());
        }
        catch (ServiceConfigurationError ex) {
            logger.error(ex.getMessage());
            isConfigError = true;
        }
        for (EntryEventImpl ee : this.getPendingCallbacks()) {
            boolean isLastTransactionEvent = TXLastEventInTransactionUtils.isLastTransactionEvent(isConfigError, lastTransactionEvent, ee);
            if (ee.getOperation().isDestroy()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, ee, true, isLastTransactionEvent);
                continue;
            }
            if (ee.getOperation().isInvalidate()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, ee, true, isLastTransactionEvent);
                continue;
            }
            if (ee.getOperation().isCreate()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_CREATE, ee, true, isLastTransactionEvent);
                continue;
            }
            ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_UPDATE, ee, true, isLastTransactionEvent);
        }
    }

    public void freePendingCallbacks() {
        for (EntryEventImpl ee : this.getPendingCallbacks()) {
            ee.release();
        }
    }

    public List<EntryEventImpl> getPendingCallbacks() {
        return this.pendingCallbacks;
    }

    @Override
    public TXRegionState readRegion(InternalRegion r) {
        return this.regions.get(r);
    }

    @Override
    public void rmRegion(LocalRegion r) {
        TXRegionState txr = this.regions.remove(r);
        if (txr != null) {
            txr.cleanup(r);
        }
    }

    @Override
    public TXRegionState writeRegion(InternalRegion r) {
        TXRegionState result = this.readRegion(r);
        if (result == null) {
            result = r instanceof BucketRegion ? new TXBucketRegionState((BucketRegion)r, this) : new TXRegionState(r, this);
            this.regions.put(r, result);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TXState writeRegion flag {} region-state {} ", (Object)false, (Object)result);
        }
        return result;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public int getChanges() {
        int changes = 0;
        for (TXRegionState txrs : this.regions.values()) {
            changes += txrs.getChanges();
        }
        return changes;
    }

    @Override
    public boolean isInProgress() {
        return !this.closed;
    }

    @Override
    public int nextModSerialNum() {
        ++this.modSerialNum;
        return this.modSerialNum;
    }

    @Override
    public boolean needsLargeModCount() {
        return this.modSerialNum > 127;
    }

    protected void reserveAndCheck() throws CommitConflictException {
        if (this.closed) {
            return;
        }
        long conflictStart = this.statisticsClock.getTime();
        this.locks = this.createLockRequest();
        this.locks.obtain(this.getCache().getInternalDistributedSystem());
        if (this.statisticsClock.isEnabled()) {
            this.proxy.getTxMgr().getCachePerfStats().incTxConflictCheckTime(this.statisticsClock.getTime() - conflictStart);
        }
        if (this.internalAfterReservation != null) {
            this.internalAfterReservation.run();
        }
        this.checkForConflicts();
    }

    byte[] getBaseMembershipId() {
        return this.baseMembershipId;
    }

    long getBaseThreadId() {
        return this.baseThreadId;
    }

    long getBaseSequenceId() {
        return this.baseSequenceId;
    }

    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("precommit() operation %s meant for Dist Tx is not supported", "precommit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws CommitConflictException {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("committing transaction {}", (Object)this.getTransactionId());
        }
        Object object = this.completionGuard;
        synchronized (object) {
            this.completionStarted = true;
        }
        if (this.onBehalfOfRemoteStub && !this.proxy.isCommitOnBehalfOfRemoteStub()) {
            throw new UnsupportedOperationInTransactionException("Cannot commit a transaction being run on behalf of a remote thread");
        }
        this.cleanupNonDirtyRegions();
        try {
            try {
                this.lockBucketRegions();
            }
            catch (PrimaryBucketException pbe) {
                throw new TransactionDataRebalancedException("Transactional data moved, due to rebalancing.", pbe);
            }
            if (this.locks == null) {
                this.reserveAndCheck();
            }
            if (this.internalAfterConflictCheck != null) {
                this.internalAfterConflictCheck.run();
            }
            TransactionWriter writer = this.proxy.getTxMgr().getWriter();
            if (!this.firedWriter && writer != null) {
                try {
                    this.firedWriter = true;
                    TXEvent event = this.getEvent();
                    if (!event.hasOnlyInternalEvents()) {
                        writer.beforeCommit(event);
                    }
                }
                catch (TransactionWriterException twe) {
                    this.cleanup();
                    throw new CommitConflictException(twe);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    this.cleanup();
                    SystemFailure.checkFailure();
                    throw new CommitConflictException(t);
                }
            }
            List entries = this.generateEventOffsets();
            TXCommitMessage msg = null;
            try {
                this.lockTXRegions(this.regions);
                try {
                    this.applyChanges(entries);
                    if (this.internalAfterApplyChanges != null) {
                        this.internalAfterApplyChanges.run();
                    }
                    this.attachFilterProfileInformation(entries);
                    this.commitMessage = msg = this.buildMessage();
                    if (this.internalBeforeSend != null) {
                        this.internalBeforeSend.run();
                    }
                    msg.send(this.locks.getDistributedLockId());
                    if (this.internalAfterSend != null) {
                        this.internalAfterSend.run();
                    }
                    this.firePendingCallbacks();
                    this.commitMessage = this.buildCompleteMessage();
                }
                finally {
                    this.unlockTXRegions(this.regions);
                }
            }
            finally {
                if (msg != null) {
                    msg.releaseViewVersions();
                }
                this.locks.releaseLocal();
                if (this.internalAfterReleaseLocalLocks != null) {
                    this.internalAfterReleaseLocalLocks.run();
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void lockTXRegions(IdentityHashMap<InternalRegion, TXRegionState> regions) {
        for (Map.Entry<InternalRegion, TXRegionState> me : regions.entrySet()) {
            InternalRegion r = me.getKey();
            r.getRegionMap().lockRegionForAtomicTX(r);
        }
    }

    private void unlockTXRegions(IdentityHashMap<InternalRegion, TXRegionState> regions) {
        for (Map.Entry<InternalRegion, TXRegionState> me : regions.entrySet()) {
            InternalRegion r = me.getKey();
            r.getRegionMap().unlockRegionForAtomicTX(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachFilterProfileInformation(List entries) {
        for (Object entry : entries) {
            TXEntryStateWithRegionAndKey o = (TXEntryStateWithRegionAndKey)entry;
            try {
                if (!o.r.isUsedForPartitionedRegionBucket()) continue;
                BucketRegion bucket = (BucketRegion)o.r;
                EntryEventImpl ev = (EntryEventImpl)o.es.getEvent(o.r, o.key, o.es.getTXRegionState().getTXState());
                if (ev.getOperation() == null) continue;
                try {
                    FilterRoutingInfo fri = bucket.getPartitionedRegion().getRegionAdvisor().adviseFilterRouting(ev, Collections.EMPTY_SET);
                    o.es.setFilterRoutingInfo(fri);
                    Set<InternalDistributedMember> set = bucket.getAdjunctReceivers(ev, Collections.EMPTY_SET, new HashSet<InternalDistributedMember>(), fri);
                    o.es.setAdjunctRecipients(set);
                    if (o.es.getPendingCallback() == null) continue;
                    if (fri != null) {
                        FilterRoutingInfo.FilterInfo localRouting = fri.getLocalFilterInfo();
                        o.es.getPendingCallback().setLocalFilterInfo(localRouting);
                    }
                    o.es.setPendingCallback(null);
                }
                finally {
                    ev.release();
                }
            }
            catch (RegionDestroyedException regionDestroyedException) {
            }
            catch (CancelException cancelException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        if (this.closed) {
            return;
        }
        Object object = this.completionGuard;
        synchronized (object) {
            this.completionStarted = true;
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForPreviousCompletion() {
        Object object = this.completionGuard;
        synchronized (object) {
            if (!this.completionStarted) {
                return false;
            }
            while (this.commitMessage == null && !this.closed) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for previous completion for transaction {}", (Object)this.getTransactionId());
                }
                try {
                    this.completionGuard.wait();
                }
                catch (InterruptedException e) {
                    this.proxy.getCache().getCancelCriterion().checkCancelInProgress(e);
                    Thread.currentThread().interrupt();
                    return true;
                }
            }
        }
        return true;
    }

    protected List generateEventOffsets() {
        this.baseMembershipId = EventID.getMembershipId(this.proxy.getTxMgr().getDM().getSystem());
        this.baseThreadId = EventID.getThreadId();
        this.baseSequenceId = EventID.getSequenceId();
        List entries = this.getSortedEntries();
        if (logger.isDebugEnabled()) {
            logger.debug("generateEventOffsets() entries " + entries + " RegionState Map=" + this.regions);
        }
        for (Object entry : entries) {
            TXEntryStateWithRegionAndKey o = (TXEntryStateWithRegionAndKey)entry;
            o.es.generateEventOffsets(this);
        }
        return entries;
    }

    private TXLockRequest createLockRequest() {
        TXLockRequest result = new TXLockRequest();
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.createLockRequest(r, result);
        }
        return result;
    }

    private void checkForConflicts() throws CommitConflictException, PrimaryBucketException {
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            try {
                txrs.checkForConflicts(r);
            }
            catch (DiskAccessException dae) {
                r.handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    protected void lockBucketRegions() throws PrimaryBucketException {
        boolean lockingSucceeded;
        block11: do {
            lockingSucceeded = true;
            Iterator<Map.Entry<InternalRegion, TXRegionState>> it = this.regions.entrySet().iterator();
            HashSet<BucketRegion> obtained = new HashSet<BucketRegion>();
            while (it.hasNext()) {
                Map.Entry<InternalRegion, TXRegionState> me = it.next();
                InternalRegion r = me.getKey();
                if (!(r instanceof BucketRegion) || this.isDistTx() && !((BucketRegion)r).getBucketAdvisor().isPrimary()) continue;
                BucketRegion b = (BucketRegion)r;
                boolean lockObtained = false;
                try {
                    boolean locked = b.doLockForPrimary(true);
                    if (locked) {
                        obtained.add(b);
                        lockObtained = true;
                        continue;
                    }
                    r.getCancelCriterion().checkCancelInProgress(null);
                    if (!logger.isDebugEnabled()) continue block11;
                    logger.debug("tryLock failed for commit on {}. Releasing locks and retrying", (Object)r.getFullPath());
                    continue block11;
                }
                catch (RegionDestroyedException rde) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RegionDestroyedException while locking bucket region {}", (Object)r.getFullPath(), (Object)rde);
                    }
                    throw new TransactionDataRebalancedException("Bucket rebalanced during commit: " + r.getFullPath());
                }
                finally {
                    if (lockObtained) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unexpected exception while locking bucket {}", (Object)r.getFullPath());
                    }
                    for (BucketRegion br : obtained) {
                        br.doUnlockForPrimary();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    lockingSucceeded = false;
                }
            }
        } while (!lockingSucceeded);
        this.gotBucketLocks = true;
    }

    protected void cleanupNonDirtyRegions() {
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.cleanupNonDirtyEntries(r);
        }
    }

    protected TXCommitMessage buildMessage() {
        TXCommitMessage msg = new TXCommitMessage(this.proxy.getTxId(), this.proxy.getTxMgr().getDM(), this);
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.buildMessage(r, msg);
        }
        return msg;
    }

    protected TXCommitMessage buildCompleteMessage() {
        TXCommitMessage msg = new TXCommitMessage(this.proxy.getTxId(), this.proxy.getTxMgr().getDM(), this);
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.buildCompleteMessage(r, msg);
        }
        return msg;
    }

    protected void applyChanges(List entries) {
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion internalRegion = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.applyChangesStart(internalRegion, this);
        }
        for (Map.Entry<InternalRegion, TXRegionState> entry : entries) {
            TXEntryStateWithRegionAndKey tXEntryStateWithRegionAndKey = (TXEntryStateWithRegionAndKey)((Object)entry);
            tXEntryStateWithRegionAndKey.es.serializePendingValue();
        }
        int size = this.pendingCallbacks.size();
        for (Object e : entries) {
            TXEntryStateWithRegionAndKey o = (TXEntryStateWithRegionAndKey)e;
            if (this.internalDuringApplyChanges != null) {
                this.internalDuringApplyChanges.run();
            }
            try {
                o.es.applyChanges(o.r, o.key, this);
                if (this.pendingCallbacks.size() <= size) continue;
                o.es.setPendingCallback(this.pendingCallbacks.get(size));
                size = this.pendingCallbacks.size();
            }
            catch (RegionDestroyedException regionDestroyedException) {
            }
            catch (CancelException cancelException) {}
        }
        for (Map.Entry entry : this.regions.entrySet()) {
            InternalRegion r = (InternalRegion)entry.getKey();
            TXRegionState txrs = (TXRegionState)entry.getValue();
            txrs.applyChangesEnd(r, this);
        }
    }

    @Override
    public TXEvent getEvent() {
        return new TXEvent(this, this.getCache());
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.locks != null) {
                this.cleanup();
                return;
            }
            this.closed = true;
            for (TXRegionState r : this.regions.values()) {
                r.close();
            }
        }
    }

    protected void cleanup() {
        if (this.singleThreadJTAExecutor.shouldDoCleanup()) {
            this.singleThreadJTAExecutor.cleanup();
        } else {
            this.doCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCleanup() {
        RuntimeException exception = null;
        try {
            this.closed = true;
            this.seenEvents.clear();
            this.seenResults.clear();
            this.freePendingCallbacks();
            if (this.locks != null) {
                long conflictStart = this.statisticsClock.getTime();
                try {
                    this.locks.cleanup(this.getCache().getInternalDistributedSystem());
                }
                catch (IllegalArgumentException | IllegalMonitorStateException e) {
                    exception = e;
                }
                if (this.statisticsClock.isEnabled()) {
                    this.proxy.getTxMgr().getCachePerfStats().incTxConflictCheckTime(this.statisticsClock.getTime() - conflictStart);
                }
            }
            for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
                TXRegionState txrs;
                InternalRegion r;
                block20: {
                    r = me.getKey();
                    txrs = me.getValue();
                    if (this.gotBucketLocks && r instanceof BucketRegion && ((BucketRegion)r).getBucketAdvisor().isPrimary()) {
                        try {
                            ((BucketRegion)r).doUnlockForPrimary();
                        }
                        catch (RegionDestroyedException rde) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("RegionDestroyedException while unlocking bucket region {}", (Object)r.getFullPath(), (Object)rde);
                            }
                        }
                        catch (Exception rde) {
                            if (!logger.isDebugEnabled()) break block20;
                            logger.debug("Exception while unlocking bucket region {} this is probably because the bucket was destroyed and never locked initially.", (Object)r.getFullPath(), (Object)rde);
                        }
                    }
                }
                txrs.cleanup(r);
            }
        }
        finally {
            Object object = this.completionGuard;
            synchronized (object) {
                this.completionGuard.notifyAll();
            }
            if (exception != null && !this.proxy.getCache().isClosed()) {
                throw exception;
            }
        }
    }

    @Override
    public List getEvents() {
        ArrayList events = new ArrayList();
        for (Map.Entry<InternalRegion, TXRegionState> me : this.regions.entrySet()) {
            InternalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.getEvents(r, events, this);
        }
        if (events.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collections.sort(events);
        return Collections.unmodifiableList(events);
    }

    private List getSortedEntries() {
        ArrayList entries = new ArrayList();
        for (Map.Entry<InternalRegion, TXRegionState> internalRegionTXRegionStateEntry : this.regions.entrySet()) {
            InternalRegion r = internalRegionTXRegionStateEntry.getKey();
            TXRegionState txrs = internalRegionTXRegionStateEntry.getValue();
            txrs.getEntries(entries, r);
        }
        if (entries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collections.sort(entries);
        return entries;
    }

    public synchronized void beforeCompletion() throws SynchronizationCommitConflictException {
        this.proxy.getTxMgr().setTXState(null);
        if (this.closed) {
            throw new TXManagerCancelledException();
        }
        if (this.beforeCompletionCalled) {
            return;
        }
        this.beforeCompletionCalled = true;
        this.singleThreadJTAExecutor.executeBeforeCompletion(this, this.getExecutor(), this.getCancelCriterion());
    }

    private Executor getExecutor() {
        return this.getCache().getDistributionManager().getExecutors().getWaitingThreadPool();
    }

    private CancelCriterion getCancelCriterion() {
        return this.getCache().getCancelCriterion();
    }

    void doBeforeCompletion() {
        block7: {
            long opStart = this.statisticsClock.getTime();
            this.jtaLifeTime = opStart - this.getBeginTime();
            try {
                this.reserveAndCheck();
                TransactionWriter writer = this.proxy.getTxMgr().getWriter();
                if (writer == null) break block7;
                try {
                    this.firedWriter = true;
                    TXEvent event = this.getEvent();
                    if (!event.hasOnlyInternalEvents()) {
                        writer.beforeCommit(event);
                    }
                }
                catch (TransactionWriterException twe) {
                    throw new CommitConflictException(twe);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    throw new CommitConflictException(t);
                }
            }
            catch (CommitConflictException commitConflict) {
                this.cleanup();
                this.proxy.getTxMgr().noteCommitFailure(opStart, this.jtaLifeTime, this);
                throw new SynchronizationCommitConflictException(String.format("Conflict detected in GemFire transaction %s", this.getTransactionId()), commitConflict);
            }
        }
    }

    public synchronized void afterCompletion(int status) {
        block6: {
            block5: {
                this.proxy.getTxMgr().setTXState(null);
                if (!this.wasBeforeCompletionCalled()) break block5;
                switch (status) {
                    case 3: {
                        this.singleThreadJTAExecutor.executeAfterCompletionCommit();
                        break block6;
                    }
                    case 4: {
                        this.singleThreadJTAExecutor.executeAfterCompletionRollback();
                        break block6;
                    }
                    default: {
                        throw new TransactionException("Unknown JTA Synchronization status " + status);
                    }
                }
            }
            if (status != 4) {
                throw new FailedSynchronizationException("Could not execute afterCompletion when beforeCompletion was not executed");
            }
            this.doAfterCompletionRollback();
        }
    }

    void doAfterCompletionCommit() {
        long opStart = this.statisticsClock.getTime();
        try {
            Assert.assertTrue(this.locks != null, "Gemfire Transaction afterCompletion called with illegal state.");
            try {
                this.commit();
                this.saveTXCommitMessageForClientFailover();
            }
            catch (CommitConflictException error) {
                Assert.assertTrue(false, "Gemfire Transaction " + this.getTransactionId() + " afterCompletion failed.due to CommitConflictException: " + error);
            }
            this.proxy.getTxMgr().noteCommitSuccess(opStart, this.jtaLifeTime, this);
            this.locks = null;
        }
        catch (InternalGemFireError error) {
            throw new TransactionException(error);
        }
    }

    void doAfterCompletionRollback() {
        long opStart = this.statisticsClock.getTime();
        this.jtaLifeTime = opStart - this.getBeginTime();
        try {
            this.rollback();
            this.saveTXCommitMessageForClientFailover();
            this.proxy.getTxMgr().noteRollbackSuccess(opStart, this.jtaLifeTime, this);
        }
        catch (InternalGemFireError error) {
            throw new TransactionException(error);
        }
    }

    boolean wasBeforeCompletionCalled() {
        return this.beforeCompletionCalled;
    }

    void saveTXCommitMessageForClientFailover() {
        this.proxy.getTxMgr().saveTXStateForClientFailover(this.proxy);
    }

    public void setAfterReservation(Runnable afterReservation) {
        this.internalAfterReservation = afterReservation;
    }

    public void setAfterConflictCheck(Runnable afterConflictCheck) {
        this.internalAfterConflictCheck = afterConflictCheck;
    }

    public void setDuringApplyChanges(Runnable duringApplyChanges) {
        this.internalDuringApplyChanges = duringApplyChanges;
    }

    public void setAfterApplyChanges(Runnable afterApplyChanges) {
        this.internalAfterApplyChanges = afterApplyChanges;
    }

    public void setAfterReleaseLocalLocks(Runnable afterReleaseLocalLocks) {
        this.internalAfterReleaseLocalLocks = afterReleaseLocalLocks;
    }

    public void setDuringIndividualSend(Runnable duringIndividualSend) {
        this.internalDuringIndividualSend = duringIndividualSend;
    }

    public void setAfterIndividualSend(Runnable afterIndividualSend) {
        this.internalAfterIndividualSend = afterIndividualSend;
    }

    public void setDuringIndividualCommitProcess(Runnable duringIndividualCommitProcess) {
        this.internalDuringIndividualCommitProcess = duringIndividualCommitProcess;
    }

    public void setAfterIndividualCommitProcess(Runnable afterIndividualCommitProcess) {
        this.internalAfterIndividualCommitProcess = afterIndividualCommitProcess;
    }

    public void setAfterSend(Runnable afterSend) {
        this.internalAfterSend = afterSend;
    }

    public void setBeforeSend(Runnable r) {
        this.internalBeforeSend = r;
    }

    @Override
    public InternalCache getCache() {
        return this.proxy.getCache();
    }

    @Override
    public Collection<InternalRegion> getRegions() {
        return this.regions.keySet();
    }

    @Override
    public TXRegionState txWriteRegion(InternalRegion internalRegion, KeyInfo entryKey) {
        InternalRegion ir = internalRegion.getDataRegionForWrite(entryKey);
        return this.writeRegion(ir);
    }

    @Override
    public TXRegionState txReadRegion(InternalRegion internalRegion) {
        return this.readRegion(internalRegion);
    }

    TXEntryState txWriteEntry(InternalRegion region, EntryEventImpl event, boolean ifNew, boolean requireOldValue, Object expectedOldValue) throws EntryNotFoundException {
        boolean createIfAbsent = event.getOperation() != Operation.REPLACE;
        TXEntryState tx = this.txReadEntry(event.getKeyInfo(), region, true, expectedOldValue, createIfAbsent);
        if (tx != null) {
            boolean existsLocally;
            if (requireOldValue && tx.existsLocally()) {
                event.setOldValue(tx.getNearSidePendingValue(), true);
            }
            if (!(existsLocally = tx.existsLocally()) && event.getOperation() == Operation.REPLACE) {
                throw new EntryNotFoundException("No previously created Entry to be updated");
            }
            if (existsLocally && ifNew) {
                return ENTRY_EXISTS;
            }
            tx.updateForWrite(this.nextModSerialNum());
        } else if (!createIfAbsent) {
            throw new EntryNotFoundException("No previously created Entry to be updated");
        }
        return tx;
    }

    @Override
    public boolean txPutEntry(EntryEventImpl event, boolean ifNew, boolean requireOldValue, boolean checkResources, Object expectedOldValue) {
        InternalRegion region = event.getRegion();
        if (checkResources && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            region.checkIfAboveThreshold(event);
        }
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return this.getRecordedResultOrException(event);
        }
        boolean result = false;
        try {
            TXEntryState tx = this.txWriteEntry(region, event, ifNew, requireOldValue, expectedOldValue);
            result = tx == ENTRY_EXISTS ? false : tx.basicPut(event, ifNew, this.isOriginRemoteForEvents());
        }
        catch (EntryNotFoundException e) {
            result = false;
        }
        catch (TransactionDataRebalancedException e) {
            result = false;
            this.recordEventException(event, e);
            throw e;
        }
        finally {
            this.recordEventAndResult(event, result);
        }
        return result;
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion region) {
        TXEntryState tx = this.txReadEntry(keyInfo, region, true, true);
        if (tx != null) {
            boolean isProxy = false;
            return tx.isLocallyValid(isProxy);
        }
        return region.nonTXContainsValueForKey(keyInfo);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return;
        }
        TXEntryState tx = this.txWriteExistingEntry(event, expectedOldValue);
        InternalRegion region = event.getRegion();
        if (tx.destroy(event, cacheWrite, this.isOriginRemoteForEvents())) {
            Object key = event.getKey();
            LocalRegion rr = region.getDataRegionForRead(event.getKeyInfo());
            this.txReadRegion(rr).rmEntryUserAttr(key);
            this.recordEvent(event);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return;
        }
        TXEntryState tx = this.txWriteExistingEntry(event, null);
        assert (invokeCallbacks && !forceNewEntry);
        tx.invalidate(event);
        this.recordEvent(event);
    }

    private TXEntryState txWriteExistingEntry(EntryEventImpl event, Object expectedOldValue) throws EntryNotFoundException {
        assert (!event.isExpiration());
        Object entryKey = event.getKey();
        InternalRegion region = event.getRegion();
        Operation op = event.getOperation();
        TXEntryState tx = this.txReadEntry(event.getKeyInfo(), region, true, expectedOldValue, true);
        assert (tx != null);
        if (tx.existsLocally()) {
            boolean invalidatingInvalidEntry;
            boolean bl = invalidatingInvalidEntry = op.isInvalidate() && Token.isInvalid(tx.getValueInVM(entryKey));
            if (!invalidatingInvalidEntry) {
                tx.updateForWrite(this.nextModSerialNum());
            }
        } else if (region.isProxy() && !op.isLocal() && !tx.hasOp()) {
            tx.updateForWrite(this.nextModSerialNum());
        } else {
            throw new EntryNotFoundException(entryKey.toString());
        }
        return tx;
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion region, boolean allowTombstones) {
        TXEntryState tx = this.txReadEntry(keyInfo, region, true, true);
        if (tx != null && tx.existsLocally()) {
            return new TXEntry(region, keyInfo, this.getProxy());
        }
        return null;
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion localRegion) {
        return this.getEntry(keyInfo, localRegion, false);
    }

    private TXStateInterface getProxy() {
        return this.proxy;
    }

    @Override
    public TXEntryState txReadEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead, boolean createIfAbsent) {
        localRegion.cache.getCancelCriterion().checkCancelInProgress(null);
        return this.txReadEntry(keyInfo, localRegion, rememberRead, null, createIfAbsent);
    }

    protected TXEntryState txReadEntry(KeyInfo keyInfo, InternalRegion internalRegion, boolean rememberRead, Object expectedOldValue, boolean createIfAbsent) throws EntryNotFoundException {
        InternalRegion dataReg = internalRegion.getDataRegionForWrite(keyInfo);
        TXRegionState txr = this.txReadRegion(dataReg);
        TXEntryState result = null;
        if (txr != null) {
            result = txr.readEntry(keyInfo.getKey());
        }
        if (result == null && rememberRead) {
            if (txr == null) {
                txr = this.txWriteRegion(internalRegion, keyInfo);
            }
            if ((result = dataReg.createReadEntry(txr, keyInfo, createIfAbsent)) == null) {
                assert (!createIfAbsent);
                return result;
            }
        }
        if (result != null) {
            Object val;
            if (expectedOldValue != null && !AbstractRegionEntry.checkExpectedOldValue(expectedOldValue, val = result.getNearSidePendingValue(), internalRegion)) {
                throw new EntryNotFoundException("The current value was not equal to expected value.");
            }
        } else {
            if (txr != null) {
                txr.cleanupNonDirtyEntries(dataReg);
            }
            if (expectedOldValue == null) {
                return result;
            }
            if (!Token.isInvalid(expectedOldValue)) {
                throw new EntryNotFoundException("The current value was not equal to expected value.");
            }
        }
        return result;
    }

    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones, boolean retainResult, boolean createIfAbsent) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, createIfAbsent);
        if (tx != null) {
            Object v = tx.getValue(keyInfo, localRegion, preferCD);
            if (!disableCopyOnRead) {
                v = localRegion.conditionalCopy(v);
            }
            return v;
        }
        return localRegion.getDeserializedValue(null, keyInfo, updateStats, disableCopyOnRead, preferCD, clientEvent, returnTombstones, retainResult);
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo keyInfo, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        Object key = keyInfo.getKey();
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, true);
        if (tx != null) {
            Object val = tx.getPendingValue();
            if (val == null || Token.isInvalidOrRemoved(val)) {
                val = this.findObject(keyInfo, localRegion, val != Token.INVALID, true, val, false, false, requestingClient, clientEvent, false);
            }
            return val;
        }
        assert (localRegion instanceof PartitionedRegion);
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getDataStore().getSerializedLocally(keyInfo, doNotLockEntry, null, null, returnTombstones);
    }

    @Override
    public int entryCount(LocalRegion localRegion) {
        int result = localRegion.getRegionSize();
        TXRegionState txr = this.txReadRegion(localRegion);
        if (txr != null) {
            result += txr.entryCountMod();
        }
        if (result > 0) {
            return result;
        }
        return 0;
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, true);
        if (tx != null) {
            return tx.existsLocally();
        }
        return localRegion.nonTXContainsKey(keyInfo);
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, rememberRead, true);
        if (tx != null) {
            return tx.getValueInVM(keyInfo);
        }
        return localRegion.nonTXbasicGetValueInVM(keyInfo);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return this.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModification) {
        this.validateDelta(event);
        return this.txPutEntry(event, ifNew, requireOldValue, true, expectedOldValue);
    }

    private void validateDelta(EntryEventImpl event) {
        if (event.getDeltaBytes() != null && !event.getRegion().getAttributes().getCloningEnabled()) {
            throw new UnsupportedOperationInTransactionException("Delta without cloning cannot be used in transaction");
        }
    }

    @Override
    public boolean isDeferredStats() {
        return true;
    }

    @Override
    public Object findObject(KeyInfo key, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        return r.findObjectInSystem(key, isCreate, this, generateCallbacks, value, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
    }

    private TXEntryState readEntryAndCheckIfDestroyed(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberReads, boolean createIfAbsent) {
        TXEntryState txEntryState = this.txReadEntry(keyInfo, localRegion, rememberReads, createIfAbsent);
        if (txEntryState != null && !txEntryState.existsLocally()) {
            return null;
        }
        return txEntryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getEntryForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        PartitionedRegion pr;
        if (currRgn instanceof PartitionedRegion && !(pr = (PartitionedRegion)currRgn).getBucketPrimary(curr.getBucketId()).equals(pr.cache.getMyId())) {
            TXManagerImpl txmgr = pr.getGemFireCache().getTXMgr();
            TXStateProxy tx = txmgr.pauseTransaction();
            try {
                Region.Entry<?, ?> entry = pr.nonTXGetEntry(curr, false, allowTombstones);
                return entry;
            }
            finally {
                txmgr.unpauseTransaction(tx);
            }
        }
        TXEntryState txEntryState = this.readEntryAndCheckIfDestroyed(curr, currRgn, rememberReads, allowTombstones);
        if (txEntryState != null) {
            return new TXEntry(currRgn, new KeyInfo(curr.getKey(), curr.getCallbackArg(), curr.getBucketId()), this.proxy, rememberReads);
        }
        return null;
    }

    @Override
    public Object getKeyForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        assert (!(curr.getKey() instanceof RegionEntry));
        TXEntryState txEntryState = this.readEntryAndCheckIfDestroyed(curr, currRgn, rememberReads, allowTombstones);
        if (txEntryState != null) {
            return curr.getKey();
        }
        return null;
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        if (currRgn instanceof PartitionedRegion) {
            HashSet ret = new HashSet();
            for (TXRegionState rs : this.regions.values()) {
                TXBucketRegionState brs;
                if (!(rs instanceof TXBucketRegionState) || (brs = (TXBucketRegionState)rs).getPartitionedRegion() != currRgn) continue;
                brs.fillInCreatedEntryKeys(ret);
            }
            return ret;
        }
        TXRegionState txr = this.txReadRegion(currRgn);
        if (txr != null) {
            HashSet ret = new HashSet();
            txr.fillInCreatedEntryKeys(ret);
            return ret;
        }
        return null;
    }

    @Override
    public boolean isInProgressAndSameAs(TXStateInterface otherState) {
        return this.isInProgress() && otherState == this;
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        event.setOriginRemote(true);
        return this.txPutEntry(event, ifNew, requireOldValue, true, expectedOldValue);
    }

    @Override
    public boolean isFireCallbacks() {
        return !this.getEvent().hasOnlyInternalEvents();
    }

    public boolean isOriginRemoteForEvents() {
        return this.onBehalfOfRemoteStub || this.proxy.isOnBehalfOfClient();
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        event.setOriginRemote(true);
        this.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        event.setOriginRemote(true);
        this.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("destroyRegion() is not supported while in a transaction");
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("invalidateRegion() is not supported while in a transaction");
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException("clear() is not supported while in a transaction");
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getBucketKeys(bucketId, allowTombstones);
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo key, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        Region.Entry txval = this.getEntry(key, pr, allowTombstones);
        if (txval == null) {
            throw new EntryNotFoundException("entry not found");
        }
        NonLocalRegionEntry nlre = new NonLocalRegionEntry(txval, localRegion);
        LocalRegion dataReg = localRegion.getDataRegionForRead(key);
        return new EntrySnapshot(nlre, dataReg, (LocalRegion)txval.getRegion(), allowTombstones);
    }

    @Override
    public ReentrantLock getLock() {
        return this.proxy.getLock();
    }

    public Set getRegionKeysForIteration(LocalRegion currRegion) {
        return currRegion.getRegionKeysForIteration();
    }

    @Override
    public boolean isRealDealLocal() {
        return true;
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return this.proxy.getOnBehalfOfClientMember();
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return false;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion reg) {
        InternalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(() -> {
            InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
            for (int i = 0; i < putallOp.putAllDataSize; ++i) {
                EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, putallOp.putAllData, false, putallOp.getBaseEvent().getContext(), false, !putallOp.getBaseEvent().isGenerateCallbacks());
                try {
                    ev.setPutAllOperation(putallOp);
                    if (!theRegion.basicPut(ev, false, false, null, false)) continue;
                    successfulPuts.addKeyAndVersion(putallOp.putAllData[i].key, null);
                    continue;
                }
                finally {
                    ev.release();
                }
            }
        }, putallOp.getBaseEvent().getEventId());
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, InternalRegion reg) {
        InternalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(() -> {
            InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
            for (int i = 0; i < op.removeAllDataSize; ++i) {
                EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, op.removeAllData, false, op.getBaseEvent().getContext(), false, !op.getBaseEvent().isGenerateCallbacks());
                ev.setRemoveAllOperation(op);
                try {
                    theRegion.basicDestroy(ev, true, null);
                }
                catch (EntryNotFoundException entryNotFoundException) {
                }
                finally {
                    ev.release();
                }
                successfulOps.addKeyAndVersion(op.removeAllData[i].key, null);
            }
        }, op.getBaseEvent().getEventId());
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key, Object[] arguments) {
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
    }

    @Override
    public boolean isTxState() {
        return true;
    }

    @Override
    public boolean isTxStateStub() {
        return false;
    }

    @Override
    public boolean isTxStateProxy() {
        return false;
    }

    @Override
    public boolean isDistTx() {
        return false;
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return false;
    }

    public void setProxyServer(DistributedMember proxyServer) {
        this.proxyServer = proxyServer;
    }

    public DistributedMember getProxyServer() {
        return this.proxyServer;
    }

    boolean isClosed() {
        return this.closed;
    }

    public boolean hasPerformedAnyOperation() {
        return this.regions.size() != 0;
    }

    static class TXEntryStateWithRegionAndKey
    implements Comparable {
        public final TXEntryState es;
        public final InternalRegion r;
        public final Object key;

        public TXEntryStateWithRegionAndKey(TXEntryState es, InternalRegion r, Object key) {
            this.es = es;
            this.r = r;
            this.key = key;
        }

        private int getSortValue() {
            return this.es.getSortValue();
        }

        public int compareTo(Object o) {
            TXEntryStateWithRegionAndKey other = (TXEntryStateWithRegionAndKey)o;
            return this.getSortValue() - other.getSortValue();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TXEntryStateWithRegionAndKey)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this.getSortValue();
        }
    }
}

