/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.parse;

import antlr.Token;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.parse.GemFireAST;

public class ASTLiteral
extends GemFireAST {
    private static final long serialVersionUID = 8374021603235812835L;

    public ASTLiteral() {
    }

    public ASTLiteral(Token t) {
        super(t);
    }

    private Object computeValue() throws QueryInvalidException {
        switch (this.getType()) {
            case 42: {
                return this.getString(this.getText(), '\'');
            }
            case 37: {
                return this.getInt(this.getText());
            }
            case 149: {
                return this.getDouble(this.getText());
            }
            case 148: {
                return this.getFloat(this.getText());
            }
            case 147: {
                return this.getLong(this.getText());
            }
            case 142: 
            case 143: {
                return null;
            }
            case 144: {
                return QueryService.UNDEFINED;
            }
            case 145: {
                return Boolean.TRUE;
            }
            case 146: {
                return Boolean.FALSE;
            }
            case 129: {
                return this.getChar(this.getFirstChild().getText());
            }
            case 135: {
                return this.getDate(this.getFirstChild().getText());
            }
            case 138: {
                return this.getTimestamp(this.getFirstChild().getText());
            }
            case 136: {
                return this.getTime(this.getFirstChild().getText());
            }
        }
        throw new Error("unknown literal type: " + this.getType());
    }

    public Integer getInt(String s) throws QueryInvalidException {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(String.format("unable to parse integer: %s", s), e);
        }
    }

    public Long getLong(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'L' || last == 'l';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(String.format("Unable to parse float %s", s));
        }
    }

    public Float getFloat(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'F' || last == 'f';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return new Float(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(s);
        }
    }

    public Double getDouble(String s) throws QueryInvalidException {
        boolean strip;
        char last = s.charAt(s.length() - 1);
        boolean bl = strip = last == 'D' || last == 'd';
        if (strip) {
            s = s.substring(0, s.length() - 1);
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new QueryInvalidException(String.format("Unable to parse double %s", s));
        }
    }

    private String getString(String s, char delim) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == delim && i < s.length() - 1 && s.charAt(i + 1) == delim) {
                ++i;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public void compile(QCompiler compiler) throws QueryInvalidException {
        Object value = this.computeValue();
        compiler.pushLiteral(value);
    }

    private Character getChar(String s) {
        if (s.length() != 1) {
            throw new QueryInvalidException("Illegal format for CHAR literal. A character literal must have exactly one character");
        }
        return Character.valueOf(s.charAt(0));
    }

    private Date getDate(String s) {
        try {
            Date date = Date.valueOf(s);
            int firstDash = s.indexOf(45);
            int secondDash = s.indexOf(45, firstDash + 1);
            int month = Integer.parseInt(s.substring(firstDash + 1, secondDash));
            int day = Integer.parseInt(s.substring(secondDash + 1));
            if (month < 1 || month > 12) {
                throw new QueryInvalidException("Month must be 1..12 in DATE literal");
            }
            if (day < 1 || day > 31) {
                throw new QueryInvalidException("Day must be 1..31 in DATE literal");
            }
            return date;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(String.format("Illegal format for DATE literal: %s . Expected format is yyyy-mm-dd", s));
        }
    }

    private Time getTime(String s) {
        try {
            Time time = Time.valueOf(s);
            int firstColon = s.indexOf(58);
            int secondColon = s.indexOf(58, firstColon + 1);
            int hour = Integer.parseInt(s.substring(0, firstColon));
            int minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
            int second = Integer.parseInt(s.substring(secondColon + 1));
            if (hour < 0 || hour > 23) {
                throw new QueryInvalidException("Hour must be 0..23 in TIME literal");
            }
            if (minute < 0 || minute > 59) {
                throw new QueryInvalidException("Minute must be 0..59 in TIME literal");
            }
            if (second < 0 || second > 59) {
                throw new QueryInvalidException("Second must be 0..59 in TIME literal");
            }
            return time;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(String.format("Illegal format for TIME literal: %s . Expected format is hh:mm:ss", s));
        }
    }

    private Timestamp getTimestamp(String s) {
        try {
            Timestamp timestamp = Timestamp.valueOf(s);
            int count = 0;
            int index = -1;
            while ((index = s.indexOf(45, index + 1)) >= 0) {
                ++count;
            }
            if (count > 2) {
                throw new QueryInvalidException("Negative numbers not allowed in TIMESTAMP literal");
            }
            StringTokenizer tokenizer = new StringTokenizer(s, ":-\t\n\r\f ");
            tokenizer.nextToken();
            int month = Integer.parseInt(tokenizer.nextToken());
            if (month < 1 || month > 12) {
                throw new QueryInvalidException("Month must be 1..12 in TIMESTAMP literal");
            }
            int day = Integer.parseInt(tokenizer.nextToken());
            if (day < 1 || day > 31) {
                throw new QueryInvalidException("Day must be 1..31 in TIMESTAMP literal");
            }
            int hour = Integer.parseInt(tokenizer.nextToken());
            if (hour < 0 || hour > 23) {
                throw new QueryInvalidException("Hour must be 0..23 in TIMESTAMP literal");
            }
            int minute = Integer.parseInt(tokenizer.nextToken());
            if (minute < 0 || minute > 59) {
                throw new QueryInvalidException("Minute must be 0..59 in TIMESTAMP literal");
            }
            String sec_s = tokenizer.nextToken();
            int period = sec_s.indexOf(46);
            int second = period >= 0 ? Integer.parseInt(sec_s.substring(0, period)) : Integer.parseInt(sec_s);
            if (second < 0 || second > 59) {
                throw new QueryInvalidException("Second must be 0..59 in TIMESTAMP literal");
            }
            return timestamp;
        }
        catch (IllegalArgumentException e) {
            throw new QueryInvalidException(String.format("Illegal format for TIMESTAMP literal: %s . Expected format is yyyy-mm-dd hh:mm:ss.fffffffff", s));
        }
    }
}

