/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesMutator;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CqAttributesImpl
implements CqAttributes,
CqAttributesMutator,
Cloneable {
    private static final Logger logger = LogService.getLogger();
    private volatile ArrayList<CqListener> cqListeners = null;
    @Immutable
    private static final CqListener[] EMPTY_LISTENERS = new CqListener[0];
    private final Object clSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqListener[] getCqListeners() {
        ArrayList<CqListener> listeners = this.cqListeners;
        if (listeners == null) {
            return EMPTY_LISTENERS;
        }
        CqListener[] result = null;
        Object object = this.clSync;
        synchronized (object) {
            result = new CqListener[listeners.size()];
            listeners.toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqListener getCqListener() {
        ArrayList<CqListener> listeners = this.cqListeners;
        if (listeners == null) {
            return null;
        }
        Object object = this.clSync;
        synchronized (object) {
            if (listeners.size() == 0) {
                return null;
            }
            if (listeners.size() == 1) {
                return listeners.get(0);
            }
        }
        throw new IllegalStateException("More than one Cqlistener exists.");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("CloneNotSupportedException thrown in class that implements cloneable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCqListener(CqListener cql) {
        if (cql == null) {
            throw new IllegalArgumentException("addCqListener parameter was null");
        }
        Object object = this.clSync;
        synchronized (object) {
            ArrayList<CqListener> oldListeners = this.cqListeners;
            if (oldListeners == null || oldListeners.size() == 0) {
                ArrayList<CqListener> al = new ArrayList<CqListener>(1);
                al.add(cql);
                this.setCqListeners(al);
            } else if (!oldListeners.contains(cql)) {
                oldListeners.add(cql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCqListeners(CqListener[] addedListeners) {
        ArrayList<CqListener> oldListeners;
        Object object = this.clSync;
        synchronized (object) {
            oldListeners = this.cqListeners;
            if (addedListeners == null || addedListeners.length == 0) {
                this.setCqListeners(null);
            } else {
                List<CqListener> nl = Arrays.asList(addedListeners);
                if (nl.contains(null)) {
                    throw new IllegalArgumentException("initCqListeners parameter had a null element");
                }
                this.setCqListeners(new ArrayList<CqListener>(nl));
            }
        }
        if (oldListeners != null) {
            CqListener cql = null;
            Iterator<CqListener> iter = oldListeners.iterator();
            while (iter.hasNext()) {
                try {
                    cql = iter.next();
                    cql.close();
                }
                catch (Exception ex) {
                    logger.warn("Exception occurred while closing CQ Listener Error: {}", (Object)ex.getLocalizedMessage());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn("Runtime Exception occurred while closing CQ Listener Error: {}", (Object)t.getLocalizedMessage());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(t.getMessage(), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCqListener(CqListener cql) {
        if (cql == null) {
            throw new IllegalArgumentException("removeCqListener parameter was null");
        }
        Object object = this.clSync;
        synchronized (object) {
            block11: {
                ArrayList<CqListener> oldListeners = this.cqListeners;
                if (oldListeners != null && oldListeners.remove(cql)) {
                    if (oldListeners.isEmpty()) {
                        this.setCqListeners(null);
                    }
                    try {
                        cql.close();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception closing CQ Listener Error: {}", (Object)ex.getLocalizedMessage());
                        if (logger.isDebugEnabled()) {
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.warn("Runtime Exception occurred closing CQ Listener Error: {}", (Object)t.getLocalizedMessage());
                        if (!logger.isDebugEnabled()) break block11;
                        logger.debug(t.getMessage(), t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCqListeners(ArrayList<CqListener> cqListeners) {
        Object object = this.clSync;
        synchronized (object) {
            this.cqListeners = cqListeners;
        }
    }
}

