/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.StructBag;
import org.apache.geode.cache.query.internal.StructSet;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.serialization.DataSerializableFixedID;

public abstract class AbstractCompiledValue
implements CompiledValue,
Filter,
OQLLexerTokenTypes {
    ObjectType typecast = null;

    @Override
    public ObjectType getTypecast() {
        return this.typecast;
    }

    void setTypecast(ObjectType objectType) {
        this.typecast = objectType;
    }

    @Override
    public List getPathOnIterator(RuntimeIterator itr, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        return null;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed("This method should not have invoked as CompieldComparison & CompiledUndefined are the only classes on which this invocation should have occurred ");
        return null;
    }

    @Override
    public PlanInfo getPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!this.isDependentOnCurrentScope(context)) {
            PlanInfo planInfo = new PlanInfo();
            Object result = this.evaluate(context);
            if (!(result instanceof Boolean)) {
                throw new TypeMismatchException(String.format("boolean value expected, not type ' %s '", result.getClass().getName()));
            }
            boolean b = (Boolean)result;
            planInfo.evalAsFilter = !b;
            return planInfo;
        }
        PlanInfo planInfo = this.protGetPlanInfo(context);
        return planInfo;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean isDependentOnIterator(RuntimeIterator itr, ExecutionContext context) {
        return context.isDependentOn(this, itr);
    }

    @Override
    public boolean isDependentOnCurrentScope(ExecutionContext context) {
        return context.isDependentOnCurrentScope(this);
    }

    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return new PlanInfo();
    }

    protected int reflectOperator(int op) {
        switch (op) {
            case 13: {
                return 13;
            }
            case 20: {
                return 20;
            }
            case 22: {
                return 23;
            }
            case 19: {
                return 18;
            }
            case 18: {
                return 19;
            }
            case 23: {
                return 22;
            }
        }
        Support.assertionFailed("unknown operator: " + op);
        throw new Error("this line of code can never be executed");
    }

    protected int inverseOperator(int op) {
        switch (op) {
            case 91: {
                return 89;
            }
            case 89: {
                return 91;
            }
            case 13: {
                return 20;
            }
            case 20: {
                return 13;
            }
            case 22: {
                return 19;
            }
            case 19: {
                return 22;
            }
            case 18: {
                return 23;
            }
            case 23: {
                return 18;
            }
        }
        Support.assertionFailed("unknown operator: " + op);
        throw new Error("this line of code can never be executed");
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.filterEvaluate(context, intermediateResults);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.Assert(!this.isDependentOnCurrentScope(context));
        Object result = this.evaluate(context);
        if (result == null || result == QueryService.UNDEFINED) {
            return new ResultsBag(intermediateResults.getCollectionType().getElementType(), 0, context.getCachePerfStats());
        }
        if (!(result instanceof Boolean)) {
            throw new TypeMismatchException(String.format("boolean value expected, not type ' %s '", result.getClass().getName()));
        }
        boolean b = (Boolean)result;
        if (b) {
            return null;
        }
        DataSerializableFixedID emptySet = null;
        List iterators = context.getCurrentIterators();
        int len = iterators.size();
        if (len == 1) {
            ObjectType elementType = ((RuntimeIterator)iterators.get(0)).getElementType();
            emptySet = context.isDistinct() ? new ResultsSet(elementType) : new ResultsBag(elementType, 0, context.getCachePerfStats());
        } else {
            String[] fieldNames = new String[len];
            ObjectType[] fieldTypes = new ObjectType[len];
            for (int i = 0; i < len; ++i) {
                RuntimeIterator iter = (RuntimeIterator)iterators.get(i);
                fieldNames[i] = iter.getInternalId();
                fieldTypes[i] = iter.getElementType();
            }
            emptySet = context.isDistinct() ? new StructSet(new StructTypeImpl(fieldNames, fieldTypes)) : new StructBag(0, (StructType)new StructTypeImpl(fieldNames, fieldTypes), context.getCachePerfStats());
        }
        return emptySet;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, System.currentTimeMillis());
        clauseBuffer.insert(0, this.getClass());
        clauseBuffer.insert(0, '.');
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        for (Object o : this.getChildren()) {
            CompiledValue v = (CompiledValue)o;
            if (v == null) {
                throw new NullPointerException(String.format("Got null as a child from %s", this));
            }
            v.getRegionsInQuery(regionsInQuery, parameters);
        }
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void visitNodes(CompiledValue.NodeVisitor visitor) {
        visitor.visit(this);
        for (Object o : this.getChildren()) {
            if (!visitor.visit((CompiledValue)o)) break;
        }
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws TypeMismatchException, NameResolutionException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public int getOperator() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public CompiledValue getReceiver() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }
}

