/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.List;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.RegisterInterestOp;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.util.internal.UncheckedUtils;
import org.jetbrains.annotations.NotNull;

public class RegisterInterestListOp {
    public static <K> List<K> execute(@NotNull ExecutablePool pool, @NotNull String region, @NotNull List<K> keys, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestListOpImpl op = new RegisterInterestListOpImpl(region, keys, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOnQueuesAndReturnPrimaryResult(op));
    }

    private RegisterInterestListOp() {
    }

    public static <K> List<K> executeOn(@NotNull ServerLocation sl, @NotNull ExecutablePool pool, @NotNull String region, @NotNull List<K> keys, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestListOpImpl op = new RegisterInterestListOpImpl(region, keys, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOn(sl, (Op)op));
    }

    public static <K> List<K> executeOn(@NotNull Connection conn, @NotNull ExecutablePool pool, @NotNull String region, @NotNull List<K> keys, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestListOpImpl op = new RegisterInterestListOpImpl(region, keys, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOn(conn, (Op)op));
    }

    @VisibleForTesting
    public static class RegisterInterestListOpImpl
    extends RegisterInterestOp.RegisterInterestOpImpl {
        public RegisterInterestListOpImpl(@NotNull String region, @NotNull List<?> keys, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
            super(region, 24, 6);
            this.getMessage().addStringPart(region, true);
            this.getMessage().addObjPart(policy);
            byte durableByte = (byte)(isDurable ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{durableByte});
            this.getMessage().setChunkSize(keys.size() * 16);
            this.getMessage().addObjPart(keys);
            byte notifyByte = (byte)(receiveUpdatesAsInvalidates ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{notifyByte});
            this.getMessage().addBytesPart(new byte[]{(byte)regionDataPolicy.ordinal(), 1});
        }

        @Override
        protected String getOpName() {
            return "registerInterestList";
        }
    }
}

