/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.Serializable;
import javax.print.attribute.EnumSyntax;
import org.apache.geode.annotations.Immutable;

@Immutable
public final class EvictionAction
extends EnumSyntax
implements Serializable {
    private static final long serialVersionUID = -98840597493242980L;
    @Immutable
    public static final EvictionAction NONE = new EvictionAction(0);
    @Immutable
    public static final EvictionAction LOCAL_DESTROY = new EvictionAction(1);
    @Immutable
    public static final EvictionAction OVERFLOW_TO_DISK = new EvictionAction(2);
    @Immutable
    public static final EvictionAction DEFAULT_EVICTION_ACTION = LOCAL_DESTROY;
    private static final String[] stringTable = new String[]{"none", "local-destroy", "overflow-to-disk"};
    @Immutable
    private static final EvictionAction[] enumValueTable = new EvictionAction[]{NONE, LOCAL_DESTROY, OVERFLOW_TO_DISK};

    private EvictionAction(int val) {
        super(val);
    }

    @Override
    protected String[] getStringTable() {
        return stringTable;
    }

    @Override
    protected EnumSyntax[] getEnumValueTable() {
        return enumValueTable;
    }

    public boolean isLocalDestroy() {
        return this == LOCAL_DESTROY;
    }

    public boolean isOverflowToDisk() {
        return this == OVERFLOW_TO_DISK;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public static EvictionAction parseValue(int v) {
        if (v < 0 || v >= enumValueTable.length) {
            return null;
        }
        return enumValueTable[v];
    }

    public static EvictionAction parseAction(String s) {
        if (s == null) {
            return NONE;
        }
        if (s.length() < 1) {
            return NONE;
        }
        for (int i = 0; i < stringTable.length; ++i) {
            if (!s.equals(stringTable[i])) continue;
            return enumValueTable[i];
        }
        return NONE;
    }
}

