/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.admin.internal.CacheHealthEvaluator;
import org.apache.geode.admin.internal.MemberHealthEvaluator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class GemFireHealthEvaluator {
    private static final Logger logger = LogService.getLogger();
    private final GemFireHealthConfig config;
    private final MemberHealthEvaluator memberHealth;
    private final CacheHealthEvaluator cacheHealth;
    private final List<String> okayDiagnoses;
    private final List<String> poorDiagnoses;

    public GemFireHealthEvaluator(GemFireHealthConfig config, ClusterDistributionManager dm) {
        if (config == null) {
            throw new NullPointerException("Null GemFireHealthConfig");
        }
        this.config = config;
        this.memberHealth = new MemberHealthEvaluator(config, dm);
        this.cacheHealth = new CacheHealthEvaluator(config, dm);
        this.okayDiagnoses = new ArrayList<String>();
        this.poorDiagnoses = new ArrayList<String>();
    }

    public GemFireHealth.Health evaluate() {
        ArrayList<AbstractHealthEvaluator.HealthStatus> status = new ArrayList<AbstractHealthEvaluator.HealthStatus>();
        this.memberHealth.evaluate(status);
        this.cacheHealth.evaluate(status);
        GemFireHealth.Health overallHealth = GemFireHealth.GOOD_HEALTH;
        this.okayDiagnoses.clear();
        this.poorDiagnoses.clear();
        for (Object e : status) {
            GemFireHealth.Health healthCode;
            AbstractHealthEvaluator.HealthStatus health = (AbstractHealthEvaluator.HealthStatus)e;
            if (overallHealth == GemFireHealth.GOOD_HEALTH) {
                if (health.getHealthCode() != GemFireHealth.GOOD_HEALTH) {
                    overallHealth = health.getHealthCode();
                }
            } else if (overallHealth == GemFireHealth.OKAY_HEALTH && health.getHealthCode() == GemFireHealth.POOR_HEALTH) {
                overallHealth = GemFireHealth.POOR_HEALTH;
            }
            if ((healthCode = health.getHealthCode()) == GemFireHealth.OKAY_HEALTH) {
                this.okayDiagnoses.add(health.getDiagnosis());
                continue;
            }
            if (healthCode != GemFireHealth.POOR_HEALTH) continue;
            this.poorDiagnoses.add(health.getDiagnosis());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluated health to be {}", (Object)overallHealth);
        }
        return overallHealth;
    }

    public String[] getDiagnosis(GemFireHealth.Health healthCode) {
        if (healthCode == GemFireHealth.GOOD_HEALTH) {
            return new String[0];
        }
        if (healthCode == GemFireHealth.OKAY_HEALTH) {
            String[] array = new String[this.okayDiagnoses.size()];
            this.okayDiagnoses.toArray(array);
            return array;
        }
        Assert.assertTrue(healthCode == GemFireHealth.POOR_HEALTH);
        String[] array = new String[this.poorDiagnoses.size()];
        this.poorDiagnoses.toArray(array);
        return array;
    }

    public void reset() {
        this.okayDiagnoses.clear();
        this.poorDiagnoses.clear();
    }

    public int getEvaluationInterval() {
        return this.config.getHealthEvaluationInterval();
    }

    public void close() {
        this.memberHealth.close();
        this.cacheHealth.close();
    }
}

