/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.List;
import java.util.Set;
import org.apache.geode.admin.DistributedSystemHealthConfig;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;

@Deprecated
class DistributedSystemHealthEvaluator
extends AbstractHealthEvaluator
implements MembershipListener {
    private final DistributedSystemHealthConfig config;
    private final DistributionManager dm;
    private final String description;
    private int crashedApplications;

    DistributedSystemHealthEvaluator(DistributedSystemHealthConfig config, DistributionManager dm) {
        super(null, dm);
        this.config = config;
        this.dm = dm;
        this.dm.addMembershipListener(this);
        StringBuilder sb = new StringBuilder();
        sb.append("Distributed System ");
        String desc = null;
        if (dm instanceof ClusterDistributionManager) {
            desc = ((ClusterDistributionManager)dm).getDistributionConfigDescription();
        }
        if (desc != null) {
            sb.append(desc);
        } else {
            DistributionConfig dsc = dm.getSystem().getConfig();
            String locators = dsc.getLocators();
            if (locators == null || locators.equals("")) {
                sb.append("using multicast ");
                sb.append(dsc.getMcastAddress());
                sb.append(":");
                sb.append(dsc.getMcastPort());
            } else {
                sb.append("using locators ");
                sb.append(locators);
            }
        }
        this.description = sb.toString();
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDepartedApplications(List status) {
        DistributedSystemHealthEvaluator distributedSystemHealthEvaluator = this;
        synchronized (distributedSystemHealthEvaluator) {
            long threshold = this.config.getMaxDepartedApplications();
            if ((long)this.crashedApplications > threshold) {
                String s = String.format("The number of applications that have left the distributed system (%s) exceeds the threshold (%s)", this.crashedApplications, threshold);
                status.add(this.poorHealth(s));
            }
            this.crashedApplications = 0;
        }
    }

    protected void check(List status) {
        this.checkDepartedApplications(status);
    }

    @Override
    void close() {
        this.dm.removeMembershipListener(this);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (!crashed) {
            return;
        }
        DistributedSystemHealthEvaluator distributedSystemHealthEvaluator = this;
        synchronized (distributedSystemHealthEvaluator) {
            int kind = id.getVmKind();
            switch (kind) {
                case 10: 
                case 11: {
                    ++this.crashedApplications;
                    break;
                }
            }
        }
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }
}

