/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class GMSUtil {
    public static <ID extends MemberIdentifier> Set<ID> readHashSetOfMemberIDs(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = StaticSerialization.readArrayLength((DataInput)in);
        if (size == -1) {
            return null;
        }
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < size; ++i) {
            result.add(context.getDeserializer().readObject(in));
        }
        return result;
    }

    public static String[] parseGroups(String csvRoles, String csvGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        GMSUtil.parseCsv(groups, csvRoles);
        GMSUtil.parseCsv(groups, csvGroups);
        return groups.toArray(new String[groups.size()]);
    }

    private static void parseCsv(List<String> groups, String csv) {
        if (csv == null || csv.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
    }

    public static String replaceStrings(String properties, String property, String value) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int index = properties.indexOf(property);
        while (index != -1) {
            sb.append(properties, start, index);
            sb.append(value);
            start = index + property.length();
            index = properties.indexOf(property, start);
        }
        sb.append(properties.substring(start));
        return sb.toString();
    }

    public static <ID extends MemberIdentifier> List<ID> readArrayOfIDs(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = StaticSerialization.readArrayLength((DataInput)in);
        if (size == -1) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            result.add(context.getDeserializer().readObject(in));
        }
        return result;
    }

    public static <ID extends MemberIdentifier> void writeSetOfMemberIDs(Set<ID> set, DataOutput out, SerializationContext context) throws IOException {
        int size = set == null ? -1 : set.size();
        StaticSerialization.writeArrayLength((int)size, (DataOutput)out);
        if (size > 0) {
            for (MemberIdentifier member : set) {
                context.getSerializer().writeObject((Object)member, out);
            }
        }
    }
}

