/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.ProcessTableFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.extraction.BaseMappingExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionMappingExtractor;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.ProcedureMappingExtractor;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
public final class TypeInferenceExtractor {
    public static TypeInference forScalarFunction(DataTypeFactory typeFactory, Class<? extends ScalarFunction> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", BaseMappingExtractor.createArgumentsFromParametersExtraction(0), null, null, FunctionMappingExtractor.createOutputFromReturnTypeInMethod(), FunctionMappingExtractor.createParameterAndReturnTypeVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forAsyncScalarFunction(DataTypeFactory typeFactory, Class<? extends AsyncScalarFunction> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", BaseMappingExtractor.createArgumentsFromParametersExtraction(1), null, null, FunctionMappingExtractor.createOutputFromGenericInMethod(0, 0, true), FunctionMappingExtractor.createParameterAndCompletableFutureVerification(function, false));
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forAggregateFunction(DataTypeFactory typeFactory, Class<? extends AggregateFunction<?, ?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "accumulate", BaseMappingExtractor.createArgumentsFromParametersExtraction(1), FunctionMappingExtractor.createStateFromGenericInClassOrParametersExtraction(AggregateFunction.class, 1), FunctionMappingExtractor.createParameterVerification(true), FunctionMappingExtractor.createOutputFromGenericInClass(AggregateFunction.class, 0, true), null);
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forTableFunction(DataTypeFactory typeFactory, Class<? extends TableFunction<?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", BaseMappingExtractor.createArgumentsFromParametersExtraction(0), null, null, FunctionMappingExtractor.createOutputFromGenericInClass(TableFunction.class, 0, true), FunctionMappingExtractor.createParameterVerification(false));
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forTableAggregateFunction(DataTypeFactory typeFactory, Class<? extends TableAggregateFunction<?, ?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "accumulate", BaseMappingExtractor.createArgumentsFromParametersExtraction(1), FunctionMappingExtractor.createStateFromGenericInClassOrParametersExtraction(TableAggregateFunction.class, 1), FunctionMappingExtractor.createParameterVerification(true), FunctionMappingExtractor.createOutputFromGenericInClass(TableAggregateFunction.class, 0, true), null);
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forAsyncTableFunction(DataTypeFactory typeFactory, Class<? extends AsyncTableFunction<?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", BaseMappingExtractor.createArgumentsFromParametersExtraction(1), null, null, FunctionMappingExtractor.createOutputFromGenericInClass(AsyncTableFunction.class, 0, true), FunctionMappingExtractor.createParameterAndCompletableFutureVerification(function, true));
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, false);
    }

    public static TypeInference forProcessTableFunction(DataTypeFactory typeFactory, Class<? extends ProcessTableFunction<?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", BaseMappingExtractor.createArgumentsFromParametersExtraction(0, ProcessTableFunction.Context.class), BaseMappingExtractor.createStateFromParametersExtraction(), FunctionMappingExtractor.createParameterAndOptionalContextVerification(ProcessTableFunction.Context.class, true), FunctionMappingExtractor.createOutputFromGenericInClass(ProcessTableFunction.class, 0, true), null);
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor, true);
    }

    public static TypeInference forProcedure(DataTypeFactory typeFactory, Class<? extends Procedure> procedure) {
        ProcedureMappingExtractor mappingExtractor = new ProcedureMappingExtractor(typeFactory, procedure, "call", BaseMappingExtractor.createArgumentsFromParametersExtraction(1), ProcedureMappingExtractor.createOutputFromArrayReturnTypeInMethod(), ProcedureMappingExtractor.createParameterWithOptionalContextAndArrayReturnTypeVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    private static TypeInference extractTypeInference(FunctionMappingExtractor mappingExtractor, boolean requiresStaticSignature) {
        try {
            return TypeInferenceExtractor.extractTypeInferenceOrError(mappingExtractor, requiresStaticSignature);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Could not extract a valid type inference for function class '%s'. Please check for implementation mistakes and/or provide a corresponding hint.", mappingExtractor.getFunction().getName());
        }
    }

    private static TypeInference extractTypeInference(ProcedureMappingExtractor mappingExtractor) {
        try {
            Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping = mappingExtractor.extractOutputMapping();
            return TypeInferenceExtractor.buildInference(null, outputMapping, false);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Could not extract a valid type inference for procedure class '%s'. Please check for implementation mistakes and/or provide a corresponding hint.", mappingExtractor.getFunctionClass().getName());
        }
    }

    private static TypeInference extractTypeInferenceOrError(FunctionMappingExtractor mappingExtractor, boolean requiresStaticSignature) {
        Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping = mappingExtractor.extractOutputMapping();
        if (!mappingExtractor.supportsState()) {
            return TypeInferenceExtractor.buildInference(null, outputMapping, requiresStaticSignature);
        }
        Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionStateTemplate> stateMapping = mappingExtractor.extractStateMapping();
        return TypeInferenceExtractor.buildInference(stateMapping, outputMapping, requiresStaticSignature);
    }

    private static TypeInference buildInference(@Nullable Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionStateTemplate> stateMapping, Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping, boolean requiresStaticSignature) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        if (!TypeInferenceExtractor.configureStaticArguments(builder, outputMapping)) {
            if (requiresStaticSignature) {
                throw ExtractionUtils.extractionError("Process table functions require a non-overloaded, non-vararg, and static signature.", new Object[0]);
            }
            builder.inputTypeStrategy(TypeInferenceExtractor.translateInputTypeStrategy(outputMapping));
        }
        if (stateMapping != null) {
            if (!stateMapping.keySet().equals(outputMapping.keySet())) {
                throw ExtractionUtils.extractionError("Mismatch between state signature and output signature. Both intermediate and output results must be derived from the same input strategy.", new Object[0]);
            }
            builder.stateTypeStrategies(TypeInferenceExtractor.translateStateTypeStrategies(stateMapping));
        }
        builder.outputTypeStrategy(TypeInferenceExtractor.translateOutputTypeStrategy(outputMapping));
        return builder.build();
    }

    private static boolean configureStaticArguments(TypeInference.Builder builder, Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping) {
        Set<FunctionSignatureTemplate> signatures = outputMapping.keySet();
        if (signatures.size() != 1) {
            return false;
        }
        List<StaticArgument> arguments = signatures.iterator().next().toStaticArguments();
        if (arguments == null) {
            return false;
        }
        builder.staticArguments(arguments);
        return true;
    }

    private static InputTypeStrategy translateInputTypeStrategy(Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping) {
        return outputMapping.keySet().stream().map(FunctionSignatureTemplate::toInputTypeStrategy).reduce((xva$0, xva$1) -> InputTypeStrategies.or(xva$0, xva$1)).orElse(InputTypeStrategies.sequence(new ArgumentTypeStrategy[0]));
    }

    private static LinkedHashMap<String, StateTypeStrategy> translateStateTypeStrategies(Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionStateTemplate> stateMapping) {
        if (stateMapping.size() == 1) {
            FunctionResultTemplate.FunctionStateTemplate template = stateMapping.entrySet().iterator().next().getValue();
            return template.toStateTypeStrategies();
        }
        Map<InputTypeStrategy, TypeStrategy> mappings = stateMapping.entrySet().stream().collect(Collectors.toMap(e -> ((FunctionSignatureTemplate)e.getKey()).toInputTypeStrategy(), e -> ((FunctionResultTemplate.FunctionStateTemplate)e.getValue()).toAccumulatorTypeStrategy()));
        StateTypeStrategy accumulatorStrategy = StateTypeStrategy.of(TypeStrategies.mapping(mappings));
        Set stateNames = stateMapping.values().stream().map(FunctionResultTemplate.FunctionStateTemplate::toAccumulatorStateName).collect(Collectors.toSet());
        if (stateMapping.size() > 1 && stateNames.size() > 1) {
            throw ExtractionUtils.extractionError("Overloaded aggregating functions must use the same name for state entries. Found: %s", stateNames);
        }
        String stateName = (String)stateNames.iterator().next();
        LinkedHashMap<String, StateTypeStrategy> stateTypeStrategies = new LinkedHashMap<String, StateTypeStrategy>();
        stateTypeStrategies.put(stateName, accumulatorStrategy);
        return stateTypeStrategies;
    }

    private static TypeStrategy translateOutputTypeStrategy(Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionOutputTemplate> outputMapping) {
        if (outputMapping.size() == 1) {
            FunctionResultTemplate.FunctionOutputTemplate template = outputMapping.entrySet().iterator().next().getValue();
            return template.toTypeStrategy();
        }
        Map<InputTypeStrategy, TypeStrategy> mappings = outputMapping.entrySet().stream().collect(Collectors.toMap(e -> ((FunctionSignatureTemplate)e.getKey()).toInputTypeStrategy(), e -> ((FunctionResultTemplate.FunctionOutputTemplate)e.getValue()).toTypeStrategy(), (t1, t2) -> t2));
        return TypeStrategies.mapping(mappings);
    }
}

