/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.ttl.mock;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;

import javax.annotation.Nullable;

import java.io.IOException;
import java.util.List;

public class MockCheckpointStorage implements CheckpointStorage {
    @Override
    public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) {
        return new CheckpointStorageAccess() {
            @Override
            public boolean supportsHighlyAvailableStorage() {
                return false;
            }

            @Override
            public boolean hasDefaultSavepointLocation() {
                return false;
            }

            @Override
            public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) {
                return null;
            }

            @Override
            public void initializeBaseLocationsForCheckpoint() {}

            @Override
            public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) {
                return new CheckpointStorageLocation() {

                    @Override
                    public CheckpointStateOutputStream createCheckpointStateOutputStream(
                            CheckpointedStateScope scope) {
                        return null;
                    }

                    @Override
                    public boolean canFastDuplicate(
                            StreamStateHandle stateHandle, CheckpointedStateScope scope) {
                        return false;
                    }

                    @Override
                    public List<StreamStateHandle> duplicate(
                            List<StreamStateHandle> stateHandles, CheckpointedStateScope scope)
                            throws IOException {
                        return null;
                    }

                    @Override
                    public CheckpointMetadataOutputStream createMetadataOutputStream() {
                        return null;
                    }

                    @Override
                    public void disposeOnFailure() {}

                    @Override
                    public CheckpointStorageLocationReference getLocationReference() {
                        return null;
                    }
                };
            }

            @Override
            public CheckpointStorageLocation initializeLocationForSavepoint(
                    long checkpointId, @Nullable String externalLocationPointer) {
                return null;
            }

            @Override
            public CheckpointStreamFactory resolveCheckpointStorageLocation(
                    long checkpointId, CheckpointStorageLocationReference reference) {
                return null;
            }

            @Override
            public CheckpointStateOutputStream createTaskOwnedStateStream() {
                return null;
            }

            @Override
            public CheckpointStateToolset createTaskOwnedCheckpointStateToolset() {
                return null;
            }
        };
    }
}
