/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.base.MoreObjects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;

final class GcpMetadataConfig {
    private static final String METADATA_URL = "http://metadata.google.internal/computeMetadata/v1/";

    private GcpMetadataConfig() {
    }

    static boolean isRunningOnGcp() {
        return !GcpMetadataConfig.getProjectId().isEmpty();
    }

    static String getProjectId() {
        return GcpMetadataConfig.getAttribute("project/project-id");
    }

    static String getZone() {
        String zone = GcpMetadataConfig.getAttribute("instance/zone");
        if (zone.contains("/")) {
            return zone.substring(zone.lastIndexOf(47) + 1);
        }
        return zone;
    }

    static String getMachineType() {
        String machineType = GcpMetadataConfig.getAttribute("instance/machine-type");
        if (machineType.contains("/")) {
            return machineType.substring(machineType.lastIndexOf(47) + 1);
        }
        return machineType;
    }

    static String getInstanceId() {
        return GcpMetadataConfig.getAttribute("instance/id");
    }

    static String getClusterName() {
        return GcpMetadataConfig.getAttribute("instance/attributes/cluster-name");
    }

    static String getInstanceName() {
        return GcpMetadataConfig.getAttribute("instance/hostname");
    }

    static String getInstanceHostname() {
        return GcpMetadataConfig.getAttribute("instance/name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttribute(String attributeName) {
        block6: {
            String string;
            block7: {
                URL url = new URL(METADATA_URL + attributeName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Metadata-Flavor", "Google");
                InputStream input = connection.getInputStream();
                if (connection.getResponseCode() != 200) break block6;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
                    string = MoreObjects.firstNonNull(reader.readLine(), "");
                    if (reader == null) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return string;
        }
        return "";
    }
}

