/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.ByteRangeSpec;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.storage.v2.BucketAccessControl;
import com.google.storage.v2.ObjectAccessControl;
import com.google.storage.v2.ReadObjectRequest;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

final class StorageV2ProtoUtils {
    private static final String VALIDATION_TEMPLATE = "offset >= 0 && limit >= 0 (%s >= 0 && %s >= 0)";
    private static final JsonFormat.Printer PROTO_PRINTER = JsonFormat.printer().omittingInsignificantWhitespace().preservingProtoFieldNames();

    private StorageV2ProtoUtils() {
    }

    static @NonNull ReadObjectRequest seekReadObjectRequest(@NonNull ReadObjectRequest request, @NonNull ByteRangeSpec byteRangeSpec) {
        boolean setLimit;
        long offset = byteRangeSpec.beginOffset();
        long limit = byteRangeSpec.length();
        ReadObjectRequest req = request;
        boolean setOffset = offset > 0L && offset != req.getReadOffset();
        boolean bl = setLimit = limit < Long.MAX_VALUE && limit != req.getReadLimit();
        if (setOffset || setLimit) {
            req = byteRangeSpec.seekReadObjectRequest(req.toBuilder()).build();
        }
        return req;
    }

    static @NonNull String fmtProto(@NonNull MessageOrBuilder msg) {
        try {
            return PROTO_PRINTER.print(msg);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    static Predicate<ObjectAccessControl> objectAclEntityOrAltEq(String s2) {
        return oAcl -> oAcl.getEntity().equals(s2) || oAcl.getEntityAlt().equals(s2);
    }

    static Predicate<BucketAccessControl> bucketAclEntityOrAltEq(String s2) {
        return oAcl -> oAcl.getEntity().equals(s2) || oAcl.getEntityAlt().equals(s2);
    }
}

