/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;

@Internal
public final class SavepointLoader {
    private SavepointLoader() {
    }

    public static CheckpointMetadata loadSavepointMetadata(String savepointPath) throws IOException {
        FsCompletedCheckpointStorageLocation location = AbstractFsCheckpointStorageAccess.resolveCheckpointPointer((String)savepointPath);
        try (DataInputStream stream = new DataInputStream((InputStream)location.getMetadataHandle().openInputStream());){
            CheckpointMetadata checkpointMetadata = Checkpoints.loadCheckpointMetadata((DataInputStream)stream, (ClassLoader)Thread.currentThread().getContextClassLoader(), (String)savepointPath);
            return checkpointMetadata;
        }
    }
}

