/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public abstract class AbstractShowOperation
implements ShowOperation {
    @Nullable
    protected final String catalogName;
    @Nullable
    protected final String preposition;
    @Nullable
    protected final ShowLikeOperator likeOp;

    public AbstractShowOperation(@Nullable String catalogName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        this.catalogName = catalogName;
        this.preposition = preposition;
        this.likeOp = likeOp;
    }

    protected abstract Collection<String> retrieveDataForTableResult(ExecutableOperation.Context var1);

    protected abstract String getOperationName();

    protected abstract String getColumnName();

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Collection<String> views = this.retrieveDataForTableResult(ctx);
        String[] rows = (String[])views.stream().filter(row -> ShowLikeOperator.likeFilter(row, this.likeOp)).sorted().toArray(String[]::new);
        return TableResultUtils.buildStringArrayResult(this.getColumnName(), rows);
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder().append(this.getOperationName());
        if (this.preposition != null) {
            builder.append(" ").append(this.getPrepositionSummaryString());
        }
        if (this.likeOp != null) {
            builder.append(" ").append(this.likeOp);
        }
        return builder.toString();
    }

    protected String getPrepositionSummaryString() {
        return String.format("%s %s", this.preposition, this.catalogName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractShowOperation that = (AbstractShowOperation)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.preposition, that.preposition) && Objects.equals(this.likeOp, that.likeOp);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.preposition, this.likeOp);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

