/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenIdentifier;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsTokenRenewer
extends TokenRenewer {
    public static final Logger LOG = LoggerFactory.getLogger(AbfsTokenRenewer.class);

    @Override
    public boolean handleKind(Text kind) {
        return AbfsDelegationTokenIdentifier.TOKEN_KIND.equals(kind);
    }

    @Override
    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    @Override
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Renewing the delegation token");
        return this.getInstance(conf).renewDelegationToken(token);
    }

    @Override
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Cancelling the delegation token");
        this.getInstance(conf).cancelDelegationToken(token);
    }

    private AbfsDelegationTokenManager getInstance(Configuration conf) throws IOException {
        return new AbfsDelegationTokenManager(conf);
    }
}

