/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractSyncStateTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.utils.FastTop1Helper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class FastTop1Function
extends AbstractSyncStateTopNFunction
implements CheckpointedFunction {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<RowData> inputRowSer;
    private final long cacheSize;
    private transient ValueState<RowData> dataState;
    private transient FastTop1Helper helper;

    public FastTop1Function(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator generatedSortKeyComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, long cacheSize) {
        super(ttlConfig, inputRowType, generatedSortKeyComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.inputRowSer = inputRowType.createSerializer((SerializerConfig)new SerializerConfigImpl());
        this.cacheSize = cacheSize;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor("Top1-Rank-State", (TypeInformation)this.inputRowType);
        if (this.ttlConfig.isEnabled()) {
            valueStateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.dataState = this.getRuntimeContext().getState(valueStateDescriptor);
        this.helper = new SyncStateFastTop1Helper();
        this.helper.registerMetric();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.helper.accRequestCount();
        RowData currentKey = (RowData)this.keyContext.getCurrentKey();
        RowData prevRow = this.helper.getPrevRowFromCache(currentKey);
        if (prevRow == null) {
            prevRow = (RowData)this.dataState.value();
        } else {
            this.helper.accHitCount();
        }
        if (prevRow == null) {
            this.helper.processAsFirstRow(input, currentKey, out);
        } else {
            this.helper.processWithPrevRow(input, currentKey, prevRow, out);
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.helper.flushAllCacheToState();
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
    }

    private class SyncStateFastTop1Helper
    extends FastTop1Helper {
        public SyncStateFastTop1Helper() {
            super(FastTop1Function.this, FastTop1Function.this.inputRowSer, FastTop1Function.this.cacheSize, FastTop1Function.this.getDefaultTopNSize());
        }

        @Override
        public void flushBufferToState(RowData currentKey, RowData value) throws Exception {
            this.keyContext.setCurrentKey((Object)currentKey);
            FastTop1Function.this.dataState.update((Object)value);
        }
    }
}

