/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.rules.physical.FlinkExpandConversionRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\t\u0013\u0001\rB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t%\u000e\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006\u000f\u0002!I\u0001\u0013\u0005\u0006/\u0002!I\u0001\u0017\u0005\u00069\u0002!I!X\u0004\u0006AJA\t!\u0019\u0004\u0006#IA\tA\u0019\u0005\u0006_%!\tA\u001a\u0005\bO&\u0011\r\u0011\"\u0001i\u0011\u0019I\u0017\u0002)A\u0005c!9!.\u0003b\u0001\n\u0003A\u0007BB6\nA\u0003%\u0011\u0007C\u0003m\u0013\u0011\u0005Q\u000eC\u0003y\u0013\u0011\u0005\u0011PA\rGY&t7.\u0012=qC:$7i\u001c8wKJ\u001c\u0018n\u001c8Sk2,'BA\n\u0015\u0003!\u0001\b._:jG\u0006d'BA\u000b\u0017\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0002$\u0001\u0003qY\u0006t'BA\r\u001b\u0003\u001d\u0001H.\u00198oKJT!a\u0007\u000f\u0002\u000bQ\f'\r\\3\u000b\u0005uq\u0012!\u00024mS:\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001IA\u0011Q%K\u0007\u0002M)\u0011qc\n\u0006\u0003Qy\tqaY1mG&$X-\u0003\u0002+M\tQ!+\u001a7PaR\u0014V\u000f\\3\u0002\u001f\u0019d\u0017N\\6D_:4XM\u001c;j_:\u0004\"!J\u0017\n\u000592#AC\"p]Z,g\u000e^5p]\u00061A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\n\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\u000f5\fGo\u00195fgR\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015i4\u00011\u0001?\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005\u0015z\u0014B\u0001!'\u00059\u0011V\r\\(qiJ+H.Z\"bY2\fqa\u001c8NCR\u001c\u0007\u000e\u0006\u0002D\rB\u0011q\u0007R\u0005\u0003\u000bb\u0012A!\u00168ji\")Q\b\u0002a\u0001}\u0005\u00192/\u0019;jg\u001aLHK]1jiN\u0014\u0015pU3mMR!1)S)W\u0011\u0015QU\u00011\u0001L\u0003\u0011qw\u000eZ3\u0011\u00051{U\"A'\u000b\u00059;\u0013a\u0001:fY&\u0011\u0001+\u0014\u0002\b%\u0016dgj\u001c3f\u0011\u0015\u0011V\u00011\u0001T\u00039\u0011X-];je\u0016$GK]1jiN\u0004\"!\n+\n\u0005U3#a\u0003*fYR\u0013\u0018-\u001b;TKRDQ!P\u0003A\u0002y\nAc]1uSN4\u0017\u0010\u0016:bSR\u001c()_%oaV$H\u0003B\"Z5nCQA\u0013\u0004A\u0002-CQA\u0015\u0004A\u0002MCQ!\u0010\u0004A\u0002y\n\u0011d\u00195fG.\u001c\u0016\r^5tMf\u0014V-];je\u0016$GK]1jiR\u00191IX0\t\u000b);\u0001\u0019A&\t\u000bI;\u0001\u0019A*\u00023\u0019c\u0017N\\6FqB\fg\u000eZ\"p]Z,'o]5p]J+H.\u001a\t\u0003e%\u0019\"!C2\u0011\u0005]\"\u0017BA39\u0005\u0019\te.\u001f*fMR\t\u0011-\u0001\bC\u0003R\u001b\u0005jX%O'R\u000bejQ#\u0016\u0003E\nqBQ!U\u0007\"{\u0016JT*U\u0003:\u001bU\tI\u0001\u0010'R\u0013V)Q'`\u0013:\u001bF+\u0011(D\u000b\u0006\u00012\u000b\u0016*F\u00036{\u0016JT*U\u0003:\u001bU\tI\u0001\u0014g\u0006$\u0018n\u001d4z\t&\u001cHO]5ckRLwN\u001c\u000b\u0005\u0017:|\u0007\u000fC\u0003,\u001f\u0001\u0007A\u0006C\u0003K\u001f\u0001\u00071\nC\u0003r\u001f\u0001\u0007!/\u0001\u000bsKF,\u0018N]3e\t&\u001cHO]5ckRLwN\u001c\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kZ\tQ\u0001\u001e:bSRL!a\u001e;\u0003)\u0019c\u0017N\\6SK2$\u0015n\u001d;sS\n,H/[8o\u0003A\u0019\u0018\r^5tMf\u001cu\u000e\u001c7bi&|g\u000e\u0006\u0003Lund\b\"B\u0016\u0011\u0001\u0004a\u0003\"\u0002&\u0011\u0001\u0004Y\u0005\"B?\u0011\u0001\u0004q\u0018!\u0005:fcVL'/\u001a3D_2d\u0017\r^5p]B\u0011Aj`\u0005\u0004\u0003\u0003i%\u0001\u0004*fY\u000e{G\u000e\\1uS>t\u0007")
public class FlinkExpandConversionRule
extends RelOptRule {
    private final Convention flinkConvention;

    public static RelNode satisfyCollation(Convention convention, RelNode relNode, RelCollation relCollation) {
        return FlinkExpandConversionRule$.MODULE$.satisfyCollation(convention, relNode, relCollation);
    }

    public static RelNode satisfyDistribution(Convention convention, RelNode relNode, FlinkRelDistribution flinkRelDistribution) {
        return FlinkExpandConversionRule$.MODULE$.satisfyDistribution(convention, relNode, flinkRelDistribution);
    }

    public static FlinkExpandConversionRule STREAM_INSTANCE() {
        return FlinkExpandConversionRule$.MODULE$.STREAM_INSTANCE();
    }

    public static FlinkExpandConversionRule BATCH_INSTANCE() {
        return FlinkExpandConversionRule$.MODULE$.BATCH_INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        RelTraitSet toTraitSet = ((AbstractConverter)call.rel(0)).getTraitSet();
        RelTraitSet fromTraitSet = call.rel(1).getTraitSet();
        return toTraitSet.contains(this.flinkConvention) && fromTraitSet.contains(this.flinkConvention) && !fromTraitSet.satisfies(toTraitSet);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AbstractConverter converter = (AbstractConverter)call.rel(0);
        Object child = call.rel(1);
        RelTraitSet toTraitSet = converter.getTraitSet();
        this.satisfyTraitsBySelf((RelNode)child, toTraitSet, call);
        this.satisfyTraitsByInput((RelNode)child, toTraitSet, call);
    }

    private void satisfyTraitsBySelf(RelNode node, RelTraitSet requiredTraits, RelOptRuleCall call) {
        RelNode transformedNode = node;
        List<RelTraitDef> definedTraitDefs = call.getPlanner().getRelTraitDefs();
        if (definedTraitDefs.contains(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE())) {
            FlinkRelDistribution toDistribution = requiredTraits.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
            transformedNode = FlinkExpandConversionRule$.MODULE$.satisfyDistribution(this.flinkConvention, transformedNode, toDistribution);
        }
        if (definedTraitDefs.contains(RelCollationTraitDef.INSTANCE)) {
            RelCollation toCollation = requiredTraits.getTrait(RelCollationTraitDef.INSTANCE);
            transformedNode = FlinkExpandConversionRule$.MODULE$.satisfyCollation(this.flinkConvention, transformedNode, toCollation);
        }
        this.checkSatisfyRequiredTrait(transformedNode, requiredTraits);
        call.transformTo(transformedNode);
    }

    private void satisfyTraitsByInput(RelNode node, RelTraitSet requiredTraits, RelOptRuleCall call) {
        RelNode relNode = node;
        if (relNode instanceof BatchPhysicalRel) {
            BatchPhysicalRel batchPhysicalRel = (BatchPhysicalRel)relNode;
            Option<RelNode> otherChoice = batchPhysicalRel.satisfyTraits(requiredTraits);
            Option<RelNode> option = otherChoice;
            if (option instanceof Some) {
                Some some = (Some)option;
                RelNode newRel = (RelNode)some.value();
                RelCollation requiredCollation = requiredTraits.getTrait(RelCollationTraitDef.INSTANCE);
                RelNode finalRel = FlinkExpandConversionRule$.MODULE$.satisfyCollation(this.flinkConvention, newRel, requiredCollation);
                this.checkSatisfyRequiredTrait(finalRel, requiredTraits);
                call.transformTo(finalRel);
            }
            return;
        }
    }

    private void checkSatisfyRequiredTrait(RelNode node, RelTraitSet requiredTraits) {
        if (!node.getTraitSet().satisfies(requiredTraits)) {
            throw new RuntimeException(new StringBuilder(123).append("the node which is converted by FlinkExpandConversionRule can't satisfied the target ").append("traits!\nnode traits: ").append(node.getTraitSet()).append("\nrequired traits: ").append(requiredTraits).toString());
        }
    }

    public FlinkExpandConversionRule(Convention flinkConvention) {
        this.flinkConvention = flinkConvention;
        super(RelOptRule.operand(AbstractConverter.class, RelOptRule.operand(RelNode.class, RelOptRule.any()), new RelOptRuleOperand[0]), "FlinkExpandConversionRule");
    }
}

