/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-python-over-aggregate", version=1, producedTransformations={"python-over-aggregate"}, minPlanVersion=FlinkVersion.v1_16, minStateVersion=FlinkVersion.v1_16)
public class StreamExecPythonOverAggregate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecPythonOverAggregate.class);
    public static final String PYTHON_OVER_AGGREGATE_TRANSFORMATION = "python-over-aggregate";
    public static final String FIELD_NAME_OVER_SPEC = "overSpec";
    private static final String ARROW_PYTHON_OVER_WINDOW_RANGE_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRangeOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_RANGE_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonProcTimeBoundedRangeOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_ROWS_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRowsOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_ROWS_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonProcTimeBoundedRowsOperator";
    @JsonProperty(value="overSpec")
    private final OverSpec overSpec;

    public StreamExecPythonOverAggregate(ReadableConfig tableConfig, OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecPythonOverAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecPythonOverAggregate.class, tableConfig), overSpec, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecPythonOverAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="overSpec") OverSpec overSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.overSpec = (OverSpec)Preconditions.checkNotNull((Object)overSpec);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int rowTimeIdx;
        if (this.overSpec.getGroups().size() > 1) {
            throw new TableException("All aggregates must be computed on the same window.");
        }
        OverSpec.GroupSpec group = this.overSpec.getGroups().get(0);
        int[] orderKeys = group.getSort().getFieldIndices();
        boolean[] isAscendingOrders = group.getSort().getAscendingOrders();
        if (orderKeys.length != 1 || isAscendingOrders.length != 1) {
            throw new TableException("The window can only be ordered by a single time column.");
        }
        if (!isAscendingOrders[0]) {
            throw new TableException("The window can only be ordered in ASCENDING mode.");
        }
        int[] partitionKeys = this.overSpec.getPartition().getFieldIndices();
        if (partitionKeys.length > 0 && config.getStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        int orderKey = orderKeys[0];
        LogicalType orderKeyType = ((RowType.RowField)inputRowType.getFields().get(orderKey)).getType();
        if (LogicalTypeChecks.isRowtimeAttribute((LogicalType)orderKeyType)) {
            rowTimeIdx = orderKey;
        } else if (LogicalTypeChecks.isProctimeAttribute((LogicalType)orderKeyType)) {
            rowTimeIdx = -1;
        } else {
            throw new TableException("OVER windows' ordering in stream mode must be defined on a time attribute.");
        }
        if (group.getLowerBound().isPreceding() && group.getLowerBound().isUnbounded()) {
            throw new TableException("Python UDAF is not supported to be used in UNBOUNDED PRECEDING OVER windows.");
        }
        if (!group.getUpperBound().isCurrentRow()) {
            throw new TableException("Python UDAF is not supported to be used in UNBOUNDED FOLLOWING OVER windows.");
        }
        Object boundValue = OverAggregateUtil.getBoundary(this.overSpec, group.getLowerBound());
        if (boundValue instanceof BigDecimal) {
            throw new TableException("the specific value is decimal which haven not supported yet.");
        }
        long precedingOffset = -1L * (Long)boundValue;
        Configuration pythonConfig = CommonPythonUtil.extractPythonConfiguration((ReadableConfig)planner.getTableConfig(), planner.getFlinkContext().getClassLoader());
        OneInputTransformation<RowData, RowData> transform = this.createPythonOneInputTransformation(inputTransform, inputRowType, InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType(), rowTimeIdx, group.getAggCalls().toArray(new AggregateCall[0]), precedingOffset, group.isRows(), config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), pythonConfig, config, planner.getFlinkContext().getClassLoader());
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(pythonConfig, planner.getFlinkContext().getClassLoader())) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), partitionKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, int rowTimeIdx, AggregateCall[] aggCalls, long lowerBoundary, boolean isRowsClause, long minIdleStateRetentionTime, long maxIdleStateRetentionTime, Configuration pythonConfig, ExecNodeConfig config, ClassLoader classLoader) {
        Tuple2<int[], PythonFunctionInfo[]> aggCallInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(aggCalls);
        int[] pythonUdafInputOffsets = (int[])aggCallInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggCallInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonOverWindowAggregateFunctionOperator(config, classLoader, pythonConfig, inputRowType, outputRowType, rowTimeIdx, lowerBoundary, isRowsClause, pythonUdafInputOffsets, pythonFunctionInfos, minIdleStateRetentionTime, maxIdleStateRetentionTime);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(PYTHON_OVER_AGGREGATE_TRANSFORMATION, config), pythonOperator, InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperator<RowData, RowData> getPythonOverWindowAggregateFunctionOperator(ExecNodeConfig config, ClassLoader classLoader, Configuration pythonConfig, RowType inputRowType, RowType outputRowType, int rowTiemIdx, long lowerBoundary, boolean isRowsClause, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos, long minIdleStateRetentionTime, long maxIdleStateRetentionTime) {
        RowType userDefinedFunctionInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputRowType);
        RowType userDefinedFunctionOutputType = (RowType)Projection.range((int)inputRowType.getFieldCount(), (int)outputRowType.getFieldCount()).project((LogicalType)outputRowType);
        GeneratedProjection generatedProjection = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, classLoader), "UdafInputProjection", inputRowType, userDefinedFunctionInputType, udafInputOffsets);
        if (isRowsClause) {
            String className = rowTiemIdx != -1 ? ARROW_PYTHON_OVER_WINDOW_ROWS_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME : ARROW_PYTHON_OVER_WINDOW_ROWS_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME;
            Class<?> clazz = CommonPythonUtil.loadClass(className, classLoader);
            try {
                Constructor<?> ctor = clazz.getConstructor(Configuration.class, Long.TYPE, Long.TYPE, PythonFunctionInfo[].class, RowType.class, RowType.class, RowType.class, Integer.TYPE, Long.TYPE, GeneratedProjection.class);
                return (OneInputStreamOperator)ctor.newInstance(pythonConfig, minIdleStateRetentionTime, maxIdleStateRetentionTime, pythonFunctionInfos, inputRowType, userDefinedFunctionInputType, userDefinedFunctionOutputType, rowTiemIdx, lowerBoundary, generatedProjection);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TableException("Python Arrow Over Rows Window Function Operator constructed failed.", (Throwable)e);
            }
        }
        String className = rowTiemIdx != -1 ? ARROW_PYTHON_OVER_WINDOW_RANGE_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME : ARROW_PYTHON_OVER_WINDOW_RANGE_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME;
        Class<?> clazz = CommonPythonUtil.loadClass(className, classLoader);
        try {
            Constructor<?> ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, RowType.class, Integer.TYPE, Long.TYPE, GeneratedProjection.class);
            return (OneInputStreamOperator)ctor.newInstance(pythonConfig, pythonFunctionInfos, inputRowType, userDefinedFunctionInputType, userDefinedFunctionOutputType, rowTiemIdx, lowerBoundary, generatedProjection);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python Arrow Over Range Window Function Operator constructed failed.", (Throwable)e);
        }
    }
}

