/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;

@Internal
final class TableDistributionJsonDeserializer
extends StdDeserializer<TableDistribution> {
    private static final long serialVersionUID = 1L;

    TableDistributionJsonDeserializer() {
        super(TableDistribution.class);
    }

    public TableDistribution deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        if (!(jsonNode instanceof ObjectNode)) {
            return null;
        }
        TableDistribution.Kind kind = (TableDistribution.Kind)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("kind"), jsonParser.getCodec()), TableDistribution.Kind.class);
        Optional<Integer> bucketCount = JsonSerdeUtil.deserializeOptionalField((ObjectNode)jsonNode, "bucketCount", Integer.class, jsonParser.getCodec(), ctx);
        List bucketKeys = (List)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("bucketKeys"), jsonParser.getCodec()), (JavaType)ctx.getTypeFactory().constructCollectionType(List.class, String.class));
        return TableDistribution.of((TableDistribution.Kind)kind, (Integer)bucketCount.orElseGet(() -> null), (List)bucketKeys);
    }
}

