/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.LogicalRelDataTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
final class RelDataTypeJsonDeserializer
extends StdDeserializer<RelDataType> {
    private static final long serialVersionUID = 1L;

    RelDataTypeJsonDeserializer() {
        super(RelDataType.class);
    }

    public RelDataType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode logicalTypeNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeContext = SerdeContext.get((DatabindContext)ctx);
        return RelDataTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
    }

    static RelDataType deserialize(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        FlinkTypeFactory typeFactory = serdeContext.getTypeFactory();
        LogicalType logicalType = LogicalTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
        return LogicalRelDataTypeConverter.toRelDataType(logicalType, typeFactory);
    }
}

