/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalSortWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalWindowAggregateBase;
import org.apache.flink.table.planner.plan.stats.FiniteValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.plan.stats.WithLower;
import org.apache.flink.table.planner.plan.stats.WithUpper;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u000b\u0017\u0001\u0015B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)1\t\u0001C\u0001\t\"9\u0001\n\u0001b\u0001\n\u0013I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011B(\t\rM\u0003\u0001\u0015!\u0003Q\u0011!!\u0006A1A\u0005\u0002y)\u0006BB-\u0001A\u0003%a\u000bC\u0003[\u0001\u0011\u00051\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005u\u0001\u0001\"\u0003\u0002R!9\u0011\u0011\f\u0001\u0005\n\u0005m#aG!hO\u000e\u000bG\u000e\\*fY\u0016\u001cG/\u001b<jif,5\u000f^5nCR|'O\u0003\u0002\u00181\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u001a5\u0005!\u0001\u000f\\1o\u0015\tYB$A\u0004qY\u0006tg.\u001a:\u000b\u0005uq\u0012!\u0002;bE2,'BA\u0010!\u0003\u00151G.\u001b8l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\n\t\u0004O1rS\"\u0001\u0015\u000b\u0005%R\u0013a\u0001:fq*\u00111\u0006I\u0001\bG\u0006d7-\u001b;f\u0013\ti\u0003F\u0001\bSKb4\u0016n]5u_JLU\u000e\u001d7\u0011\u0007=\u0012D'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019y\u0005\u000f^5p]B\u0011q&N\u0005\u0003mA\u0012a\u0001R8vE2,\u0017aA1hOB\u0011\u0011\bP\u0007\u0002u)\u00111HK\u0001\u0004e\u0016d\u0017BA\u001f;\u0005\u001d\u0011V\r\u001c(pI\u0016\f!!\\9\u0011\u0005\u0001\u000bU\"\u0001\f\n\u0005\t3\"!\u0006$mS:\\'+\u001a7NKR\fG-\u0019;b#V,'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00153u\t\u0005\u0002A\u0001!)qg\u0001a\u0001q!)ah\u0001a\u0001\u007f\u0005Q!/\u001a=Ck&dG-\u001a:\u0016\u0003)\u0003\"aJ&\n\u00051C#A\u0003*fq\n+\u0018\u000e\u001c3fe\u0006Y!/\u001a=Ck&dG-\u001a:!\u0003\t\u0019X-F\u0001Q!\t\u0001\u0015+\u0003\u0002S-\t!2+\u001a7fGRLg/\u001b;z\u000bN$\u0018.\\1u_J\f1a]3!\u0003e!WMZ1vYR\fumZ\"bY2\u001cV\r\\3di&4\u0018\u000e^=\u0016\u0003Y\u00032aL,5\u0013\tA\u0006G\u0001\u0003T_6,\u0017A\u00073fM\u0006,H\u000e^!hO\u000e\u000bG\u000e\\*fY\u0016\u001cG/\u001b<jif\u0004\u0013aE4fiN+\b\u000f]8si\u0016$\u0017iZ4DC2dGC\u0001/d!\ry#'\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Aj\nAaY8sK&\u0011!m\u0018\u0002\u000e\u0003\u001e<'/Z4bi\u0016\u001c\u0015\r\u001c7\t\u000b\u0011T\u0001\u0019A3\u0002\u0013=,H\u000f];u\u0013\u0012D\bCA\u0018g\u0013\t9\u0007GA\u0002J]R\f!#[:TkB\u0004xN\u001d;fI\u0006;wmQ1mYR\u0011!.\u001c\t\u0003_-L!\u0001\u001c\u0019\u0003\u000f\t{w\u000e\\3b]\")an\u0003a\u0001;\u00069\u0011mZ4DC2d\u0017AE4fi\u0006;wmQ1mY&sG/\u001a:wC2$\"!]<\u0011\u0005I,X\"A:\u000b\u0005QD\u0012!B:uCR\u001c\u0018B\u0001<t\u000551\u0016\r\\;f\u0013:$XM\u001d<bY\")a\u000e\u0004a\u0001;\u0006AQM^1mk\u0006$X\r\u0006\u0002/u\")10\u0004a\u0001y\u0006I\u0001O]3eS\u000e\fG/\u001a\t\u0003OuL!A \u0015\u0003\u000fI+\u0007PT8eK\u0006Ia/[:ji\u000e\u000bG\u000e\u001c\u000b\u0004]\u0005\r\u0001bBA\u0003\u001d\u0001\u0007\u0011qA\u0001\u0005G\u0006dG\u000eE\u0002(\u0003\u0013I1!a\u0003)\u0005\u001d\u0011V\r_\"bY2\fq\"Z:uS6\fG/Z(qKJ\fg\u000e\u001a\u000b\u0004i\u0005E\u0001BBA\n\u001f\u0001\u0007A0A\u0004pa\u0016\u0014\u0018M\u001c3\u0002/\u0015\u001cH/[7bi\u0016\u001c\u0016N\\4mKB\u0013X\rZ5dCR,Gc\u0001\u0018\u0002\u001a!9\u00111\u0004\tA\u0002\u0005\u001d\u0011aD:j]\u001edW\r\u0015:fI&\u001c\u0017\r^3\u0002%\u0015\u001cH/[7bi\u0016\u001cu.\u001c9be&\u001cxN\u001c\u000b\b]\u0005\u0005\u0012\u0011GA\u001b\u0011\u001d\t\u0019#\u0005a\u0001\u0003K\t!a\u001c9\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b+\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003_\tICA\u0006Tc2|\u0005/\u001a:bi>\u0014\bBBA\u001a#\u0001\u0007A0\u0001\u0003mK\u001a$\bBBA\u001c#\u0001\u0007A0A\u0003sS\u001eDG/\u0001\bfgRLW.\u0019;f\u000bF,\u0018\r\\:\u0015\u000b9\ni$a\u0012\t\u000f\u0005}\"\u00031\u0001\u0002B\u0005A\u0011N\u001c9viJ+g\rE\u0002(\u0003\u0007J1!!\u0012)\u0005-\u0011V\r_%oaV$(+\u001a4\t\u000f\u0005%#\u00031\u0001\u0002L\u00059A.\u001b;fe\u0006d\u0007cA\u0014\u0002N%\u0019\u0011q\n\u0015\u0003\u0015I+\u0007\u0010T5uKJ\fG\u000eF\u0004/\u0003'\n)&a\u0016\t\u000f\u0005\r2\u00031\u0001\u0002&!9\u0011qH\nA\u0002\u0005\u0005\u0003bBA%'\u0001\u0007\u00111J\u0001\u001aKN$\u0018.\\1uK:+X.\u001a:jG\u000e{W\u000e]1sSN|g\u000eF\u0004/\u0003;\ny&!\u0019\t\u000f\u0005\rB\u00031\u0001\u0002&!)a\u000e\u0006a\u0001;\"9\u0011\u0011\n\u000bA\u0002\u0005-\u0003")
public class AggCallSelectivityEstimator
extends RexVisitorImpl<Option<Object>> {
    private final RelNode agg;
    private final FlinkRelMetadataQuery mq;
    private final RexBuilder rexBuilder;
    private final SelectivityEstimator se;
    private final Some<Object> defaultAggCallSelectivity;

    private RexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    private SelectivityEstimator se() {
        return this.se;
    }

    public Some<Object> defaultAggCallSelectivity() {
        return this.defaultAggCallSelectivity;
    }

    public Option<AggregateCall> getSupportedAggCall(int outputIdx) {
        Tuple2 tuple2;
        RelNode relNode = this.agg;
        if (relNode instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)relNode;
            Tuple2<int[], Seq<AggregateCall>> tuple22 = AggregateUtil$.MODULE$.checkAndSplitAggCalls(aggregate);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int[] auxGroupSet = (int[])tuple22._1();
            Seq otherAggCalls = (Seq)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)auxGroupSet, (Object)otherAggCalls);
            int[] auxGroupSet2 = (int[])tuple23._1();
            Seq otherAggCalls2 = (Seq)tuple23._2();
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(aggregate.getGroupSet().toArray())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGroupSet2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), (Object)otherAggCalls2);
        } else if (relNode instanceof BatchPhysicalGroupAggregateBase) {
            BatchPhysicalGroupAggregateBase batchPhysicalGroupAggregateBase = (BatchPhysicalGroupAggregateBase)relNode;
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalGroupAggregateBase.grouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalGroupAggregateBase.auxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), batchPhysicalGroupAggregateBase.getAggCallList());
        } else if (relNode instanceof BatchPhysicalLocalHashWindowAggregate) {
            BatchPhysicalLocalHashWindowAggregate batchPhysicalLocalHashWindowAggregate = (BatchPhysicalLocalHashWindowAggregate)relNode;
            int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalLocalHashWindowAggregate.grouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchPhysicalLocalHashWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalLocalHashWindowAggregate.auxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            tuple2 = new Tuple2((Object)fullGrouping, batchPhysicalLocalHashWindowAggregate.getAggCallList());
        } else if (relNode instanceof BatchPhysicalLocalSortWindowAggregate) {
            BatchPhysicalLocalSortWindowAggregate batchPhysicalLocalSortWindowAggregate = (BatchPhysicalLocalSortWindowAggregate)relNode;
            int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalLocalSortWindowAggregate.grouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchPhysicalLocalSortWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalLocalSortWindowAggregate.auxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            tuple2 = new Tuple2((Object)fullGrouping, batchPhysicalLocalSortWindowAggregate.getAggCallList());
        } else if (relNode instanceof BatchPhysicalWindowAggregateBase) {
            BatchPhysicalWindowAggregateBase batchPhysicalWindowAggregateBase = (BatchPhysicalWindowAggregateBase)relNode;
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalWindowAggregateBase.grouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchPhysicalWindowAggregateBase.auxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), batchPhysicalWindowAggregateBase.getAggCallList());
        } else {
            throw new IllegalArgumentException(new StringBuilder(15).append("Cannot handle ").append(this.agg.getRelTypeName()).append("!").toString());
        }
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int[] fullGrouping = (int[])tuple24._1();
        Seq aggCalls = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)fullGrouping, (Object)aggCalls);
        int[] fullGrouping2 = (int[])tuple25._1();
        Seq aggCalls2 = (Seq)tuple25._2();
        Predef$.MODULE$.require(outputIdx >= fullGrouping2.length);
        int aggCallIdx = outputIdx - fullGrouping2.length;
        AggregateCall aggCall2 = aggCallIdx < aggCalls2.length() ? (AggregateCall)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(aggCalls2).get(aggCallIdx) : null;
        return Option$.MODULE$.apply(aggCall2).filter((Function1 & Serializable & scala.Serializable)aggCall -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedAggCall(aggCall)));
    }

    public boolean isSupportedAggCall(AggregateCall aggCall) {
        SqlKind sqlKind = aggCall.getAggregation().getKind();
        if (((Object)((Object)SqlKind.SUM)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MAX)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MIN)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AVG)).equals((Object)sqlKind)))) {
            return true;
        }
        if (((Object)((Object)SqlKind.COUNT)).equals((Object)sqlKind)) {
            return aggCall.getArgList().size() == 1;
        }
        return false;
    }

    public ValueInterval getAggCallInterval(AggregateCall aggCall) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        Tuple2 tuple24;
        RelNode aggInput = this.agg.getInput(0);
        SqlKind sqlKind = aggCall.getAggregation().getKind();
        SqlKind sqlKind2 = SqlKind.COUNT;
        if (!(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)sqlKind2) : sqlKind2 != null)) {
            Option option = this.getRowCntPerGroup$1(aggInput);
            if (option instanceof Some) {
                Some some = (Some)option;
                double rowCntPerGroup = BoxesRunTime.unboxToDouble((Object)some.value());
                double lower = package$.MODULE$.max(rowCntPerGroup / (double)2, 1.0);
                double upper = rowCntPerGroup * (double)2;
                return ValueInterval$.MODULE$.apply(BoxesRunTime.boxToDouble((double)lower), BoxesRunTime.boxToDouble((double)upper), true, true);
            }
            return null;
        }
        ValueInterval argInterval = this.mq.getColumnInterval(aggInput, Predef$.MODULE$.Integer2int((Integer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCall.getArgList()).head()));
        ValueInterval valueInterval = argInterval;
        if (valueInterval == null) {
            return null;
        }
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.infinite();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            return ValueInterval$.MODULE$.infinite();
        }
        ValueInterval valueInterval4 = ValueInterval$.MODULE$.empty();
        ValueInterval valueInterval5 = valueInterval;
        if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
            return ValueInterval$.MODULE$.empty();
        }
        ValueInterval valueInterval6 = argInterval;
        if (valueInterval6 instanceof WithLower) {
            WithLower withLower = (WithLower)valueInterval6;
            tuple24 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withLower.lower()), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
        } else {
            tuple24 = tuple23 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Double min2 = (Double)tuple23._1();
        boolean includeMin = tuple23._2$mcZ$sp();
        Tuple2 tuple25 = new Tuple2((Object)min2, (Object)BoxesRunTime.boxToBoolean((boolean)includeMin));
        Double min3 = (Double)tuple25._1();
        boolean includeMin2 = tuple25._2$mcZ$sp();
        ValueInterval valueInterval7 = argInterval;
        if (valueInterval7 instanceof WithUpper) {
            WithUpper withUpper = (WithUpper)valueInterval7;
            tuple22 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withUpper.upper()), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
        } else {
            tuple22 = tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double max = (Double)tuple2._1();
        boolean includeMax = tuple2._2$mcZ$sp();
        Tuple2 tuple26 = new Tuple2((Object)max, (Object)BoxesRunTime.boxToBoolean((boolean)includeMax));
        Double max2 = (Double)tuple26._1();
        boolean includeMax2 = tuple26._2$mcZ$sp();
        return ValueInterval$.MODULE$.apply(this.getAggCallValue$1(min3, aggCall, aggInput), this.getAggCallValue$1(max2, aggCall, aggInput), includeMin2, includeMax2);
    }

    public Option<Object> evaluate(RexNode predicate) {
        Option<Object> option;
        block5: {
            try {
                if (predicate == null) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                    break block5;
                }
                RexSimplify rexSimplify = new RexSimplify(this.rexBuilder(), RelOptPredicateList.EMPTY, RexUtil.EXECUTOR);
                RexNode simplifiedPredicate = rexSimplify.simplifyUnknownAs(predicate, RexUnknownAs.falseIf(true));
                if (simplifiedPredicate.isAlwaysTrue()) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                    break block5;
                }
                if (simplifiedPredicate.isAlwaysFalse()) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                    break block5;
                }
                option = simplifiedPredicate.accept(this);
            }
            catch (Throwable throwable) {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    @Override
    public Option<Object> visitCall(RexCall call) {
        List<RexNode> operands = call.getOperands();
        SqlOperator sqlOperator = call.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.AND;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            Buffer selectivity = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).map((Function1 & Serializable & scala.Serializable)operand -> BoxesRunTime.boxToDouble((double)this.estimateOperand(operand)), Buffer$.MODULE$.canBuildFrom());
            return new Some(selectivity.product((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }
        SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.OR;
        SqlOperator sqlOperator3 = sqlOperator;
        if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
            Buffer selectivity = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).map((Function1 & Serializable & scala.Serializable)operand -> BoxesRunTime.boxToDouble((double)this.estimateOperand(operand)), Buffer$.MODULE$.canBuildFrom());
            return new Some((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(1.0, BoxesRunTime.unboxToDouble((Object)selectivity.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)selectivity.product((Numeric)Numeric.DoubleIsFractional$.MODULE$)))));
        }
        SqlPrefixOperator sqlPrefixOperator = SqlStdOperatorTable.NOT;
        SqlOperator sqlOperator4 = sqlOperator;
        if (!(sqlPrefixOperator != null ? !((Object)sqlPrefixOperator).equals(sqlOperator4) : sqlOperator4 != null)) {
            double selectivity = this.estimateOperand((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head());
            return new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - selectivity)));
        }
        return this.estimateSinglePredicate(call);
    }

    public double estimateOperand(RexNode operand) {
        Option<Object> subSelectivity = operand.accept(this);
        if (subSelectivity != null) {
            return BoxesRunTime.unboxToDouble((Object)subSelectivity.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
        }
        return 1.0;
    }

    private Option<Object> estimateSinglePredicate(RexCall singlePredicate) {
        List<RexNode> operands = singlePredicate.getOperands();
        SqlOperator sqlOperator = singlePredicate.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.EQUALS;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            return this.estimateComparison((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        }
        SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.NOT_EQUALS;
        SqlOperator sqlOperator3 = sqlOperator;
        if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
            Option<Object> selectivity = this.estimateComparison((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
            return new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)selectivity.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0)))));
        }
        SqlBinaryOperator sqlBinaryOperator3 = SqlStdOperatorTable.GREATER_THAN;
        SqlOperator sqlOperator4 = sqlOperator;
        if (!(sqlBinaryOperator3 != null ? !((Object)sqlBinaryOperator3).equals(sqlOperator4) : sqlOperator4 != null)) {
            return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        }
        SqlBinaryOperator sqlBinaryOperator4 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlOperator sqlOperator5 = sqlOperator;
        if (!(sqlBinaryOperator4 != null ? !((Object)sqlBinaryOperator4).equals(sqlOperator5) : sqlOperator5 != null)) {
            return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        }
        SqlBinaryOperator sqlBinaryOperator5 = SqlStdOperatorTable.LESS_THAN;
        SqlOperator sqlOperator6 = sqlOperator;
        if (!(sqlBinaryOperator5 != null ? !((Object)sqlBinaryOperator5).equals(sqlOperator6) : sqlOperator6 != null)) {
            return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        }
        SqlBinaryOperator sqlBinaryOperator6 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        SqlOperator sqlOperator7 = sqlOperator;
        if (!(sqlBinaryOperator6 != null ? !((Object)sqlBinaryOperator6).equals(sqlOperator7) : sqlOperator7 != null)) {
            return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        }
        SqlFunction sqlFunction = RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC;
        SqlOperator sqlOperator8 = sqlOperator;
        if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator8) : sqlOperator8 != null)) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)RelMdUtil.getSelectivityValue(singlePredicate)));
        }
        return this.se().defaultSelectivity();
    }

    private Option<Object> estimateComparison(SqlOperator op, RexNode left, RexNode right) {
        if (!SelectivityEstimator$.MODULE$.isSupportedComparisonType(left.getType()) || !SelectivityEstimator$.MODULE$.isSupportedComparisonType(right.getType())) {
            SqlOperator sqlOperator = op;
            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.EQUALS;
            SqlOperator sqlOperator2 = sqlOperator;
            Some<Object> some = !(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null) ? this.se().defaultEqualsSelectivity() : this.se().defaultComparisonSelectivity();
            return some;
        }
        SqlOperator sqlOperator = op;
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.EQUALS;
        SqlOperator sqlOperator3 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator3) : sqlOperator3 != null)) {
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            if (tuple2 != null) {
                RexNode i = (RexNode)tuple2._1();
                RexNode l = (RexNode)tuple2._2();
                if (i instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)i;
                    if (l instanceof RexLiteral) {
                        RexLiteral rexLiteral = (RexLiteral)l;
                        return this.estimateEquals(rexInputRef, rexLiteral);
                    }
                }
            }
            if (tuple2 != null) {
                RexNode l = (RexNode)tuple2._1();
                RexNode i = (RexNode)tuple2._2();
                if (l instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)i;
                        return this.estimateEquals(rexInputRef, rexLiteral);
                    }
                }
            }
            return this.se().defaultEqualsSelectivity();
        }
        SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.LESS_THAN;
        SqlOperator sqlOperator4 = sqlOperator;
        if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator4) : sqlOperator4 != null)) {
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            if (tuple2 != null) {
                RexNode i = (RexNode)tuple2._1();
                RexNode l = (RexNode)tuple2._2();
                if (i instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)i;
                    if (l instanceof RexLiteral) {
                        RexLiteral rexLiteral = (RexLiteral)l;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, rexInputRef, rexLiteral);
                    }
                }
            }
            if (tuple2 != null) {
                RexNode l = (RexNode)tuple2._1();
                RexNode i = (RexNode)tuple2._2();
                if (l instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)i;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, rexInputRef, rexLiteral);
                    }
                }
            }
            return this.se().defaultComparisonSelectivity();
        }
        SqlBinaryOperator sqlBinaryOperator3 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        SqlOperator sqlOperator5 = sqlOperator;
        if (!(sqlBinaryOperator3 != null ? !((Object)sqlBinaryOperator3).equals(sqlOperator5) : sqlOperator5 != null)) {
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            if (tuple2 != null) {
                RexNode i = (RexNode)tuple2._1();
                RexNode l = (RexNode)tuple2._2();
                if (i instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)i;
                    if (l instanceof RexLiteral) {
                        RexLiteral rexLiteral = (RexLiteral)l;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, rexInputRef, rexLiteral);
                    }
                }
            }
            if (tuple2 != null) {
                RexNode l = (RexNode)tuple2._1();
                RexNode i = (RexNode)tuple2._2();
                if (l instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)i;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, rexInputRef, rexLiteral);
                    }
                }
            }
            return this.se().defaultComparisonSelectivity();
        }
        SqlBinaryOperator sqlBinaryOperator4 = SqlStdOperatorTable.GREATER_THAN;
        SqlOperator sqlOperator6 = sqlOperator;
        if (!(sqlBinaryOperator4 != null ? !((Object)sqlBinaryOperator4).equals(sqlOperator6) : sqlOperator6 != null)) {
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            if (tuple2 != null) {
                RexNode i = (RexNode)tuple2._1();
                RexNode l = (RexNode)tuple2._2();
                if (i instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)i;
                    if (l instanceof RexLiteral) {
                        RexLiteral rexLiteral = (RexLiteral)l;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, rexInputRef, rexLiteral);
                    }
                }
            }
            if (tuple2 != null) {
                RexNode l = (RexNode)tuple2._1();
                RexNode i = (RexNode)tuple2._2();
                if (l instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)i;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, rexInputRef, rexLiteral);
                    }
                }
            }
            return this.se().defaultComparisonSelectivity();
        }
        SqlBinaryOperator sqlBinaryOperator5 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlOperator sqlOperator7 = sqlOperator;
        if (!(sqlBinaryOperator5 != null ? !((Object)sqlBinaryOperator5).equals(sqlOperator7) : sqlOperator7 != null)) {
            Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
            if (tuple2 != null) {
                RexNode i = (RexNode)tuple2._1();
                RexNode l = (RexNode)tuple2._2();
                if (i instanceof RexInputRef) {
                    RexInputRef rexInputRef = (RexInputRef)i;
                    if (l instanceof RexLiteral) {
                        RexLiteral rexLiteral = (RexLiteral)l;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, rexInputRef, rexLiteral);
                    }
                }
            }
            if (tuple2 != null) {
                RexNode l = (RexNode)tuple2._1();
                RexNode i = (RexNode)tuple2._2();
                if (l instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)i;
                        return this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, rexInputRef, rexLiteral);
                    }
                }
            }
            return this.se().defaultComparisonSelectivity();
        }
        return this.se().defaultComparisonSelectivity();
    }

    private Option<Object> estimateEquals(RexInputRef inputRef, RexLiteral literal) {
        ValueInterval convertedInterval;
        if (literal.isNull()) {
            return this.se().defaultIsNullSelectivity();
        }
        Option<AggregateCall> aggCall = this.getSupportedAggCall(inputRef.getIndex());
        if (!SelectivityEstimator$.MODULE$.canConvertToNumericType(inputRef.getType()) || aggCall.isEmpty()) {
            return this.se().defaultEqualsSelectivity();
        }
        ValueInterval aggCallInterval = this.getAggCallInterval((AggregateCall)aggCall.get());
        if (aggCallInterval == null) {
            return this.se().defaultEqualsSelectivity();
        }
        ValueInterval valueInterval = convertedInterval = SelectivityEstimator$.MODULE$.convertValueInterval(aggCallInterval, inputRef.getType());
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.infinite();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            return this.se().defaultEqualsSelectivity();
        }
        ValueInterval valueInterval4 = ValueInterval$.MODULE$.empty();
        ValueInterval valueInterval5 = valueInterval;
        if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
            return this.defaultAggCallSelectivity();
        }
        if (valueInterval instanceof FiniteValueInterval) {
            FiniteValueInterval finiteValueInterval = (FiniteValueInterval)valueInterval;
            Double min2 = SelectivityEstimator$.MODULE$.comparableToDouble(finiteValueInterval.lower());
            Double max = SelectivityEstimator$.MODULE$.comparableToDouble(finiteValueInterval.upper());
            if (ValueInterval$.MODULE$.contains(finiteValueInterval, SelectivityEstimator$.MODULE$.literalToComparable(literal))) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get()), 1.0 / (Predef$.MODULE$.Double2double(max) - Predef$.MODULE$.Double2double(min2)))));
            }
            return this.defaultAggCallSelectivity();
        }
        return this.se().defaultEqualsSelectivity();
    }

    private Option<Object> estimateComparison(SqlOperator op, RexInputRef inputRef, RexLiteral literal) {
        if (literal.isNull()) {
            throw new IllegalArgumentException("Numeric comparison does not support null literal here.");
        }
        Option<AggregateCall> aggCall = this.getSupportedAggCall(inputRef.getIndex());
        if (SelectivityEstimator$.MODULE$.canConvertToNumericType(inputRef.getType()) && aggCall.isDefined()) {
            return this.estimateNumericComparison(op, (AggregateCall)aggCall.get(), literal);
        }
        return this.se().defaultComparisonSelectivity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Object> estimateNumericComparison(SqlOperator op, AggregateCall aggCall, RexLiteral literal) {
        double d;
        Tuple2.mcZZ.sp sp2;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        Tuple2 tuple24;
        ValueInterval aggCallInterval = this.getAggCallInterval(aggCall);
        if (aggCallInterval == null) {
            return this.se().defaultComparisonSelectivity();
        }
        ValueInterval valueInterval = aggCallInterval;
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.infinite();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            return this.se().defaultComparisonSelectivity();
        }
        ValueInterval valueInterval4 = ValueInterval$.MODULE$.empty();
        ValueInterval valueInterval5 = valueInterval;
        if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
            return this.defaultAggCallSelectivity();
        }
        ValueInterval valueInterval6 = aggCallInterval;
        if (valueInterval6 instanceof WithLower) {
            WithLower withLower = (WithLower)valueInterval6;
            tuple24 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withLower.lower()), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
        } else {
            tuple24 = tuple23 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Double min2 = (Double)tuple23._1();
        boolean includeMin = tuple23._2$mcZ$sp();
        Tuple2 tuple25 = new Tuple2((Object)min2, (Object)BoxesRunTime.boxToBoolean((boolean)includeMin));
        Double min3 = (Double)tuple25._1();
        boolean includeMin2 = tuple25._2$mcZ$sp();
        ValueInterval valueInterval7 = aggCallInterval;
        if (valueInterval7 instanceof WithUpper) {
            WithUpper withUpper = (WithUpper)valueInterval7;
            tuple22 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withUpper.upper()), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
        } else {
            tuple22 = tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double max = (Double)tuple2._1();
        boolean includeMax = tuple2._2$mcZ$sp();
        Tuple2 tuple26 = new Tuple2((Object)max, (Object)BoxesRunTime.boxToBoolean((boolean)includeMax));
        Double max2 = (Double)tuple26._1();
        boolean includeMax2 = tuple26._2$mcZ$sp();
        Double lit = SelectivityEstimator$.MODULE$.literalToDouble(literal);
        SqlOperator sqlOperator = op;
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.LESS_THAN;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            boolean noOverlap = SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min3, lit);
            boolean completeOverlap = includeMax2 ? SelectivityEstimator$.MODULE$.lessThan(max2, lit) : SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
            sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
        } else {
            SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                boolean noOverlap = includeMin2 ? SelectivityEstimator$.MODULE$.greaterThan(min3, lit) : SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min3, lit);
                boolean completeOverlap = SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
            } else {
                SqlBinaryOperator sqlBinaryOperator3 = SqlStdOperatorTable.GREATER_THAN;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlBinaryOperator3 != null ? !((Object)sqlBinaryOperator3).equals(sqlOperator4) : sqlOperator4 != null)) {
                    boolean noOverlap = SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                    boolean completeOverlap = includeMin2 ? SelectivityEstimator$.MODULE$.greaterThan(min3, lit) : SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min3, lit);
                    sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                } else {
                    SqlBinaryOperator sqlBinaryOperator4 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                    SqlOperator sqlOperator5 = sqlOperator;
                    if (sqlBinaryOperator4 != null ? !((Object)sqlBinaryOperator4).equals(sqlOperator5) : sqlOperator5 != null) throw new MatchError((Object)sqlOperator);
                    boolean noOverlap = includeMax2 ? SelectivityEstimator$.MODULE$.lessThan(max2, lit) : SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                    boolean completeOverlap = SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min3, lit);
                    sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                }
            }
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean noOverlap = sp3._1$mcZ$sp();
        boolean completeOverlap = sp3._2$mcZ$sp();
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
        boolean noOverlap2 = sp4._1$mcZ$sp();
        boolean completeOverlap2 = sp4._2$mcZ$sp();
        if (noOverlap2) {
            d = BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get());
        } else if (completeOverlap2) {
            d = 1.0 - BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get());
        } else if (min3 != null && max2 != null) {
            boolean bl;
            SqlOperator sqlOperator6 = op;
            SqlBinaryOperator sqlBinaryOperator5 = SqlStdOperatorTable.LESS_THAN;
            SqlOperator sqlOperator7 = sqlOperator6;
            if (!(sqlBinaryOperator5 != null ? !((Object)sqlBinaryOperator5).equals(sqlOperator7) : sqlOperator7 != null)) {
                bl = true;
            } else {
                SqlBinaryOperator sqlBinaryOperator6 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                SqlOperator sqlOperator8 = sqlOperator6;
                bl = !(sqlBinaryOperator6 != null ? !((Object)sqlBinaryOperator6).equals(sqlOperator8) : sqlOperator8 != null);
            }
            if (bl) {
                d = (Predef$.MODULE$.Double2double(lit) - Predef$.MODULE$.Double2double(min3)) / (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(min3));
            } else {
                boolean bl2;
                SqlBinaryOperator sqlBinaryOperator7 = SqlStdOperatorTable.GREATER_THAN;
                SqlOperator sqlOperator9 = sqlOperator6;
                if (!(sqlBinaryOperator7 != null ? !((Object)sqlBinaryOperator7).equals(sqlOperator9) : sqlOperator9 != null)) {
                    bl2 = true;
                } else {
                    SqlBinaryOperator sqlBinaryOperator8 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                    SqlOperator sqlOperator10 = sqlOperator6;
                    bl2 = !(sqlBinaryOperator8 != null ? !((Object)sqlBinaryOperator8).equals(sqlOperator10) : sqlOperator10 != null);
                }
                if (!bl2) throw new MatchError((Object)sqlOperator6);
                d = (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(lit)) / (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(min3));
            }
        } else {
            d = BoxesRunTime.unboxToDouble((Object)this.se().defaultComparisonSelectivity().get());
        }
        double selectivity = d;
        return new Some((Object)BoxesRunTime.boxToDouble((double)selectivity));
    }

    private final Option getRowCntPerGroup$1(RelNode aggInput$1) {
        Double inputRowCnt = this.mq.getRowCount(aggInput$1);
        if (inputRowCnt == null) {
            return None$.MODULE$;
        }
        Double aggRowCnt = this.mq.getRowCount(this.agg);
        if (aggRowCnt == null) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(inputRowCnt) / Predef$.MODULE$.Double2double(aggRowCnt))));
    }

    private final Double getAggCallValue$1(Double v, AggregateCall aggCall$1, RelNode aggInput$1) {
        if (v == null) {
            return null;
        }
        SqlKind sqlKind = aggCall$1.getAggregation().getKind();
        if (((Object)((Object)SqlKind.MAX)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MIN)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AVG)).equals((Object)sqlKind))) {
            return v;
        }
        if (((Object)((Object)SqlKind.SUM)).equals((Object)sqlKind)) {
            Option option = this.getRowCntPerGroup$1(aggInput$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                double rowCntPerGroup = BoxesRunTime.unboxToDouble((Object)some.value());
                return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(v) * rowCntPerGroup);
            }
            return null;
        }
        throw new MatchError((Object)sqlKind);
    }

    public AggCallSelectivityEstimator(RelNode agg, FlinkRelMetadataQuery mq) {
        this.agg = agg;
        this.mq = mq;
        super(true);
        this.rexBuilder = agg.getCluster().getRexBuilder();
        this.se = new SelectivityEstimator(agg, mq);
        this.defaultAggCallSelectivity = new Some((Object)BoxesRunTime.boxToDouble((double)0.01));
    }
}

