/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractCharacterFamilyTargetRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.utils.DateTimeUtils;

class TimestampToStringCastRule
extends AbstractCharacterFamilyTargetRule<TimestampData> {
    static final TimestampToStringCastRule INSTANCE = new TimestampToStringCastRule();

    private TimestampToStringCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.TIMESTAMP).target((LogicalType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public String generateStringExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        String zoneId = inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? context.getSessionTimeZoneTerm() : CastRuleUtils.accessStaticField(DateTimeUtils.class, "UTC_ZONE");
        int precision = LogicalTypeChecks.getPrecision((LogicalType)inputLogicalType);
        return CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_TO_STRING_TIME_ZONE(), inputTerm, zoneId, precision);
    }
}

