/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import java.util.Objects;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.util.Time;

public abstract class AbstractAuditSpanImpl
implements AuditSpanS3A {
    private final String spanId;
    private final long timestamp;
    private final String operationName;

    protected AbstractAuditSpanImpl(String spanId, String operationName) {
        this(spanId, Time.now(), operationName);
    }

    protected AbstractAuditSpanImpl(String spanId, long timestamp, String operationName) {
        this.spanId = Objects.requireNonNull(spanId);
        this.timestamp = timestamp;
        this.operationName = operationName;
    }

    @Override
    public final String getSpanId() {
        return this.spanId;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public AuditSpanS3A activate() {
        return this;
    }

    @Override
    public final void close() {
        this.deactivate();
    }
}

