/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.OverWindowRange;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class OverTypeStrategy
implements InputTypeStrategy {
    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.from(4);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType timeAttribute = argumentDataTypes.get(1);
        if (!LogicalTypeChecks.isTimeAttribute(timeAttribute.getLogicalType())) {
            return callContext.fail(throwOnFailure, "Second argument in OVER window must be a TIME ATTRIBUTE, but is: " + timeAttribute, new Object[0]);
        }
        if (!callContext.isArgumentLiteral(2)) {
            return callContext.fail(throwOnFailure, "Preceding must be a row interval or time interval literal.", new Object[0]);
        }
        if (!callContext.isArgumentLiteral(3)) {
            return callContext.fail(throwOnFailure, "Following must be a row interval or time interval literal.", new Object[0]);
        }
        DataType preceding = argumentDataTypes.get(2);
        DataType following = argumentDataTypes.get(3);
        LogicalTypeRoot precedingTypeRoot = preceding.getLogicalType().getTypeRoot();
        Optional<String> precedingErr = this.validateFollowingPreceding(precedingTypeRoot, FollowingPreceding.PRECEDING, callContext);
        if (precedingErr.isPresent()) {
            return callContext.fail(throwOnFailure, precedingErr.get(), new Object[0]);
        }
        LogicalTypeRoot followingTypeRoot = following.getLogicalType().getTypeRoot();
        Optional<String> followingErr = this.validateFollowingPreceding(followingTypeRoot, FollowingPreceding.FOLLOWING, callContext);
        if (followingErr.isPresent()) {
            return callContext.fail(throwOnFailure, followingErr.get(), new Object[0]);
        }
        boolean isPrecedingRowWindow = OverTypeStrategy.isRowWindow(callContext, precedingTypeRoot, FollowingPreceding.PRECEDING);
        boolean isFollowingRowWindow = OverTypeStrategy.isRowWindow(callContext, followingTypeRoot, FollowingPreceding.FOLLOWING);
        if (isPrecedingRowWindow && !isFollowingRowWindow || !isPrecedingRowWindow && isFollowingRowWindow) {
            return callContext.fail(throwOnFailure, "Preceding and following must be of same interval type.", new Object[0]);
        }
        return Optional.of(argumentDataTypes);
    }

    private static boolean isRowWindow(CallContext callContext, LogicalTypeRoot typeRoot, FollowingPreceding followingPreceding) {
        switch (typeRoot) {
            case BIGINT: {
                return true;
            }
            case SYMBOL: {
                OverWindowRange windowRange = callContext.getArgumentValue(followingPreceding.pos, OverWindowRange.class).get();
                return windowRange == OverWindowRange.UNBOUNDED_ROW || windowRange == OverWindowRange.CURRENT_ROW;
            }
        }
        return false;
    }

    private Optional<String> validateFollowingPreceding(LogicalTypeRoot typeRoot, FollowingPreceding followingPreceding, CallContext callContext) {
        switch (typeRoot) {
            case BIGINT: {
                if (callContext.getArgumentValue(followingPreceding.pos, Long.class).get() > 0L) break;
                return Optional.of(String.format("%s row interval must be larger than 0.", followingPreceding.name));
            }
            case INTERVAL_DAY_TIME: {
                if (callContext.getArgumentValue(followingPreceding.pos, BigDecimal.class).get().compareTo(BigDecimal.ZERO) >= 0) break;
                return Optional.of(String.format("%s time interval must be equal or larger than 0.", followingPreceding.name));
            }
            case SYMBOL: {
                Optional<OverWindowRange> precedingSymbol = callContext.getArgumentValue(followingPreceding.pos, OverWindowRange.class);
                if (precedingSymbol.isPresent()) break;
                return Optional.of(String.format("%s must be a row interval or time interval literal.", followingPreceding.name));
            }
            default: {
                return Optional.of(String.format("%s must be a row interval or time interval literal.", followingPreceding.name));
            }
        }
        return Optional.empty();
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Arrays.asList(Signature.of(Signature.Argument.ofGroup("ANY"), Signature.Argument.ofGroup("TIME ATTRIBUTE"), Signature.Argument.ofGroup("INTERVAL LITERAL | CURRENT_RANGE | UNBOUNDED_RANGE"), Signature.Argument.ofGroup("INTERVAL LITERAL | CURRENT_RANGE | UNBOUNDED_RANGE"), Signature.Argument.ofGroupVarying("ANY")), Signature.of(Signature.Argument.ofGroup("ANY"), Signature.Argument.ofGroup("TIME ATTRIBUTE"), Signature.Argument.ofGroup("BIGINT | CURRENT_ROW | UNBOUNDED_ROW"), Signature.Argument.ofGroup("BIGINT | CURRENT_ROW | UNBOUNDED_ROW"), Signature.Argument.ofGroupVarying("ANY")));
    }

    private static enum FollowingPreceding {
        PRECEDING("Preceding", 2),
        FOLLOWING("Following", 3);

        private final int pos;
        private final String name;

        private FollowingPreceding(String name, int pos) {
            this.name = name;
            this.pos = pos;
        }
    }
}

