/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.k8s.overlord.KubernetesPeonLifecycleFactory;
import org.apache.druid.k8s.overlord.KubernetesTaskRunner;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.common.DruidKubernetesClient;
import org.apache.druid.k8s.overlord.common.KubernetesPeonClient;
import org.apache.druid.k8s.overlord.taskadapter.TaskAdapter;
import org.apache.druid.tasklogs.TaskLogs;

public class KubernetesTaskRunnerFactory
implements TaskRunnerFactory<KubernetesTaskRunner> {
    public static final String TYPE_NAME = "k8s";
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final KubernetesTaskRunnerConfig kubernetesTaskRunnerConfig;
    private final TaskLogs taskLogs;
    private final DruidKubernetesClient druidKubernetesClient;
    private final ServiceEmitter emitter;
    private KubernetesTaskRunner runner;
    private final TaskAdapter taskAdapter;
    private final Set<String> adapterTypeAllowingTasksInDifferentNamespaces = Set.of("customTemplateAdapter");

    @Inject
    public KubernetesTaskRunnerFactory(@Smile ObjectMapper smileMapper, @EscalatedGlobal HttpClient httpClient, KubernetesTaskRunnerConfig kubernetesTaskRunnerConfig, TaskLogs taskLogs, DruidKubernetesClient druidKubernetesClient, ServiceEmitter emitter, TaskAdapter taskAdapter) {
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        this.kubernetesTaskRunnerConfig = kubernetesTaskRunnerConfig;
        this.taskLogs = taskLogs;
        this.druidKubernetesClient = druidKubernetesClient;
        this.emitter = emitter;
        this.taskAdapter = taskAdapter;
    }

    public KubernetesTaskRunner build() {
        KubernetesPeonClient peonClient = this.adapterTypeAllowingTasksInDifferentNamespaces.contains(this.taskAdapter.getAdapterType()) ? new KubernetesPeonClient(this.druidKubernetesClient, this.kubernetesTaskRunnerConfig.getNamespace(), this.kubernetesTaskRunnerConfig.getOverlordNamespace(), this.kubernetesTaskRunnerConfig.isDebugJobs(), this.emitter) : new KubernetesPeonClient(this.druidKubernetesClient, this.kubernetesTaskRunnerConfig.getNamespace(), this.kubernetesTaskRunnerConfig.isDebugJobs(), this.emitter);
        this.runner = new KubernetesTaskRunner(this.taskAdapter, this.kubernetesTaskRunnerConfig, peonClient, this.httpClient, new KubernetesPeonLifecycleFactory(peonClient, this.taskLogs, this.smileMapper, this.kubernetesTaskRunnerConfig.getLogSaveTimeout().toStandardDuration().getMillis()), this.emitter);
        return this.runner;
    }

    public KubernetesTaskRunner get() {
        return this.runner;
    }
}

