/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.util.Locale;
import java.util.Properties;
import org.apache.druid.guice.JacksonConfigProvider;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.overlord.RemoteTaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunnerFactory;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.overlord.KubernetesAndWorkerTaskRunnerConfig;
import org.apache.druid.k8s.overlord.KubernetesAndWorkerTaskRunnerFactory;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerConfig;
import org.apache.druid.k8s.overlord.KubernetesTaskRunnerFactory;
import org.apache.druid.k8s.overlord.common.DruidKubernetesClient;
import org.apache.druid.k8s.overlord.common.httpclient.DruidKubernetesHttpClientFactory;
import org.apache.druid.k8s.overlord.common.httpclient.jdk.DruidKubernetesJdkHttpClientConfig;
import org.apache.druid.k8s.overlord.common.httpclient.jdk.DruidKubernetesJdkHttpClientFactory;
import org.apache.druid.k8s.overlord.common.httpclient.okhttp.DruidKubernetesOkHttpHttpClientConfig;
import org.apache.druid.k8s.overlord.common.httpclient.okhttp.DruidKubernetesOkHttpHttpClientFactory;
import org.apache.druid.k8s.overlord.common.httpclient.vertx.DruidKubernetesVertxHttpClientConfig;
import org.apache.druid.k8s.overlord.common.httpclient.vertx.DruidKubernetesVertxHttpClientFactory;
import org.apache.druid.k8s.overlord.execution.KubernetesTaskExecutionConfigResource;
import org.apache.druid.k8s.overlord.execution.KubernetesTaskRunnerDynamicConfig;
import org.apache.druid.k8s.overlord.runnerstrategy.RunnerStrategy;
import org.apache.druid.k8s.overlord.taskadapter.DynamicConfigPodTemplateSelector;
import org.apache.druid.k8s.overlord.taskadapter.MultiContainerTaskAdapter;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateTaskAdapter;
import org.apache.druid.k8s.overlord.taskadapter.SingleContainerTaskAdapter;
import org.apache.druid.k8s.overlord.taskadapter.TaskAdapter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.TaskLogs;

@LoadScope(roles={"overlord"})
public class KubernetesOverlordModule
implements DruidModule {
    private static final Logger log = new Logger(KubernetesOverlordModule.class);
    private static final String K8SANDWORKER_PROPERTIES_PREFIX = "druid.indexer.runner.k8sAndWorker";
    private static final String RUNNERSTRATEGY_PROPERTIES_FORMAT_STRING = "druid.indexer.runner.k8sAndWorker.runnerStrategy.%s";
    private static final String K8SANDWORKER_HTTPCLIENT_PROPERTIES_PREFIX = "druid.indexer.runner.k8sAndWorker.http";
    private static final String HTTPCLIENT_TYPE_PROPERTY = "druid.indexer.runner.k8sAndWorker.http.httpClientType";
    private static final String VERTX_HTTPCLIENT_PROPERITES_PREFIX = "druid.indexer.runner.k8sAndWorker.http.vertx";
    private static final String OKHTTP_HTTPCLIENT_PROPERITES_PREFIX = "druid.indexer.runner.k8sAndWorker.http.okhttp";
    public static final String JDK_HTTPCLIENT_PROPERITES_PREFIX = "druid.indexer.runner.k8sAndWorker.http.javaStandardHttp";

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.runner", KubernetesTaskRunnerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)K8SANDWORKER_PROPERTIES_PREFIX, KubernetesAndWorkerTaskRunnerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.queue", TaskQueueConfig.class);
        JacksonConfigProvider.bind((Binder)binder, (String)"k8s.taskrunner.config", KubernetesTaskRunnerDynamicConfig.class, null);
        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.runner.type", (Key)Key.get(TaskRunnerFactory.class), (Key)Key.get(KubernetesTaskRunnerFactory.class));
        MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskRunnerFactory.class));
        biddy.addBinding((Object)"k8s").to(KubernetesTaskRunnerFactory.class).in(LazySingleton.class);
        biddy.addBinding((Object)"k8sAndWorker").to(KubernetesAndWorkerTaskRunnerFactory.class).in(LazySingleton.class);
        binder.bind(KubernetesTaskRunnerFactory.class).in(LazySingleton.class);
        binder.bind(KubernetesAndWorkerTaskRunnerFactory.class).in(LazySingleton.class);
        binder.bind(RunnerStrategy.class).toProvider(RunnerStrategyProvider.class).in(LazySingleton.class);
        Jerseys.addResource((Binder)binder, KubernetesTaskExecutionConfigResource.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)HTTPCLIENT_TYPE_PROPERTY, (Key)Key.get(DruidKubernetesHttpClientFactory.class), (String)"vertx");
        MapBinder factoryBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidKubernetesHttpClientFactory.class));
        factoryBinder.addBinding((Object)"vertx").toProvider(VertxHttpClientFactoryProvider.class).in(LazySingleton.class);
        factoryBinder.addBinding((Object)"okhttp").toProvider(OkHttpHttpClientFactoryProvider.class).in(LazySingleton.class);
        factoryBinder.addBinding((Object)"javaStandardHttp").toProvider(JdkHttpClientFactoryProvider.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)VERTX_HTTPCLIENT_PROPERITES_PREFIX, DruidKubernetesVertxHttpClientConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)OKHTTP_HTTPCLIENT_PROPERITES_PREFIX, DruidKubernetesOkHttpHttpClientConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)JDK_HTTPCLIENT_PROPERITES_PREFIX, DruidKubernetesJdkHttpClientConfig.class);
    }

    @Provides
    @LazySingleton
    public DruidKubernetesClient makeKubernetesClient(KubernetesTaskRunnerConfig kubernetesTaskRunnerConfig, DruidKubernetesHttpClientFactory httpClientFactory, Lifecycle lifecycle) {
        Config config = new ConfigBuilder().build();
        if (kubernetesTaskRunnerConfig.isDisableClientProxy()) {
            config.setHttpsProxy(null);
            config.setHttpProxy(null);
        }
        final DruidKubernetesClient client = new DruidKubernetesClient(httpClientFactory, config);
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
            }

            public void stop() {
                log.info("Stopping overlord Kubernetes client", new Object[0]);
                client.getClient().close();
            }
        });
        return client;
    }

    @Provides
    @LazySingleton
    @Named(value="taskRunnerFactory")
    TaskRunnerFactory<? extends WorkerTaskRunner> provideWorkerTaskRunner(KubernetesAndWorkerTaskRunnerConfig runnerConfig, Injector injector) {
        String workerType = runnerConfig.getWorkerType();
        return "httpRemote".equals(workerType) ? (TaskRunnerFactory)injector.getInstance(HttpRemoteTaskRunnerFactory.class) : (TaskRunnerFactory)injector.getInstance(RemoteTaskRunnerFactory.class);
    }

    @Provides
    @LazySingleton
    TaskAdapter provideTaskAdapter(DruidKubernetesClient client, Properties properties, KubernetesTaskRunnerConfig kubernetesTaskRunnerConfig, TaskConfig taskConfig, StartupLoggingConfig startupLoggingConfig, @Self DruidNode druidNode, @Smile ObjectMapper smileMapper, TaskLogs taskLogs, Supplier<KubernetesTaskRunnerDynamicConfig> dynamicConfigRef) {
        String adapter = properties.getProperty(String.format(Locale.ROOT, "%s.%s.adapter.type", "druid.indexer.runner", "k8s"));
        if (adapter != null && !"overlordMultiContainer".equals(adapter) && kubernetesTaskRunnerConfig.isSidecarSupport()) {
            throw new IAE("Invalid pod adapter [%s], only pod adapter [%s] can be specified when sidecarSupport is enabled", new Object[]{adapter, "overlordMultiContainer"});
        }
        if ("overlordMultiContainer".equals(adapter) || kubernetesTaskRunnerConfig.isSidecarSupport()) {
            return new MultiContainerTaskAdapter(client, kubernetesTaskRunnerConfig, taskConfig, startupLoggingConfig, druidNode, smileMapper, taskLogs);
        }
        if ("customTemplateAdapter".equals(adapter)) {
            return new PodTemplateTaskAdapter(kubernetesTaskRunnerConfig, taskConfig, druidNode, smileMapper, taskLogs, new DynamicConfigPodTemplateSelector(properties, dynamicConfigRef));
        }
        return new SingleContainerTaskAdapter(client, kubernetesTaskRunnerConfig, taskConfig, startupLoggingConfig, druidNode, smileMapper, taskLogs);
    }

    private static class RunnerStrategyProvider
    implements Provider<RunnerStrategy> {
        private KubernetesAndWorkerTaskRunnerConfig runnerConfig;
        private Properties props;
        private JsonConfigurator configurator;

        private RunnerStrategyProvider() {
        }

        @Inject
        public void inject(KubernetesAndWorkerTaskRunnerConfig runnerConfig, Properties props, JsonConfigurator configurator) {
            this.runnerConfig = runnerConfig;
            this.props = props;
            this.configurator = configurator;
        }

        public RunnerStrategy get() {
            String runnerStrategy = this.runnerConfig.getRunnerStrategy();
            String runnerStrategyPropertyBase = StringUtils.format((String)KubernetesOverlordModule.RUNNERSTRATEGY_PROPERTIES_FORMAT_STRING, (Object[])new Object[]{runnerStrategy});
            JsonConfigProvider provider = JsonConfigProvider.of((String)runnerStrategyPropertyBase, RunnerStrategy.class);
            this.props.put(runnerStrategyPropertyBase + ".type", runnerStrategy);
            provider.inject(this.props, this.configurator);
            return (RunnerStrategy)provider.get();
        }
    }

    private static class VertxHttpClientFactoryProvider
    implements Provider<DruidKubernetesHttpClientFactory> {
        private DruidKubernetesVertxHttpClientConfig config;

        private VertxHttpClientFactoryProvider() {
        }

        @Inject
        public void inject(DruidKubernetesVertxHttpClientConfig config) {
            this.config = config;
        }

        public DruidKubernetesHttpClientFactory get() {
            return new DruidKubernetesVertxHttpClientFactory(this.config);
        }
    }

    private static class OkHttpHttpClientFactoryProvider
    implements Provider<DruidKubernetesHttpClientFactory> {
        private DruidKubernetesOkHttpHttpClientConfig config;

        private OkHttpHttpClientFactoryProvider() {
        }

        @Inject
        public void inject(DruidKubernetesOkHttpHttpClientConfig config) {
            this.config = config;
        }

        public DruidKubernetesHttpClientFactory get() {
            return new DruidKubernetesOkHttpHttpClientFactory(this.config);
        }
    }

    private static class JdkHttpClientFactoryProvider
    implements Provider<DruidKubernetesHttpClientFactory> {
        private DruidKubernetesJdkHttpClientConfig config;

        private JdkHttpClientFactoryProvider() {
        }

        @Inject
        public void inject(DruidKubernetesJdkHttpClientConfig config) {
            this.config = config;
        }

        public DruidKubernetesHttpClientFactory get() {
            return new DruidKubernetesJdkHttpClientFactory(this.config);
        }
    }
}

