/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.netty.Connection;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.http.client.Http2AllocationStrategy;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquireTimeoutException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.netty.resources.ConnectionProvider;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class Http2Pool
implements InstrumentedPool<Connection>,
InstrumentedPool.PoolMetrics {
    static final Logger log = Loggers.getLogger(Http2Pool.class);
    volatile int acquired;
    static final AtomicIntegerFieldUpdater<Http2Pool> ACQUIRED = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "acquired");
    volatile ConcurrentLinkedQueue<Slot> connections;
    static final AtomicReferenceFieldUpdater<Http2Pool, ConcurrentLinkedQueue> CONNECTIONS = AtomicReferenceFieldUpdater.newUpdater(Http2Pool.class, ConcurrentLinkedQueue.class, "connections");
    volatile int idleSize;
    private static final AtomicIntegerFieldUpdater<Http2Pool> IDLE_SIZE = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "idleSize");
    volatile ConcurrentLinkedDeque<Borrower> pending;
    static final AtomicReferenceFieldUpdater<Http2Pool, ConcurrentLinkedDeque> PENDING = AtomicReferenceFieldUpdater.newUpdater(Http2Pool.class, ConcurrentLinkedDeque.class, "pending");
    volatile int pendingSize;
    private static final AtomicIntegerFieldUpdater<Http2Pool> PENDING_SIZE = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "pendingSize");
    static final ConcurrentLinkedDeque TERMINATED = new ConcurrentLinkedDeque();
    volatile long totalMaxConcurrentStreams;
    static final AtomicLongFieldUpdater<Http2Pool> TOTAL_MAX_CONCURRENT_STREAMS = AtomicLongFieldUpdater.newUpdater(Http2Pool.class, "totalMaxConcurrentStreams");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<Http2Pool> WIP = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "wip");
    final Clock clock;
    final Long maxConcurrentStreams;
    final int minConnections;
    final PoolConfig<Connection> poolConfig;
    long lastInteractionTimestamp;
    Disposable evictionTask;
    static final Function<Connection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = connection -> {
        if (!connection.channel().isActive()) {
            return Mono.empty();
        }
        return FutureMono.from((Future)connection.channel().close());
    };

    Http2Pool(PoolConfig<Connection> poolConfig, @Nullable ConnectionProvider.AllocationStrategy<?> allocationStrategy) {
        this.clock = poolConfig.clock();
        this.connections = new ConcurrentLinkedQueue();
        this.lastInteractionTimestamp = this.clock.millis();
        this.maxConcurrentStreams = allocationStrategy instanceof Http2AllocationStrategy ? ((Http2AllocationStrategy)allocationStrategy).maxConcurrentStreams() : -1L;
        this.minConnections = allocationStrategy == null ? 0 : allocationStrategy.permitMinimum();
        this.pending = new ConcurrentLinkedDeque();
        this.poolConfig = poolConfig;
        this.recordInteractionTimestamp();
        this.scheduleEviction();
    }

    public Mono<PooledRef<Connection>> acquire() {
        return new BorrowerMono(this, Duration.ZERO);
    }

    public Mono<PooledRef<Connection>> acquire(Duration timeout) {
        return new BorrowerMono(this, timeout);
    }

    public int acquiredSize() {
        return this.allocatedSize() - this.idleSize();
    }

    public int allocatedSize() {
        return this.poolConfig.allocationStrategy().permitGranted();
    }

    public PoolConfig<Connection> config() {
        return this.poolConfig;
    }

    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            this.recordInteractionTimestamp();
            ConcurrentLinkedDeque q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                Borrower p;
                this.evictionTask.dispose();
                while ((p = this.pollPending(q, true)) != null) {
                    p.fail((Throwable)new PoolShutdownException());
                }
                ConcurrentLinkedQueue slots = CONNECTIONS.getAndSet(this, null);
                if (slots != null) {
                    Mono closeMonos = Mono.empty();
                    while (!slots.isEmpty()) {
                        Slot slot = this.pollSlot(slots);
                        if (slot == null) continue;
                        slot.invalidate();
                        closeMonos = closeMonos.and(DEFAULT_DESTROY_HANDLER.apply(slot.connection));
                    }
                    return closeMonos;
                }
            }
            return Mono.empty();
        });
    }

    public int getMaxAllocatedSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxPendingAcquireSize() {
        return this.poolConfig.maxPending() < 0 ? Integer.MAX_VALUE : this.poolConfig.maxPending();
    }

    public int idleSize() {
        return this.idleSize;
    }

    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED || CONNECTIONS.get(this) == null;
    }

    public boolean isInactiveForMoreThan(Duration duration) {
        return this.pendingAcquireSize() == 0 && this.allocatedSize() == 0 && this.secondsSinceLastInteraction() >= duration.getSeconds();
    }

    public InstrumentedPool.PoolMetrics metrics() {
        return this;
    }

    public int pendingAcquireSize() {
        return this.pendingSize;
    }

    public long secondsSinceLastInteraction() {
        long sinceMs = this.clock.millis() - this.lastInteractionTimestamp;
        return sinceMs / 1000L;
    }

    public Mono<Integer> warmup() {
        return Mono.just((Object)0);
    }

    int activeStreams() {
        return this.acquired;
    }

    void cancelAcquire(Borrower borrower) {
        if (!this.isDisposed()) {
            ConcurrentLinkedDeque<Borrower> q = this.pending;
            this.removePending(q, borrower);
        }
    }

    Mono<Void> destroyPoolable(Http2PooledRef ref) {
        assert (ref.slot.connection.channel().eventLoop().inEventLoop());
        Mono mono = Mono.empty();
        try {
            if (ref.slot.decrementConcurrencyAndGet() == 0) {
                if (ref.slot.http2FrameCodecCtx() == null) {
                    ref.slot.invalidate();
                    this.removeSlot(ref.slot);
                } else if (this.poolConfig.evictInBackgroundInterval().isZero()) {
                    if (!ref.poolable().channel().isActive()) {
                        ref.slot.invalidate();
                        this.removeSlot(ref.slot);
                    }
                    if (ref.slot.goAwayReceived()) {
                        ref.slot.invalidate();
                        this.removeSlot(ref.slot);
                    } else if (this.testEvictionPredicate(ref.slot)) {
                        ref.slot.connection.channel().close();
                        ref.slot.invalidate();
                        this.removeSlot(ref.slot);
                    }
                }
            }
        }
        catch (Throwable destroyFunctionError) {
            mono = Mono.error((Throwable)destroyFunctionError);
        }
        return mono;
    }

    void doAcquire(Borrower borrower) {
        if (this.isDisposed()) {
            borrower.fail((Throwable)new PoolShutdownException());
            return;
        }
        this.pendingOffer(borrower);
        this.drain();
    }

    void drain() {
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        this.recordInteractionTimestamp();
        int maxPending = this.poolConfig.maxPending();
        while (true) {
            ConcurrentLinkedQueue resources = CONNECTIONS.get(this);
            ConcurrentLinkedDeque borrowers = PENDING.get(this);
            if (resources == null || borrowers == TERMINATED) {
                return;
            }
            int borrowersCount = this.pendingSize;
            if (borrowersCount != 0) {
                Slot slot;
                boolean belowMinConnections = this.minConnections > 0 && this.poolConfig.allocationStrategy().permitGranted() < this.minConnections;
                Slot slot2 = slot = belowMinConnections ? null : this.findConnection(resources);
                if (slot != null) {
                    Borrower borrower = this.pollPending(borrowers, true);
                    if (borrower == null) {
                        this.offerSlot(resources, slot);
                        continue;
                    }
                    if (this.isDisposed()) {
                        borrower.fail((Throwable)new PoolShutdownException());
                        return;
                    }
                    borrower.stopPendingCountdown();
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel activated"));
                    }
                    ACQUIRED.incrementAndGet(this);
                    slot.connection.channel().eventLoop().execute(() -> {
                        borrower.deliver(new Http2PooledRef(slot));
                        this.drain();
                    });
                } else {
                    int resourcesCount = this.idleSize;
                    if (this.minConnections <= 0 || this.poolConfig.allocationStrategy().permitGranted() < this.minConnections || resourcesCount != 0) {
                        int permits = this.poolConfig.allocationStrategy().getPermits(1);
                        if (permits <= 0) {
                            if (maxPending >= 0) {
                                borrowersCount = this.pendingSize;
                                int toCull = borrowersCount - maxPending;
                                for (int i = 0; i < toCull; ++i) {
                                    Borrower extraneous = this.pollPending(borrowers, true);
                                    if (extraneous == null) continue;
                                    this.pendingAcquireLimitReached(extraneous, maxPending);
                                }
                            }
                        } else {
                            Borrower borrower;
                            if (permits > 1) {
                                this.poolConfig.allocationStrategy().returnPermits(permits - 1);
                            }
                            if ((borrower = this.pollPending(borrowers, true)) == null) continue;
                            if (this.isDisposed()) {
                                borrower.fail((Throwable)new PoolShutdownException());
                                return;
                            }
                            borrower.stopPendingCountdown();
                            Mono allocator = this.poolConfig.allocator();
                            Mono primary = allocator.doOnEach(sig -> {
                                if (sig.isOnNext()) {
                                    Connection newInstance = (Connection)sig.get();
                                    assert (newInstance != null);
                                    Slot newSlot = new Slot(this, newInstance);
                                    if (log.isDebugEnabled()) {
                                        log.debug(ReactorNetty.format((Channel)newInstance.channel(), (String)"Channel activated"));
                                    }
                                    ACQUIRED.incrementAndGet(this);
                                    borrower.deliver(new Http2PooledRef(newSlot));
                                } else if (sig.isOnError()) {
                                    Throwable error = sig.getThrowable();
                                    assert (error != null);
                                    this.poolConfig.allocationStrategy().returnPermits(1);
                                    borrower.fail(error);
                                }
                            }).contextWrite((ContextView)borrower.currentContext());
                            primary.subscribe(alreadyPropagated -> {}, alreadyPropagatedOrLogged -> this.drain(), this::drain);
                        }
                    }
                }
            }
            if (WIP.decrementAndGet(this) == 0) break;
        }
        this.recordInteractionTimestamp();
    }

    void evictInBackground() {
        ConcurrentLinkedQueue resources = CONNECTIONS.get(this);
        if (resources == null) {
            return;
        }
        if (WIP.getAndIncrement(this) == 0) {
            if (this.pendingSize == 0) {
                Iterator slots = resources.iterator();
                while (slots.hasNext()) {
                    Slot slot = (Slot)slots.next();
                    if (slot.concurrency() != 0) continue;
                    if (!slot.connection.channel().isActive()) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel is closed, remove from pool"));
                        }
                        this.recordInteractionTimestamp();
                        slots.remove();
                        IDLE_SIZE.decrementAndGet(this);
                        slot.invalidate();
                        continue;
                    }
                    if (slot.goAwayReceived()) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel received GO_AWAY, remove from pool"));
                        }
                        this.recordInteractionTimestamp();
                        slots.remove();
                        IDLE_SIZE.decrementAndGet(this);
                        slot.invalidate();
                        continue;
                    }
                    if (!this.testEvictionPredicate(slot)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Eviction predicate was true, remove from pool"));
                    }
                    slot.connection.channel().close();
                    this.recordInteractionTimestamp();
                    slots.remove();
                    IDLE_SIZE.decrementAndGet(this);
                    slot.invalidate();
                }
            }
            if (WIP.decrementAndGet(this) > 0) {
                this.drainLoop();
            }
        }
        this.scheduleEviction();
    }

    @Nullable
    Slot findConnection(ConcurrentLinkedQueue<Slot> resources) {
        int resourcesCount = this.idleSize;
        while (resourcesCount > 0) {
            --resourcesCount;
            Slot slot = this.pollSlot(resources);
            if (slot == null) continue;
            if (!slot.connection.channel().isActive()) {
                if (slot.concurrency() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel is closed, {} active streams"), new Object[]{slot.concurrency()});
                    }
                    this.offerSlot(resources, slot);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel is closed, remove from pool"));
                }
                slot.invalidate();
                continue;
            }
            if (slot.goAwayReceived()) {
                if (slot.concurrency() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel received GO_AWAY, {} active streams"), new Object[]{slot.concurrency()});
                    }
                    this.offerSlot(resources, slot);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel received GO_AWAY, remove from pool"));
                }
                slot.invalidate();
                continue;
            }
            if (this.testEvictionPredicate(slot)) {
                if (slot.concurrency() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Eviction predicate was true, {} active streams"), new Object[]{slot.concurrency()});
                    }
                    this.offerSlot(resources, slot);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Eviction predicate was true, remove from pool"));
                }
                slot.connection.channel().close();
                slot.invalidate();
                continue;
            }
            if (!slot.canOpenStream()) {
                this.offerSlot(resources, slot);
                if (!log.isDebugEnabled()) continue;
                log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Max active streams is reached"));
                continue;
            }
            return slot;
        }
        return null;
    }

    boolean testEvictionPredicate(Slot slot) {
        return this.poolConfig.evictionPredicate().test(slot.connection, slot);
    }

    void pendingAcquireLimitReached(Borrower borrower, int maxPending) {
        if (maxPending == 0) {
            borrower.fail((Throwable)new PoolAcquirePendingLimitException(0, "No pending allowed and pool has reached allocation limit"));
        } else {
            borrower.fail((Throwable)new PoolAcquirePendingLimitException(maxPending));
        }
    }

    void pendingOffer(Borrower borrower) {
        int maxPending = this.poolConfig.maxPending();
        ConcurrentLinkedDeque<Borrower> pendingQueue = this.pending;
        if (pendingQueue == TERMINATED) {
            return;
        }
        int postOffer = this.addPending(pendingQueue, borrower, false);
        if (WIP.getAndIncrement(this) == 0) {
            ConcurrentLinkedQueue<Slot> ir = this.connections;
            if (maxPending >= 0 && postOffer > maxPending && ir.isEmpty() && this.poolConfig.allocationStrategy().estimatePermitCount() == 0) {
                Borrower toCull = this.pollPending(pendingQueue, false);
                if (toCull != null) {
                    this.pendingAcquireLimitReached(toCull, maxPending);
                }
                if (WIP.decrementAndGet(this) > 0) {
                    this.drainLoop();
                }
                return;
            }
            this.drainLoop();
        }
    }

    void recordInteractionTimestamp() {
        this.lastInteractionTimestamp = this.clock.millis();
    }

    @Nullable
    Borrower pollPending(ConcurrentLinkedDeque<Borrower> borrowers, boolean pollFirst) {
        Borrower borrower;
        Borrower borrower2 = borrower = pollFirst ? borrowers.pollFirst() : borrowers.pollLast();
        if (borrower != null) {
            PENDING_SIZE.decrementAndGet(this);
        }
        return borrower;
    }

    void removePending(ConcurrentLinkedDeque<Borrower> borrowers, Borrower borrower) {
        if (borrowers.remove(borrower)) {
            PENDING_SIZE.decrementAndGet(this);
        }
    }

    int addPending(ConcurrentLinkedDeque<Borrower> borrowers, Borrower borrower, boolean first) {
        if (first) {
            borrowers.offerFirst(borrower);
        } else {
            borrowers.offerLast(borrower);
        }
        return PENDING_SIZE.incrementAndGet(this);
    }

    void offerSlot(@Nullable ConcurrentLinkedQueue<Slot> slots, Slot slot) {
        if (slots != null && slots.offer(slot)) {
            IDLE_SIZE.incrementAndGet(this);
        }
    }

    @Nullable
    Slot pollSlot(@Nullable ConcurrentLinkedQueue<Slot> slots) {
        if (slots == null) {
            return null;
        }
        Slot slot = slots.poll();
        if (slot != null) {
            IDLE_SIZE.decrementAndGet(this);
        }
        return slot;
    }

    void removeSlot(Slot slot) {
        ConcurrentLinkedQueue q = CONNECTIONS.get(slot.pool);
        if (q != null && q.remove(slot)) {
            IDLE_SIZE.decrementAndGet(this);
        }
    }

    void scheduleEviction() {
        if (!this.poolConfig.evictInBackgroundInterval().isZero()) {
            long nanosEvictionInterval = this.poolConfig.evictInBackgroundInterval().toNanos();
            this.evictionTask = this.poolConfig.evictInBackgroundScheduler().schedule(this::evictInBackground, nanosEvictionInterval, TimeUnit.NANOSECONDS);
        } else {
            this.evictionTask = Disposables.disposed();
        }
    }

    static final class Slot
    extends AtomicBoolean
    implements PooledRefMetadata {
        volatile int concurrency;
        static final AtomicIntegerFieldUpdater<Slot> CONCURRENCY = AtomicIntegerFieldUpdater.newUpdater(Slot.class, "concurrency");
        final Connection connection;
        final long creationTimestamp;
        final Http2Pool pool;
        final String applicationProtocol;
        long idleTimestamp;
        long maxConcurrentStreams;
        volatile ChannelHandlerContext http2FrameCodecCtx;
        volatile ChannelHandlerContext http2MultiplexHandlerCtx;
        volatile ChannelHandlerContext h2cUpgradeHandlerCtx;

        Slot(Http2Pool pool, Connection connection) {
            this.connection = connection;
            this.creationTimestamp = pool.clock.millis();
            this.pool = pool;
            SslHandler handler = (SslHandler)connection.channel().pipeline().get(SslHandler.class);
            this.applicationProtocol = handler != null ? (handler.applicationProtocol() != null ? handler.applicationProtocol() : "http/1.1") : null;
            ChannelHandlerContext frameCodec = this.http2FrameCodecCtx();
            if (frameCodec != null && this.http2MultiplexHandlerCtx() != null) {
                this.maxConcurrentStreams = ((Http2FrameCodec)frameCodec.handler()).connection().local().maxActiveStreams();
                this.maxConcurrentStreams = pool.maxConcurrentStreams == -1L ? this.maxConcurrentStreams : Math.min(pool.maxConcurrentStreams, this.maxConcurrentStreams);
            }
            TOTAL_MAX_CONCURRENT_STREAMS.addAndGet(this.pool, this.maxConcurrentStreams);
        }

        boolean canOpenStream() {
            ChannelHandlerContext frameCodec = this.http2FrameCodecCtx();
            if (frameCodec != null && this.http2MultiplexHandlerCtx() != null) {
                int concurrency;
                long maxActiveStreams = ((Http2FrameCodec)frameCodec.handler()).connection().local().maxActiveStreams();
                maxActiveStreams = this.pool.maxConcurrentStreams == -1L ? maxActiveStreams : Math.min(this.pool.maxConcurrentStreams, maxActiveStreams);
                long diff = maxActiveStreams - this.maxConcurrentStreams;
                if (diff != 0L) {
                    this.maxConcurrentStreams = maxActiveStreams;
                    TOTAL_MAX_CONCURRENT_STREAMS.addAndGet(this.pool, diff);
                }
                return (long)(concurrency = this.concurrency) < maxActiveStreams;
            }
            return false;
        }

        int concurrency() {
            return this.concurrency;
        }

        void deactivate() {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.connection.channel(), (String)"Channel deactivated"));
            }
            ConcurrentLinkedQueue slots = CONNECTIONS.get(this.pool);
            this.pool.offerSlot(slots, this);
        }

        int decrementConcurrencyAndGet() {
            int concurrency = CONCURRENCY.decrementAndGet(this);
            this.idleTimestamp = this.pool.clock.millis();
            return concurrency;
        }

        boolean goAwayReceived() {
            ChannelHandlerContext frameCodec = this.http2FrameCodecCtx();
            return frameCodec != null && ((Http2FrameCodec)frameCodec.handler()).connection().goAwayReceived();
        }

        @Nullable
        ChannelHandlerContext http2FrameCodecCtx() {
            ChannelHandlerContext ctx = this.http2FrameCodecCtx;
            if (ctx != null && this.connection.channel().eventLoop().inEventLoop() && !ctx.isRemoved()) {
                return ctx;
            }
            this.http2FrameCodecCtx = ctx = this.connection.channel().pipeline().context(Http2FrameCodec.class);
            return ctx;
        }

        @Nullable
        ChannelHandlerContext http2MultiplexHandlerCtx() {
            ChannelHandlerContext ctx = this.http2MultiplexHandlerCtx;
            if (ctx != null && this.connection.channel().eventLoop().inEventLoop() && !ctx.isRemoved()) {
                return ctx;
            }
            this.http2MultiplexHandlerCtx = ctx = this.connection.channel().pipeline().context(Http2MultiplexHandler.class);
            return ctx;
        }

        @Nullable
        ChannelHandlerContext h2cUpgradeHandlerCtx() {
            ChannelHandlerContext ctx = this.h2cUpgradeHandlerCtx;
            if (ctx != null && this.connection.channel().eventLoop().inEventLoop() && !ctx.isRemoved()) {
                return ctx;
            }
            this.h2cUpgradeHandlerCtx = ctx = this.connection.channel().pipeline().context("reactor.left.h2cUpgradeHandler");
            return ctx;
        }

        void incrementConcurrencyAndGet() {
            CONCURRENCY.incrementAndGet(this);
        }

        void invalidate() {
            if (this.compareAndSet(false, true)) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)this.connection.channel(), (String)"Channel removed from pool"));
                }
                this.pool.poolConfig.allocationStrategy().returnPermits(1);
                TOTAL_MAX_CONCURRENT_STREAMS.addAndGet(this.pool, -this.maxConcurrentStreams);
            }
        }

        public long idleTime() {
            if (this.concurrency() > 0) {
                return 0L;
            }
            long idleTime = this.idleTimestamp != 0L ? this.idleTimestamp : this.creationTimestamp;
            return this.pool.clock.millis() - idleTime;
        }

        public int acquireCount() {
            return 1;
        }

        public long lifeTime() {
            return this.pool.clock.millis() - this.creationTimestamp;
        }

        public long releaseTimestamp() {
            return 0L;
        }

        public long allocationTimestamp() {
            return this.creationTimestamp;
        }
    }

    static final class Http2PooledRef
    extends AtomicBoolean
    implements PooledRef<Connection>,
    PooledRefMetadata {
        final int acquireCount;
        final Slot slot;

        Http2PooledRef(Slot slot) {
            this.acquireCount = 0;
            this.slot = slot;
        }

        public int acquireCount() {
            return 1;
        }

        public long allocationTimestamp() {
            return 0L;
        }

        public long idleTime() {
            return 0L;
        }

        public Mono<Void> invalidate() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    ACQUIRED.decrementAndGet(this.slot.pool);
                    return this.slot.pool.destroyPoolable(this).doFinally(st -> this.slot.pool.drain());
                }
                return Mono.empty();
            });
        }

        public long lifeTime() {
            return 0L;
        }

        public PooledRefMetadata metadata() {
            return this;
        }

        public Connection poolable() {
            return this.slot.connection;
        }

        public Mono<Void> release() {
            return this.invalidate();
        }

        public long releaseTimestamp() {
            return 0L;
        }

        @Override
        public String toString() {
            return "PooledRef{poolable=" + this.slot.connection + '}';
        }
    }

    static final class BorrowerMono
    extends Mono<PooledRef<Connection>> {
        final Duration acquireTimeout;
        final Http2Pool parent;

        BorrowerMono(Http2Pool pool, Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            this.parent = pool;
        }

        public void subscribe(CoreSubscriber<? super PooledRef<Connection>> actual) {
            Objects.requireNonNull(actual, "subscribing with null");
            Borrower borrower = new Borrower(actual, this.parent, this.acquireTimeout);
            actual.onSubscribe((Subscription)borrower);
        }
    }

    static final class Borrower
    extends AtomicBoolean
    implements Scannable,
    Subscription,
    Runnable {
        static final Disposable TIMEOUT_DISPOSED = Disposables.disposed();
        final Duration acquireTimeout;
        final CoreSubscriber<? super Http2PooledRef> actual;
        final Http2Pool pool;
        Disposable timeoutTask;

        Borrower(CoreSubscriber<? super Http2PooledRef> actual, Http2Pool pool, Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            this.actual = actual;
            this.pool = pool;
            this.timeoutTask = TIMEOUT_DISPOSED;
        }

        public void cancel() {
            this.stopPendingCountdown();
            if (this.compareAndSet(false, true)) {
                this.pool.cancelAcquire(this);
            }
        }

        Context currentContext() {
            return this.actual.currentContext();
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                long estimateStreamsCount = this.pool.totalMaxConcurrentStreams - (long)this.pool.acquired;
                int permits = this.pool.poolConfig.allocationStrategy().estimatePermitCount();
                int pending = this.pool.pendingSize;
                if (!this.acquireTimeout.isZero() && (long)permits + estimateStreamsCount <= (long)pending) {
                    this.timeoutTask = (Disposable)this.pool.poolConfig.pendingAcquireTimer().apply(this, this.acquireTimeout);
                }
                this.pool.doAcquire(this);
            }
        }

        @Override
        public void run() {
            if (this.compareAndSet(false, true)) {
                this.pool.cancelAcquire(this);
                this.actual.onError((Throwable)new PoolAcquireTimeoutException(this.acquireTimeout));
            }
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.get();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return 1;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.get() ? "Borrower(cancelled)" : "Borrower";
        }

        void deliver(Http2PooledRef poolSlot) {
            assert (poolSlot.slot.connection.channel().eventLoop().inEventLoop());
            poolSlot.slot.incrementConcurrencyAndGet();
            poolSlot.slot.deactivate();
            if (this.get()) {
                poolSlot.invalidate().subscribe(aVoid -> {}, e -> Operators.onErrorDropped((Throwable)e, (Context)Context.empty()));
            } else {
                this.actual.onNext((Object)poolSlot);
                this.actual.onComplete();
            }
        }

        void fail(Throwable error) {
            this.stopPendingCountdown();
            if (!this.get()) {
                this.actual.onError(error);
            }
        }

        void stopPendingCountdown() {
            this.timeoutTask.dispose();
        }
    }
}

