/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta.sql;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.SketchQueryContext;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class ThetaSketchBaseSqlAggregator
implements SqlAggregator {
    private final boolean finalizeSketch;

    protected ThetaSketchBaseSqlAggregator(boolean finalizeSketch) {
        this.finalizeSketch = finalizeSketch;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        SketchMergeAggregatorFactory aggregatorFactory;
        String aggregatorName;
        int sketchSize;
        RexNode columnRexNode = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue());
        DruidExpression columnArg = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)columnRexNode);
        if (columnArg == null) {
            return null;
        }
        if (aggregateCall.getArgList().size() >= 2) {
            RexNode sketchSizeArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
            if (!sketchSizeArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            sketchSize = ((Number)((Object)RexLiteral.value((RexNode)sketchSizeArg))).intValue();
        } else {
            sketchSize = 16384;
        }
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName((String)name, (String)"a") : name;
        if (columnArg.isDirectColumnAccess() && inputAccessor.getInputRowSignature().getColumnType(columnArg.getDirectColumn()).map(type -> SketchModule.THETA_SKETCH_TYPE.equals(type) || SketchModule.MERGE_TYPE.equals(type) || SketchModule.BUILD_TYPE.equals(type)).orElse(false).booleanValue()) {
            aggregatorFactory = new SketchMergeAggregatorFactory(aggregatorName, columnArg.getDirectColumn(), sketchSize, this.finalizeSketch || SketchQueryContext.isFinalizeOuterSketches(plannerContext), null, null);
        } else {
            DimensionSpec dimensionSpec;
            RelDataType dataType = columnRexNode.getType();
            ColumnType inputType = Calcites.getColumnTypeForRelDataType((RelDataType)dataType);
            if (inputType == null) {
                throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{dataType.getSqlTypeName(), aggregatorName});
            }
            if (inputType.is((TypeDescriptor)ValueType.COMPLEX) && !this.isValidComplexInputType(inputType)) {
                plannerContext.setPlanningError("Using APPROX_COUNT_DISTINCT() or enabling approximation with COUNT(DISTINCT) is not supported for column type [%s]. You can disable approximation by setting [%s: false] in the query context.", new Object[]{columnArg.getDruidType(), "useApproximateCountDistinct"});
                return null;
            }
            if (columnArg.isDirectColumnAccess()) {
                dimensionSpec = columnArg.getSimpleExtraction().toDimensionSpec(null, inputType);
            } else {
                String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(columnArg, dataType);
                dimensionSpec = new DefaultDimensionSpec(virtualColumnName, null, inputType);
            }
            aggregatorFactory = new SketchMergeAggregatorFactory(aggregatorName, dimensionSpec.getDimension(), sketchSize, this.finalizeSketch || SketchQueryContext.isFinalizeOuterSketches(plannerContext), null, null);
        }
        return this.toAggregation(name, finalizeAggregations, aggregatorFactory);
    }

    protected abstract Aggregation toAggregation(String var1, boolean var2, AggregatorFactory var3);

    private boolean isValidComplexInputType(ColumnType columnType) {
        return SketchModule.THETA_SKETCH_TYPE.equals((Object)columnType) || "thetaSketch".equals(columnType.getComplexTypeName()) || "thetaSketchBuild".equals(columnType.getComplexTypeName()) || "thetaSketchMerge".equals(columnType.getComplexTypeName());
    }
}

