CREATE TABLE IF NOT EXISTS github_events
(
  repo_name STRING NOT NULL,
  created_at DATETIME NOT NULL,
  file_time DATETIME NOT NULL,
  event_type VARCHAR(30) NOT NULL,
  actor_login STRING NOT NULL,
  updated_at DATETIME NOT NULL,
  action VARCHAR(30) NOT NULL,
  comment_id BIGINT NOT NULL,
  body STRING NOT NULL,
  path STRING NOT NULL,
  position INT NOT NULL,
  line INT NOT NULL,
  ref STRING NOT NULL,
  ref_type VARCHAR(10) NOT NULL,
  creator_user_login STRING NOT NULL,
  number INT NOT NULL,
  title STRING NOT NULL,
  labels STRING NOT NULL,
  state VARCHAR(10) NOT NULL,
  locked TINYINT NOT NULL,
  assignee STRING NOT NULL,
  assignees STRING NOT NULL,
  comments INT NOT NULL,
  author_association VARCHAR(20) NOT NULL,
  closed_at DATETIME NOT NULL,
  merged_at DATETIME NOT NULL,
  merge_commit_sha STRING NOT NULL,
  requested_reviewers STRING NOT NULL,
  requested_teams STRING NOT NULL,
  head_ref STRING NOT NULL,
  head_sha STRING NOT NULL,
  base_ref STRING NOT NULL,
  base_sha STRING NOT NULL,
  merged TINYINT NOT NULL,
  mergeable TINYINT NOT NULL,
  rebaseable TINYINT NOT NULL,
  mergeable_state VARCHAR(10) NOT NULL,
  merged_by STRING NOT NULL,
  review_comments INT NOT NULL,
  maintainer_can_modify TINYINT NOT NULL,
  commits INT NOT NULL,
  additions INT NOT NULL,
  deletions INT NOT NULL,
  changed_files INT NOT NULL,
  diff_hunk STRING NOT NULL,
  original_position INT NOT NULL,
  commit_id STRING NOT NULL,
  original_commit_id STRING NOT NULL,
  push_size INT NOT NULL,
  push_distinct_size INT NOT NULL,
  member_login STRING NOT NULL,
  release_tag_name STRING NOT NULL,
  release_name STRING NOT NULL,
  review_state VARCHAR(20) NOT NULL
)
DUPLICATE KEY (repo_name, created_at)
PARTITION BY LIST(event_type)
(
  PARTITION event_1 VALUES IN("CommitCommentEvent"),
  PARTITION event_2 VALUES IN("CreateEvent"),
  PARTITION event_3 VALUES IN("DeleteEvent"),
  PARTITION event_4 VALUES IN("ForkEvent"),
  PARTITION event_5 VALUES IN("GollumEvent"),
  PARTITION event_6 VALUES IN("IssueCommentEvent"),
  PARTITION event_7 VALUES IN("IssuesEvent"),
  PARTITION event_8 VALUES IN("MemberEvent"),
  PARTITION event_9 VALUES IN("PublicEvent"),
  PARTITION event_10 VALUES IN("PullRequestEvent"),
  PARTITION event_11 VALUES IN("PullRequestReviewCommentEvent"),
  PARTITION event_12 VALUES IN("PushEvent"),
  PARTITION event_13 VALUES IN("ReleaseEvent"),
  PARTITION event_14 VALUES IN("SponsorshipEvent"),
  PARTITION event_15 VALUES IN("WatchEvent"),
  PARTITION event_16 VALUES IN("GistEvent"),
  PARTITION event_17 VALUES IN("FollowEvent"),
  PARTITION event_18 VALUES IN("DownloadEvent"),
  PARTITION event_19 VALUES IN("PullRequestReviewEvent"),
  PARTITION event_20 VALUES IN("ForkApplyEvent"),
  PARTITION event_21 VALUES IN("Event"),
  PARTITION event_22 VALUES IN("TeamAddEvent")
)
DISTRIBUTED BY HASH(repo_name) BUCKETS 16
PROPERTIES
(
  "replication_num" = "1"
)
