/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachinePropertiesInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.ApplicationProfile;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.CapacityReservationProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ScheduledEventsProfile;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class VirtualMachineInner
extends Resource {
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="properties")
    private VirtualMachinePropertiesInner innerProperties;
    @JsonProperty(value="resources", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineExtensionInner> resources;
    @JsonProperty(value="identity")
    private VirtualMachineIdentity identity;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    private VirtualMachinePropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public List<VirtualMachineExtensionInner> resources() {
        return this.resources;
    }

    public VirtualMachineIdentity identity() {
        return this.identity;
    }

    public VirtualMachineInner withIdentity(VirtualMachineIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public VirtualMachineInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public HardwareProfile hardwareProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareProfile();
    }

    public VirtualMachineInner withHardwareProfile(HardwareProfile hardwareProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withHardwareProfile(hardwareProfile);
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public VirtualMachineInner withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public OSProfile osProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().osProfile();
    }

    public VirtualMachineInner withOsProfile(OSProfile osProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withOsProfile(osProfile);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public VirtualMachineInner withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    public VirtualMachineInner withSecurityProfile(SecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnosticsProfile();
    }

    public VirtualMachineInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withDiagnosticsProfile(diagnosticsProfile);
        return this;
    }

    public SubResource availabilitySet() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilitySet();
    }

    public VirtualMachineInner withAvailabilitySet(SubResource availabilitySet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withAvailabilitySet(availabilitySet);
        return this;
    }

    public SubResource virtualMachineScaleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineScaleSet();
    }

    public VirtualMachineInner withVirtualMachineScaleSet(SubResource virtualMachineScaleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withVirtualMachineScaleSet(virtualMachineScaleSet);
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public VirtualMachineInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public VirtualMachineInner withPriority(VirtualMachinePriorityTypes priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().evictionPolicy();
    }

    public VirtualMachineInner withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withEvictionPolicy(evictionPolicy);
        return this;
    }

    public BillingProfile billingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().billingProfile();
    }

    public VirtualMachineInner withBillingProfile(BillingProfile billingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withBillingProfile(billingProfile);
        return this;
    }

    public SubResource host() {
        return this.innerProperties() == null ? null : this.innerProperties().host();
    }

    public VirtualMachineInner withHost(SubResource host) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withHost(host);
        return this;
    }

    public SubResource hostGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().hostGroup();
    }

    public VirtualMachineInner withHostGroup(SubResource hostGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withHostGroup(hostGroup);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VirtualMachineInstanceViewInner instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public String licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public VirtualMachineInner withLicenseType(String licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String vmId() {
        return this.innerProperties() == null ? null : this.innerProperties().vmId();
    }

    public String extensionsTimeBudget() {
        return this.innerProperties() == null ? null : this.innerProperties().extensionsTimeBudget();
    }

    public VirtualMachineInner withExtensionsTimeBudget(String extensionsTimeBudget) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withExtensionsTimeBudget(extensionsTimeBudget);
        return this;
    }

    public Integer platformFaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomain();
    }

    public VirtualMachineInner withPlatformFaultDomain(Integer platformFaultDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withPlatformFaultDomain(platformFaultDomain);
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledEventsProfile();
    }

    public VirtualMachineInner withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withScheduledEventsProfile(scheduledEventsProfile);
        return this;
    }

    public String userData() {
        return this.innerProperties() == null ? null : this.innerProperties().userData();
    }

    public VirtualMachineInner withUserData(String userData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withUserData(userData);
        return this;
    }

    public CapacityReservationProfile capacityReservation() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityReservation();
    }

    public VirtualMachineInner withCapacityReservation(CapacityReservationProfile capacityReservation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withCapacityReservation(capacityReservation);
        return this;
    }

    public ApplicationProfile applicationProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationProfile();
    }

    public VirtualMachineInner withApplicationProfile(ApplicationProfile applicationProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePropertiesInner();
        }
        this.innerProperties().withApplicationProfile(applicationProfile);
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }
}

