/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="HDInsight")
public final class HDInsightLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private HDInsightLinkedServiceTypeProperties innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightLinkedService.class);

    private HDInsightLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public HDInsightLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public HDInsightLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object clusterUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clusterUri();
    }

    public HDInsightLinkedService withClusterUri(Object clusterUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClusterUri(clusterUri);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public HDInsightLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public HDInsightLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedServiceName();
    }

    public HDInsightLinkedService withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLinkedServiceName(linkedServiceName);
        return this;
    }

    public LinkedServiceReference hcatalogLinkedServiceName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hcatalogLinkedServiceName();
    }

    public HDInsightLinkedService withHcatalogLinkedServiceName(LinkedServiceReference hcatalogLinkedServiceName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHcatalogLinkedServiceName(hcatalogLinkedServiceName);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public HDInsightLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object isEspEnabled() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().isEspEnabled();
    }

    public HDInsightLinkedService withIsEspEnabled(Object isEspEnabled) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIsEspEnabled(isEspEnabled);
        return this;
    }

    public Object fileSystem() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileSystem();
    }

    public HDInsightLinkedService withFileSystem(Object fileSystem) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFileSystem(fileSystem);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

