/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.OperationResultProperties;
import com.azure.resourcemanager.appservice.models.RetryHistory;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public class OperationResult
extends OperationResultProperties {
    @JsonProperty(value="trackingId", access=JsonProperty.Access.WRITE_ONLY)
    private String trackingId;
    @JsonProperty(value="inputs", access=JsonProperty.Access.WRITE_ONLY)
    private Object inputs;
    @JsonProperty(value="inputsLink", access=JsonProperty.Access.WRITE_ONLY)
    private ContentLink inputsLink;
    @JsonProperty(value="outputs", access=JsonProperty.Access.WRITE_ONLY)
    private Object outputs;
    @JsonProperty(value="outputsLink", access=JsonProperty.Access.WRITE_ONLY)
    private ContentLink outputsLink;
    @JsonProperty(value="trackedProperties", access=JsonProperty.Access.WRITE_ONLY)
    private Object trackedProperties;
    @JsonProperty(value="retryHistory")
    private List<RetryHistory> retryHistory;
    @JsonProperty(value="iterationCount")
    private Integer iterationCount;

    public String trackingId() {
        return this.trackingId;
    }

    public Object inputs() {
        return this.inputs;
    }

    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    public Object outputs() {
        return this.outputs;
    }

    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    public Object trackedProperties() {
        return this.trackedProperties;
    }

    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    public OperationResult withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    public Integer iterationCount() {
        return this.iterationCount;
    }

    public OperationResult withIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    @Override
    public OperationResult withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    @Override
    public OperationResult withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    @Override
    public OperationResult withCorrelation(RunActionCorrelation correlation) {
        super.withCorrelation(correlation);
        return this;
    }

    @Override
    public OperationResult withStatus(WorkflowStatus status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public OperationResult withCode(String code) {
        super.withCode(code);
        return this;
    }

    @Override
    public OperationResult withError(Object error) {
        super.withError(error);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.inputsLink() != null) {
            this.inputsLink().validate();
        }
        if (this.outputsLink() != null) {
            this.outputsLink().validate();
        }
        if (this.retryHistory() != null) {
            this.retryHistory().forEach(e -> e.validate());
        }
    }
}

