/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureKeyVaultSecret")
public final class AzureKeyVaultSecretReference
extends SecretBase {
    @JsonProperty(value="store", required=true)
    private LinkedServiceReference store;
    @JsonProperty(value="secretName", required=true)
    private Object secretName;
    @JsonProperty(value="secretVersion")
    private Object secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyVaultSecretReference.class);

    public LinkedServiceReference store() {
        return this.store;
    }

    public AzureKeyVaultSecretReference withStore(LinkedServiceReference store) {
        this.store = store;
        return this;
    }

    public Object secretName() {
        return this.secretName;
    }

    public AzureKeyVaultSecretReference withSecretName(Object secretName) {
        this.secretName = secretName;
        return this;
    }

    public Object secretVersion() {
        return this.secretVersion;
    }

    public AzureKeyVaultSecretReference withSecretVersion(Object secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.store() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property store in model AzureKeyVaultSecretReference"));
        }
        this.store().validate();
        if (this.secretName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretName in model AzureKeyVaultSecretReference"));
        }
    }
}

