/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.ARecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.AaaaRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.CnameRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.MxRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.implementation.PtrRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.SoaRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.SrvRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.TxtRecordSetImpl;
import com.azure.resourcemanager.privatedns.models.PrivateDnsRecordSet;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;

class PrivateDnsRecordSetsImpl
extends ExternalChildResourcesNonCachedImpl<PrivateDnsRecordSetImpl, PrivateDnsRecordSet, RecordSetInner, PrivateDnsZoneImpl, PrivateDnsZone> {
    private static final long DEFAULT_TTL_IN_SECONDS = 3600L;

    PrivateDnsRecordSetsImpl(PrivateDnsZoneImpl parent) {
        super((Object)parent, parent.taskGroup(), "PrivateRecordSet");
    }

    private PrivateDnsRecordSetImpl setDefaults(PrivateDnsRecordSetImpl recordSet) {
        return recordSet.withTimeToLive(3600L);
    }

    PrivateDnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(AaaaRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl defineARecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(ARecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    void withCnameRecordSet(String name, String alias) {
        CnameRecordSetImpl recordSet = CnameRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent());
        ((RecordSetInner)((Object)recordSet.innerModel())).cnameRecord().withCname(alias);
        this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(recordSet.withTimeToLive(3600L)));
    }

    PrivateDnsRecordSetImpl defineCnameRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(CnameRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl defineMxRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(MxRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl definePtrRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(PtrRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl defineSoaRecordSet() {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(SoaRecordSetImpl.newRecordSet((PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(SrvRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.setDefaults((PrivateDnsRecordSetImpl)this.prepareInlineDefine(TxtRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent())));
    }

    PrivateDnsRecordSetImpl updateAaaaRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(AaaaRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateARecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(ARecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateCnameRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(CnameRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateMxRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(MxRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updatePtrRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(PtrRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateSoaRecordSet() {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(SoaRecordSetImpl.newRecordSet((PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateSrvRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(SrvRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    PrivateDnsRecordSetImpl updateTxtRecordSet(String name) {
        return (PrivateDnsRecordSetImpl)this.prepareInlineUpdate(TxtRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()));
    }

    void withoutAaaaRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(AaaaRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutARecordSet(String name, String etagValue) {
        this.prepareInlineRemove(ARecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutCnameRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(CnameRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutMxRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(MxRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutPtrRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(PtrRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutSrvRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(SrvRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }

    void withoutTxtRecordSet(String name, String etagValue) {
        this.prepareInlineRemove(TxtRecordSetImpl.newRecordSet(name, (PrivateDnsZoneImpl)this.getParent()).withETagOnDelete(etagValue));
    }
}

