/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.annotation.Nullable;

final class Http2StreamBridgeServerHandler
extends ChannelDuplexHandler
implements ChannelFutureListener {
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    SocketAddress remoteAddress;
    Boolean secured;
    boolean pendingResponse;

    Http2StreamBridgeServerHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle) {
        this.compress = compress;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.listener = listener;
        this.mapHandle = mapHandle;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"New HTTP/2 stream"));
        }
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(ctx.channel().parent().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            try {
                this.pendingResponse = true;
                ops = new HttpServerOperations(Connection.from((Channel)ctx.channel()), this.listener, request, this.compress, ConnectionInfo.from(ctx.channel().parent(), request, this.secured, this.remoteAddress, this.forwardedHeaderHandler), this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.mapHandle, this.secured);
            }
            catch (RuntimeException e) {
                this.pendingResponse = false;
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, this.secured, e, msg);
                return;
            }
            ops.bind();
            this.listener.onStateChange((Connection)ops, ConnectionObserver.State.CONFIGURED);
        } else if (!this.pendingResponse) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"Dropped HTTP content, since response has been sent already: {}"), new Object[]{msg});
            }
            ReferenceCountUtil.release((Object)msg);
            ctx.read();
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write((Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                this.pendingResponse = false;
                f.addListener((GenericFutureListener)this);
                ctx.read();
            }
        }
    }

    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format((Channel)future.channel(), (String)"Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format((Channel)future.channel(), (String)"Last HTTP packet was sent, terminating the channel"));
        }
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }
}

