/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkPeering;
import com.azure.resourcemanager.network.models.NetworkPeeringGatewayUse;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class NetworkPeeringImpl
extends IndependentChildImpl<NetworkPeering, Network, VirtualNetworkPeeringInner, NetworkPeeringImpl, NetworkManager>
implements NetworkPeering,
NetworkPeering.Definition,
NetworkPeering.Update {
    private NetworkImpl parent;
    private Network remoteNetwork;
    private Boolean remoteAccess;
    private Boolean remoteForwarding;
    private Boolean startGatewayUseByRemoteNetwork;
    private Boolean allowGatewayUseOnRemoteNetwork;

    NetworkPeeringImpl(VirtualNetworkPeeringInner inner, NetworkImpl parent) {
        super(inner.name(), (Object)inner, (Object)((NetworkManager)parent.manager()));
        this.parent = parent;
        this.remoteAccess = null;
        this.remoteForwarding = null;
    }

    @Override
    public boolean isSameSubscription() {
        if (this.remoteNetworkId() == null) {
            return false;
        }
        String localSubscriptionId = ResourceUtils.subscriptionFromResourceId((String)this.id());
        String remoteSubscriptionId = ResourceUtils.subscriptionFromResourceId((String)this.remoteNetworkId());
        return localSubscriptionId.equalsIgnoreCase(remoteSubscriptionId);
    }

    @Override
    public VirtualNetworkPeeringState state() {
        return ((VirtualNetworkPeeringInner)((Object)this.innerModel())).peeringState();
    }

    public String name() {
        return ((VirtualNetworkPeeringInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((VirtualNetworkPeeringInner)((Object)this.innerModel())).id();
    }

    @Override
    public String networkId() {
        return this.parent.id();
    }

    @Override
    public List<String> remoteAddressSpaces() {
        if (((VirtualNetworkPeeringInner)((Object)this.innerModel())).remoteAddressSpace() == null || ((VirtualNetworkPeeringInner)((Object)this.innerModel())).remoteAddressSpace().addressPrefixes() == null) {
            return null;
        }
        return Collections.unmodifiableList(((VirtualNetworkPeeringInner)((Object)this.innerModel())).remoteAddressSpace().addressPrefixes());
    }

    @Override
    public String remoteNetworkId() {
        return ((VirtualNetworkPeeringInner)((Object)this.innerModel())).remoteVirtualNetwork() != null ? ((VirtualNetworkPeeringInner)((Object)this.innerModel())).remoteVirtualNetwork().id() : null;
    }

    @Override
    public boolean isTrafficForwardingFromRemoteNetworkAllowed() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.innerModel())).allowForwardedTraffic());
    }

    private boolean isAccessFromRemoteNetworkAllowed() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.innerModel())).allowVirtualNetworkAccess());
    }

    private NetworkPeeringImpl withoutAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowVirtualNetworkAccess(false);
        return this;
    }

    private NetworkPeeringImpl withAccessFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowVirtualNetworkAccess(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withAccessBetweenBothNetworks() {
        return this.withAccessFromRemoteNetwork().withAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutAccessFromEitherNetwork() {
        return this.withoutAccessFromRemoteNetwork().withoutAccessToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(String resourceId) {
        SubResource networkRef = new SubResource().withId(resourceId);
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withRemoteVirtualNetwork(networkRef);
        return this;
    }

    @Override
    public NetworkPeeringImpl withRemoteNetwork(Network network) {
        if (network != null) {
            this.remoteNetwork = network;
            return this.withRemoteNetwork(network.id());
        }
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowForwardedTraffic(true);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowForwardedTraffic(false);
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingFromEitherNetwork() {
        return this.withoutTrafficForwardingFromRemoteNetwork().withoutTrafficForwardingToRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutTrafficForwardingToRemoteNetwork() {
        this.remoteForwarding = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withTrafficForwardingBetweenBothNetworks() {
        return this.withTrafficForwardingFromRemoteNetwork().withTrafficForwardingToRemoteNetwork();
    }

    private NetworkPeeringImpl withoutAccessToRemoteNetwork() {
        this.remoteAccess = false;
        return this;
    }

    private NetworkPeeringImpl withAccessToRemoteNetwork() {
        this.remoteAccess = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkAllowed() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowGatewayTransit(true).withUseRemoteGateways(false);
        this.startGatewayUseByRemoteNetwork = null;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withGatewayUseByRemoteNetworkStarted() {
        this.startGatewayUseByRemoteNetwork = true;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this.withGatewayUseByRemoteNetworkAllowed();
    }

    @Override
    public NetworkPeeringImpl withGatewayUseOnRemoteNetworkStarted() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowGatewayTransit(false).withUseRemoteGateways(true);
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = true;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutAnyGatewayUse() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withAllowGatewayTransit(false);
        return this.withoutGatewayUseOnRemoteNetwork().withoutGatewayUseByRemoteNetwork();
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseByRemoteNetwork() {
        this.startGatewayUseByRemoteNetwork = false;
        this.allowGatewayUseOnRemoteNetwork = false;
        return this;
    }

    @Override
    public NetworkPeeringImpl withoutGatewayUseOnRemoteNetwork() {
        ((VirtualNetworkPeeringInner)((Object)this.innerModel())).withUseRemoteGateways(false);
        return this;
    }

    @Override
    public boolean checkAccessBetweenNetworks() {
        if (!ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.innerModel())).allowVirtualNetworkAccess())) {
            return false;
        }
        NetworkPeering remotePeering = this.getRemotePeering();
        if (remotePeering == null) {
            return false;
        }
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)remotePeering.innerModel())).allowVirtualNetworkAccess());
    }

    protected Mono<NetworkPeering> createChildResourceAsync() {
        NetworkPeeringImpl localPeering = this;
        String networkName = ResourceUtils.nameFromResourceId((String)this.networkId());
        return ((NetworkManagementClient)((NetworkManager)((Object)this.manager())).serviceClient()).getVirtualNetworkPeerings().createOrUpdateAsync(this.parent.resourceGroupName(), networkName, this.name(), (VirtualNetworkPeeringInner)((Object)this.innerModel())).doOnNext(inner -> this.setInner(inner)).flatMap(inner -> {
            SubResource networkRef = inner.remoteVirtualNetwork();
            if (localPeering.isSameSubscription()) {
                return ((NetworkManager)((Object)((Object)localPeering.manager()))).networks().getByIdAsync(networkRef.id());
            }
            return Mono.empty();
        }).flatMap(remoteNetwork -> remoteNetwork.peerings().listAsync().filter(remotePeering -> remotePeering != null && remotePeering.remoteNetworkId() != null && remotePeering.remoteNetworkId().equalsIgnoreCase(localPeering.parent.id())).collectList().flatMap(remotePeerings -> {
            if (remotePeerings.isEmpty()) {
                return Mono.empty();
            }
            return Mono.justOrEmpty((Object)((NetworkPeering)remotePeerings.get(remotePeerings.size() - 1)));
        }).flatMap(remotePeering -> {
            NetworkPeering.Update remotePeeringUpdate = (NetworkPeering.Update)remotePeering.update();
            boolean isUpdateNeeded = false;
            if (localPeering.remoteForwarding != null) {
                if (localPeering.remoteForwarding.booleanValue() && !remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = remotePeeringUpdate.withTrafficForwardingFromRemoteNetwork();
                } else if (!localPeering.remoteForwarding.booleanValue() && remotePeering.isTrafficForwardingFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = remotePeeringUpdate.withoutTrafficForwardingFromRemoteNetwork();
                }
            }
            if (localPeering.remoteAccess != null) {
                if (localPeering.remoteAccess.booleanValue() && !((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withAccessFromRemoteNetwork();
                } else if (!localPeering.remoteAccess.booleanValue() && ((NetworkPeeringImpl)remotePeering).isAccessFromRemoteNetworkAllowed()) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate = ((NetworkPeeringImpl)remotePeeringUpdate).withoutAccessFromRemoteNetwork();
                }
            }
            if (localPeering.allowGatewayUseOnRemoteNetwork != null) {
                if (localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate.withGatewayUseByRemoteNetworkAllowed();
                } else if (!localPeering.allowGatewayUseOnRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.BY_REMOTE_NETWORK) {
                    isUpdateNeeded = true;
                    remotePeeringUpdate.withoutGatewayUseByRemoteNetwork();
                }
            }
            if (localPeering.startGatewayUseByRemoteNetwork != null) {
                if (localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() != NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                    remotePeeringUpdate.withGatewayUseOnRemoteNetworkStarted();
                    isUpdateNeeded = true;
                } else if (!localPeering.startGatewayUseByRemoteNetwork.booleanValue() && remotePeering.gatewayUse() == NetworkPeeringGatewayUse.ON_REMOTE_NETWORK) {
                    remotePeeringUpdate.withoutGatewayUseOnRemoteNetwork();
                    isUpdateNeeded = true;
                }
            }
            if (isUpdateNeeded) {
                localPeering.remoteForwarding = null;
                localPeering.remoteAccess = null;
                localPeering.startGatewayUseByRemoteNetwork = null;
                localPeering.allowGatewayUseOnRemoteNetwork = null;
                return remotePeeringUpdate.applyAsync();
            }
            return Mono.just((Object)localPeering);
        }).switchIfEmpty(Mono.defer(() -> {
            String peeringName = ((NetworkManager)((Object)((Object)((Object)this.manager())))).resourceManager().internalContext().randomResourceName("peer", 15);
            NetworkPeering.DefinitionStages.WithCreate remotePeeringDefinition = ((NetworkPeering.DefinitionStages.Blank)remoteNetwork.peerings().define(peeringName)).withRemoteNetwork(localPeering.parent.id());
            if (localPeering.startGatewayUseByRemoteNetwork != null && localPeering.startGatewayUseByRemoteNetwork.booleanValue()) {
                remotePeeringDefinition.withGatewayUseOnRemoteNetworkStarted();
            }
            if (localPeering.allowGatewayUseOnRemoteNetwork != null && localPeering.allowGatewayUseOnRemoteNetwork.booleanValue()) {
                remotePeeringDefinition.withGatewayUseByRemoteNetworkAllowed();
            }
            if (localPeering.remoteAccess != null && !localPeering.remoteAccess.booleanValue()) {
                ((NetworkPeeringImpl)remotePeeringDefinition).withoutAccessFromRemoteNetwork();
            }
            if (localPeering.remoteForwarding != null && localPeering.remoteForwarding.booleanValue()) {
                remotePeeringDefinition.withTrafficForwardingFromRemoteNetwork();
            }
            localPeering.remoteAccess = null;
            localPeering.remoteForwarding = null;
            localPeering.startGatewayUseByRemoteNetwork = null;
            localPeering.allowGatewayUseOnRemoteNetwork = null;
            return remotePeeringDefinition.createAsync();
        }))).flatMap(remotePeering -> localPeering.parent != null ? localPeering.parent.refreshAsync() : Mono.empty()).flatMap(t -> {
            if (localPeering.remoteNetwork != null && localPeering.isSameSubscription()) {
                return localPeering.remoteNetwork.refreshAsync();
            }
            return Mono.empty();
        }).then(Mono.just((Object)localPeering));
    }

    protected Mono<VirtualNetworkPeeringInner> getInnerAsync() {
        this.remoteNetwork = null;
        return ((NetworkManagementClient)((NetworkManager)((Object)this.manager())).serviceClient()).getVirtualNetworkPeerings().getAsync(this.resourceGroupName(), ResourceUtils.nameFromResourceId((String)this.networkId()), ((VirtualNetworkPeeringInner)((Object)this.innerModel())).name());
    }

    @Override
    public Network getRemoteNetwork() {
        return (Network)this.getRemoteNetworkAsync().block();
    }

    @Override
    public Mono<Network> getRemoteNetworkAsync() {
        NetworkPeeringImpl self = this;
        if (self.remoteNetwork != null) {
            return Mono.just((Object)self.remoteNetwork);
        }
        if (this.isSameSubscription()) {
            return ((NetworkManager)((Object)this.manager())).networks().getByIdAsync(this.remoteNetworkId()).doOnNext(network -> {
                self.remoteNetwork = network;
            });
        }
        self.remoteNetwork = null;
        return Mono.empty();
    }

    @Override
    public NetworkPeering getRemotePeering() {
        Network network = this.getRemoteNetwork();
        return network != null ? network.peerings().getByRemoteNetwork(this.networkId()) : null;
    }

    @Override
    public Mono<NetworkPeering> getRemotePeeringAsync() {
        NetworkPeeringImpl self = this;
        return this.getRemoteNetworkAsync().flatMap(remoteNetwork -> {
            if (remoteNetwork == null) {
                return Mono.empty();
            }
            return remoteNetwork.peerings().getByRemoteNetworkAsync(self.networkId());
        });
    }

    @Override
    public NetworkPeeringGatewayUse gatewayUse() {
        if (ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.innerModel())).allowGatewayTransit())) {
            return NetworkPeeringGatewayUse.BY_REMOTE_NETWORK;
        }
        if (ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkPeeringInner)((Object)this.innerModel())).useRemoteGateways())) {
            return NetworkPeeringGatewayUse.ON_REMOTE_NETWORK;
        }
        return NetworkPeeringGatewayUse.NONE;
    }
}

