/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.IpGroupPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class IpGroupInner
extends Resource {
    @JsonProperty(value="properties")
    private IpGroupPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private IpGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public IpGroupInner withId(String id) {
        this.id = id;
        return this;
    }

    public IpGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IpGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> ipAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddresses();
    }

    public IpGroupInner withIpAddresses(List<String> ipAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpGroupPropertiesFormat();
        }
        this.innerProperties().withIpAddresses(ipAddresses);
        return this;
    }

    public List<SubResource> firewalls() {
        return this.innerProperties() == null ? null : this.innerProperties().firewalls();
    }

    public List<SubResource> firewallPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().firewallPolicies();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

